/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;
import org.apache.hadoop.yarn.util.TestProcfsBasedProcessTree;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestProcfsBasedProcessTree {
    private static final Log LOG = LogFactory.getLog(TestProcfsBasedProcessTree.class);
    protected static File TEST_ROOT_DIR = new File("target", TestProcfsBasedProcessTree.class.getName() + "-localDir");
    private Shell.ShellCommandExecutor shexec = null;
    private String pidFile;
    private String lowestDescendant;
    private String shellScript;
    private static final int N = 6;

    private String getRogueTaskPID() {
        File f = new File(this.pidFile);
        while (!f.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return TestProcfsBasedProcessTree.getPidFromPidFile((String)this.pidFile);
    }

    @Before
    public void setup() throws IOException {
        Assume.assumeTrue((boolean)Shell.LINUX);
        FileContext.getLocalFSFileContext().delete(new Path(TEST_ROOT_DIR.getAbsolutePath()), true);
    }

    @Test(timeout=30000L)
    public void testProcessTree() throws Exception {
        try {
            Assert.assertTrue((boolean)ProcfsBasedProcessTree.isAvailable());
        }
        catch (Exception e) {
            LOG.info((Object)StringUtils.stringifyException((Throwable)e));
            Assert.assertTrue((String)"ProcfsBaseProcessTree should be available on Linux", (boolean)false);
            return;
        }
        Random rm = new Random();
        File tempFile = new File(TEST_ROOT_DIR, this.getClass().getName() + "_shellScript_" + rm.nextInt() + ".sh");
        tempFile.deleteOnExit();
        this.shellScript = TEST_ROOT_DIR + File.separator + tempFile.getName();
        tempFile = new File(TEST_ROOT_DIR, this.getClass().getName() + "_pidFile_" + rm.nextInt() + ".pid");
        tempFile.deleteOnExit();
        this.pidFile = TEST_ROOT_DIR + File.separator + tempFile.getName();
        this.lowestDescendant = TEST_ROOT_DIR + File.separator + "lowestDescendantPidFile";
        try {
            FileWriter fWriter = new FileWriter(this.shellScript);
            fWriter.write("# rogue task\nsleep 1\necho hello\nif [ $1 -ne 0 ]\nthen\n sh " + this.shellScript + " $(($1-1))\n" + "else\n" + " echo $$ > " + this.lowestDescendant + "\n" + " while true\n do\n" + "  sleep 5\n" + " done\n" + "fi");
            fWriter.close();
        }
        catch (IOException ioe) {
            LOG.info((Object)("Error: " + ioe));
            return;
        }
        RogueTaskThread t = new RogueTaskThread(this, null);
        t.start();
        String pid = this.getRogueTaskPID();
        LOG.info((Object)("Root process pid: " + pid));
        ProcfsBasedProcessTree p = this.createProcessTree(pid);
        p.updateProcessTree();
        LOG.info((Object)("ProcessTree: " + p.toString()));
        File leaf = new File(this.lowestDescendant);
        while (!leaf.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        p.updateProcessTree();
        LOG.info((Object)("ProcessTree: " + p.toString()));
        String processTreeDump = p.getProcessTreeDump();
        this.destroyProcessTree(pid);
        boolean isAlive = true;
        for (int tries = 100; tries > 0 && (isAlive = TestProcfsBasedProcessTree.isSetsidAvailable() ? TestProcfsBasedProcessTree.isAnyProcessInTreeAlive((ProcfsBasedProcessTree)p) : TestProcfsBasedProcessTree.isAlive((String)pid)); --tries) {
            Thread.sleep(100L);
        }
        if (isAlive) {
            Assert.fail((String)"ProcessTree shouldn't be alive");
        }
        LOG.info((Object)("Process-tree dump follows: \n" + processTreeDump));
        Assert.assertTrue((String)"Process-tree dump doesn't start with a proper header", (boolean)processTreeDump.startsWith("\t|- PID PPID PGRPID SESSID CMD_NAME USER_MODE_TIME(MILLIS) SYSTEM_TIME(MILLIS) VMEM_USAGE(BYTES) RSSMEM_USAGE(PAGES) FULL_CMD_LINE\n"));
        for (int i = 6; i >= 0; --i) {
            String cmdLineDump = "\\|- [0-9]+ [0-9]+ [0-9]+ [0-9]+ \\(sh\\) [0-9]+ [0-9]+ [0-9]+ [0-9]+ sh " + this.shellScript + " " + i;
            Pattern pat = Pattern.compile(cmdLineDump);
            Matcher mat = pat.matcher(processTreeDump);
            Assert.assertTrue((String)("Process-tree dump doesn't contain the cmdLineDump of " + i + "th process!"), (boolean)mat.find());
        }
        try {
            t.join(2000L);
            LOG.info((Object)"RogueTaskThread successfully joined.");
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted while joining RogueTaskThread.");
        }
        p.updateProcessTree();
        Assert.assertFalse((String)"ProcessTree must have been gone", (boolean)TestProcfsBasedProcessTree.isAlive((String)pid));
        Assert.assertTrue((String)("Cumulative vmem for the gone-process is " + p.getCumulativeVmem() + " . It should be zero."), (p.getCumulativeVmem() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p.toString().equals("[ ]"));
    }

    protected ProcfsBasedProcessTree createProcessTree(String pid) {
        return new ProcfsBasedProcessTree(pid);
    }

    protected ProcfsBasedProcessTree createProcessTree(String pid, String procfsRootDir) {
        return new ProcfsBasedProcessTree(pid, procfsRootDir);
    }

    protected void destroyProcessTree(String pid) throws IOException {
        TestProcfsBasedProcessTree.sendSignal((String)pid, (int)9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPidFromPidFile(String pidFileName) {
        BufferedReader pidFile = null;
        FileReader fReader = null;
        String pid = null;
        try {
            fReader = new FileReader(pidFileName);
            pidFile = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            LOG.debug((Object)("PidFile doesn't exist : " + pidFileName));
            return pid;
        }
        try {
            pid = pidFile.readLine();
        }
        catch (IOException i) {
            LOG.error((Object)("Failed to read from " + pidFileName));
        }
        finally {
            try {
                if (fReader != null) {
                    fReader.close();
                }
                try {
                    if (pidFile != null) {
                        pidFile.close();
                    }
                }
                catch (IOException i) {
                    LOG.warn((Object)("Error closing the stream " + pidFile));
                }
            }
            catch (IOException i) {
                LOG.warn((Object)("Error closing the stream " + fReader));
            }
        }
        return pid;
    }

    public ProcfsBasedProcessTree.ProcessSmapMemoryInfo constructMemoryMappingInfo(String address, String[] entries) {
        ProcfsBasedProcessTree.ProcessSmapMemoryInfo info = new ProcfsBasedProcessTree.ProcessSmapMemoryInfo(address);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.SIZE.name(), entries[0]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.RSS.name(), entries[1]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.PSS.name(), entries[2]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.SHARED_CLEAN.name(), entries[3]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.SHARED_DIRTY.name(), entries[4]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.PRIVATE_CLEAN.name(), entries[5]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.PRIVATE_DIRTY.name(), entries[6]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.REFERENCED.name(), entries[7]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.ANONYMOUS.name(), entries[8]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.ANON_HUGE_PAGES.name(), entries[9]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.SWAP.name(), entries[10]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.KERNEL_PAGE_SIZE.name(), entries[11]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.MMU_PAGE_SIZE.name(), entries[12]);
        return info;
    }

    public void createMemoryMappingInfo(ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] procMemInfo) {
        for (int i = 0; i < procMemInfo.length; ++i) {
            List memoryMappingList = procMemInfo[i].getMemoryInfoList();
            memoryMappingList.add(this.constructMemoryMappingInfo("7f56c177c000-7f56c177d000 rw-p 00010000 08:02 40371558                   /grid/0/jdk1.7.0_25/jre/lib/amd64/libnio.so", new String[]{"4", "4", "25", "4", "25", "15", "10", "4", "0", "0", "0", "4", "4"}));
            memoryMappingList.add(this.constructMemoryMappingInfo("7fb09382e000-7fb09382f000 r--s 00003000 08:02 25953545", new String[]{"4", "4", "25", "4", "0", "15", "10", "4", "0", "0", "0", "4", "4"}));
            memoryMappingList.add(this.constructMemoryMappingInfo("7e8790000-7e8b80000 r-xs 00000000 00:00 0", new String[]{"4", "4", "25", "4", "0", "15", "10", "4", "0", "0", "0", "4", "4"}));
            memoryMappingList.add(this.constructMemoryMappingInfo("7da677000-7e0dcf000 rw-p 00000000 00:00 0", new String[]{"4", "4", "25", "4", "50", "15", "10", "4", "0", "0", "0", "4", "4"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCpuAndMemoryForProcessTree() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir((File)procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs((File)procfsRootDir, (String[])pids);
            ProcessStatInfo[] procInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "1000", "200"}), new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000", "200", "2000", "400"}), new ProcessStatInfo(new String[]{"300", "proc3", "200", "100", "100", "300000", "300", "3000", "600"}), new ProcessStatInfo(new String[]{"400", "proc4", "1", "400", "400", "400000", "400", "4000", "800"})};
            ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] memInfo = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("100"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("200"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("300"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("400")};
            this.createMemoryMappingInfo(memInfo);
            TestProcfsBasedProcessTree.writeStatFiles((File)procfsRootDir, (String[])pids, (ProcessStatInfo[])procInfos, (ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[])memInfo);
            Configuration conf = new Configuration();
            ProcfsBasedProcessTree processTree = this.createProcessTree("100", procfsRootDir.getAbsolutePath());
            processTree.setConf(conf);
            processTree.updateProcessTree();
            Assert.assertEquals((String)"Cumulative virtual memory does not match", (long)600000L, (long)processTree.getCumulativeVmem());
            long cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 600L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
            Assert.assertEquals((String)"Cumulative rss memory does not match", (long)cumuRssMem, (long)processTree.getCumulativeRssmem());
            long cumuCpuTime = ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS > 0L ? 7200L * ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS : 0L;
            Assert.assertEquals((String)"Cumulative cpu time does not match", (long)cumuCpuTime, (long)processTree.getCumulativeCpuTime());
            this.setSmapsInProceTree(processTree, true);
            Assert.assertEquals((String)"Cumulative rss memory does not match", (long)307200L, (long)processTree.getCumulativeRssmem());
            procInfos[0] = new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "2000", "300"});
            procInfos[1] = new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000", "200", "3000", "500"});
            TestProcfsBasedProcessTree.writeStatFiles((File)procfsRootDir, (String[])pids, (ProcessStatInfo[])procInfos, (ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[])memInfo);
            processTree.updateProcessTree();
            cumuCpuTime = ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS > 0L ? 9400L * ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS : 0L;
            Assert.assertEquals((String)"Cumulative cpu time does not match", (long)cumuCpuTime, (long)processTree.getCumulativeCpuTime());
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    private void setSmapsInProceTree(ProcfsBasedProcessTree processTree, boolean enableFlag) {
        Configuration conf = processTree.getConf();
        if (conf == null) {
            conf = new Configuration();
        }
        conf.setBoolean("yarn.nodemanager..container-monitor.procfs-tree.smaps-based-rss.enabled", enableFlag);
        processTree.setConf(conf);
        processTree.updateProcessTree();
    }

    @Test(timeout=30000L)
    public void testMemForOlderProcesses() throws IOException {
        this.testMemForOlderProcesses(false);
        this.testMemForOlderProcesses(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMemForOlderProcesses(boolean smapEnabled) throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            long cumuRssMem;
            TestProcfsBasedProcessTree.setupProcfsRootDir((File)procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs((File)procfsRootDir, (String[])pids);
            ProcessStatInfo[] procInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100"}), new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000", "200"}), new ProcessStatInfo(new String[]{"300", "proc3", "1", "300", "300", "300000", "300"}), new ProcessStatInfo(new String[]{"400", "proc4", "100", "100", "100", "400000", "400"})};
            ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] memInfo = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("100"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("200"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("300"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("400")};
            this.createMemoryMappingInfo(memInfo);
            TestProcfsBasedProcessTree.writeStatFiles((File)procfsRootDir, (String[])pids, (ProcessStatInfo[])procInfos, (ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[])memInfo);
            ProcfsBasedProcessTree processTree = this.createProcessTree("100", procfsRootDir.getAbsolutePath());
            this.setSmapsInProceTree(processTree, smapEnabled);
            Assert.assertEquals((String)"Cumulative memory does not match", (long)700000L, (long)processTree.getCumulativeVmem());
            String[] newPids = new String[]{"500"};
            TestProcfsBasedProcessTree.setupPidDirs((File)procfsRootDir, (String[])newPids);
            ProcessStatInfo[] newProcInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"500", "proc5", "100", "100", "100", "500000", "500"})};
            ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] newMemInfos = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("500")};
            this.createMemoryMappingInfo(newMemInfos);
            TestProcfsBasedProcessTree.writeStatFiles((File)procfsRootDir, (String[])newPids, (ProcessStatInfo[])newProcInfos, (ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[])newMemInfos);
            processTree.updateProcessTree();
            Assert.assertEquals((String)"Cumulative vmem does not include new process", (long)1200000L, (long)processTree.getCumulativeVmem());
            if (!smapEnabled) {
                cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 1200L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
                Assert.assertEquals((String)"Cumulative rssmem does not include new process", (long)cumuRssMem, (long)processTree.getCumulativeRssmem());
            } else {
                Assert.assertEquals((String)"Cumulative rssmem does not include new process", (long)409600L, (long)processTree.getCumulativeRssmem());
            }
            Assert.assertEquals((String)"Cumulative vmem shouldn't have included new process", (long)700000L, (long)processTree.getCumulativeVmem(1));
            if (!smapEnabled) {
                cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 700L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
                Assert.assertEquals((String)"Cumulative rssmem shouldn't have included new process", (long)cumuRssMem, (long)processTree.getCumulativeRssmem(1));
            } else {
                Assert.assertEquals((String)"Cumulative rssmem shouldn't have included new process", (long)307200L, (long)processTree.getCumulativeRssmem(1));
            }
            newPids = new String[]{"600"};
            TestProcfsBasedProcessTree.setupPidDirs((File)procfsRootDir, (String[])newPids);
            newProcInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"600", "proc6", "100", "100", "100", "600000", "600"})};
            newMemInfos = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("600")};
            this.createMemoryMappingInfo(newMemInfos);
            TestProcfsBasedProcessTree.writeStatFiles((File)procfsRootDir, (String[])newPids, (ProcessStatInfo[])newProcInfos, (ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[])newMemInfos);
            processTree.updateProcessTree();
            Assert.assertEquals((String)"Cumulative vmem shouldn't have included new processes", (long)700000L, (long)processTree.getCumulativeVmem(2));
            if (!smapEnabled) {
                cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 700L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
                Assert.assertEquals((String)"Cumulative rssmem shouldn't have included new processes", (long)cumuRssMem, (long)processTree.getCumulativeRssmem(2));
            } else {
                Assert.assertEquals((String)"Cumulative rssmem shouldn't have included new processes", (long)307200L, (long)processTree.getCumulativeRssmem(2));
            }
            Assert.assertEquals((String)"Cumulative vmem shouldn't have included new processes", (long)1200000L, (long)processTree.getCumulativeVmem(1));
            if (!smapEnabled) {
                cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 1200L * ProcfsBasedProcessTree.PAGE_SIZE : 0L;
                Assert.assertEquals((String)"Cumulative rssmem shouldn't have included new processes", (long)cumuRssMem, (long)processTree.getCumulativeRssmem(1));
            } else {
                Assert.assertEquals((String)"Cumulative rssmem shouldn't have included new processes", (long)409600L, (long)processTree.getCumulativeRssmem(1));
            }
            Assert.assertEquals((String)"Getting non-zero vmem for processes older than 3 iterations", (long)0L, (long)processTree.getCumulativeVmem(3));
            Assert.assertEquals((String)"Getting non-zero rssmem for processes older than 3 iterations", (long)0L, (long)processTree.getCumulativeRssmem(3));
            Assert.assertEquals((String)"Getting non-zero rssmem for processes older than 3 iterations", (long)0L, (long)processTree.getCumulativeRssmem(3));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDestroyProcessTree() throws IOException {
        String pid = "100";
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir((File)procfsRootDir);
            this.createProcessTree(pid, procfsRootDir.getAbsolutePath());
            Assert.assertTrue((boolean)ProcfsBasedProcessTree.checkPidPgrpidForMatch((String)pid, (String)procfsRootDir.getAbsolutePath()));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testProcessTreeDump() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400", "500", "600"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir((File)procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs((File)procfsRootDir, (String[])pids);
            int numProcesses = pids.length;
            ProcessStatInfo[] procInfos = new ProcessStatInfo[numProcesses];
            procInfos[0] = new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "1000", "200"});
            procInfos[1] = new ProcessStatInfo(new String[]{"200", "proc2", "100", "100", "100", "200000", "200", "2000", "400"});
            procInfos[2] = new ProcessStatInfo(new String[]{"300", "proc3", "200", "100", "100", "300000", "300", "3000", "600"});
            procInfos[3] = new ProcessStatInfo(new String[]{"400", "proc4", "200", "100", "100", "400000", "400", "4000", "800"});
            procInfos[4] = new ProcessStatInfo(new String[]{"500", "proc5", "400", "100", "100", "400000", "400", "4000", "800"});
            procInfos[5] = new ProcessStatInfo(new String[]{"600", "proc6", "1", "1", "1", "400000", "400", "4000", "800"});
            ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] memInfos = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("100"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("200"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("300"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("400"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("500"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("600")};
            String[] cmdLines = new String[numProcesses];
            cmdLines[0] = "proc1 arg1 arg2";
            cmdLines[1] = "proc2 arg3 arg4";
            cmdLines[2] = "proc3 arg5 arg6";
            cmdLines[3] = "proc4 arg7 arg8";
            cmdLines[4] = "proc5 arg9 arg10";
            cmdLines[5] = "proc6 arg11 arg12";
            this.createMemoryMappingInfo(memInfos);
            TestProcfsBasedProcessTree.writeStatFiles((File)procfsRootDir, (String[])pids, (ProcessStatInfo[])procInfos, (ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[])memInfos);
            TestProcfsBasedProcessTree.writeCmdLineFiles((File)procfsRootDir, (String[])pids, (String[])cmdLines);
            ProcfsBasedProcessTree processTree = this.createProcessTree("100", procfsRootDir.getAbsolutePath());
            processTree.updateProcessTree();
            String processTreeDump = processTree.getProcessTreeDump();
            LOG.info((Object)("Process-tree dump follows: \n" + processTreeDump));
            Assert.assertTrue((String)"Process-tree dump doesn't start with a proper header", (boolean)processTreeDump.startsWith("\t|- PID PPID PGRPID SESSID CMD_NAME USER_MODE_TIME(MILLIS) SYSTEM_TIME(MILLIS) VMEM_USAGE(BYTES) RSSMEM_USAGE(PAGES) FULL_CMD_LINE\n"));
            for (int i = 0; i < 5; ++i) {
                ProcessStatInfo p = procInfos[i];
                Assert.assertTrue((String)("Process-tree dump doesn't contain the cmdLineDump of process " + p.pid), (boolean)processTreeDump.contains("\t|- " + p.pid + " " + p.ppid + " " + p.pgrpId + " " + p.session + " (" + p.name + ") " + p.utime + " " + p.stime + " " + p.vmem + " " + p.rssmemPage + " " + cmdLines[i]));
            }
            ProcessStatInfo p = procInfos[5];
            Assert.assertFalse((String)("Process-tree dump shouldn't contain the cmdLineDump of process " + p.pid), (boolean)processTreeDump.contains("\t|- " + p.pid + " " + p.ppid + " " + p.pgrpId + " " + p.session + " (" + p.name + ") " + p.utime + " " + p.stime + " " + p.vmem + " " + cmdLines[5]));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isSetsidAvailable() {
        Shell.ShellCommandExecutor shexec = null;
        boolean setsidSupported = true;
        try {
            String[] args = new String[]{"setsid", "bash", "-c", "echo $$"};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"setsid is not available on this machine. So not using it.");
            setsidSupported = false;
        }
        finally {
            LOG.info((Object)("setsid exited with exit code " + shexec.getExitCode()));
        }
        return setsidSupported;
    }

    private static boolean isAlive(String pid) {
        try {
            String sigpid = TestProcfsBasedProcessTree.isSetsidAvailable() ? "-" + pid : pid;
            try {
                TestProcfsBasedProcessTree.sendSignal((String)sigpid, (int)0);
            }
            catch (Shell.ExitCodeException e) {
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void sendSignal(String pid, int signal) throws IOException {
        Shell.ShellCommandExecutor shexec = null;
        String[] arg = new String[]{"kill", "-" + signal, pid};
        shexec = new Shell.ShellCommandExecutor(arg);
        shexec.execute();
    }

    private static boolean isAnyProcessInTreeAlive(ProcfsBasedProcessTree processTree) {
        for (String pId : processTree.getCurrentProcessIDs()) {
            if (!TestProcfsBasedProcessTree.isAlive((String)pId)) continue;
            return true;
        }
        return false;
    }

    public static void setupProcfsRootDir(File procfsRootDir) throws IOException {
        if (procfsRootDir.exists()) {
            Assert.assertTrue((boolean)FileUtil.fullyDelete((File)procfsRootDir));
        }
        Assert.assertTrue((boolean)procfsRootDir.mkdirs());
    }

    public static void setupPidDirs(File procfsRootDir, String[] pids) throws IOException {
        for (String pid : pids) {
            File pidDir = new File(procfsRootDir, pid);
            pidDir.mkdir();
            if (!pidDir.exists()) {
                throw new IOException("couldn't make process directory under fake procfs");
            }
            LOG.info((Object)"created pid dir");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStatFiles(File procfsRootDir, String[] pids, ProcessStatInfo[] procs, ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] smaps) throws IOException {
        for (int i = 0; i < pids.length; ++i) {
            File statFile = new File(new File(procfsRootDir, pids[i]), "stat");
            BufferedWriter bw = null;
            try {
                FileWriter fw = new FileWriter(statFile);
                bw = new BufferedWriter(fw);
                bw.write(procs[i].getStatLine());
                LOG.info((Object)("wrote stat file for " + pids[i] + " with contents: " + procs[i].getStatLine()));
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            if (smaps == null) continue;
            File smapFile = new File(new File(procfsRootDir, pids[i]), "smaps");
            bw = null;
            try {
                FileWriter fw = new FileWriter(smapFile);
                bw = new BufferedWriter(fw);
                bw.write(smaps[i].toString());
                bw.flush();
                LOG.info((Object)("wrote smap file for " + pids[i] + " with contents: " + smaps[i].toString()));
                continue;
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCmdLineFiles(File procfsRootDir, String[] pids, String[] cmdLines) throws IOException {
        for (int i = 0; i < pids.length; ++i) {
            File statFile = new File(new File(procfsRootDir, pids[i]), "cmdline");
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(statFile));
                bw.write(cmdLines[i]);
                LOG.info((Object)("wrote command-line file for " + pids[i] + " with contents: " + cmdLines[i]));
                continue;
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
        }
    }

    static /* synthetic */ String access$000(TestProcfsBasedProcessTree x0) {
        return x0.pidFile;
    }

    static /* synthetic */ String access$100(TestProcfsBasedProcessTree x0) {
        return x0.shellScript;
    }

    static /* synthetic */ Shell.ShellCommandExecutor access$202(TestProcfsBasedProcessTree x0, Shell.ShellCommandExecutor x1) {
        x0.shexec = x1;
        return x0.shexec;
    }

    static /* synthetic */ Shell.ShellCommandExecutor access$200(TestProcfsBasedProcessTree x0) {
        return x0.shexec;
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }
}

