/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ContainerTokenIdentifier
extends TokenIdentifier {
    private static Log LOG = LogFactory.getLog(ContainerTokenIdentifier.class);
    public static final Text KIND = new Text("ContainerToken");
    private ContainerId containerId;
    private String nmHostAddr;
    private String appSubmitter;
    private Resource resource;
    private long expiryTimeStamp;
    private int masterKeyId;
    private long rmIdentifier;
    private Priority priority;
    private long creationTime;

    public ContainerTokenIdentifier(ContainerId containerID, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime) {
        this.containerId = containerID;
        this.nmHostAddr = hostName;
        this.appSubmitter = appSubmitter;
        this.resource = r;
        this.expiryTimeStamp = expiryTimeStamp;
        this.masterKeyId = masterKeyId;
        this.rmIdentifier = rmIdentifier;
        this.priority = priority;
        this.creationTime = creationTime;
    }

    public ContainerTokenIdentifier() {
    }

    public ContainerId getContainerID() {
        return this.containerId;
    }

    public String getApplicationSubmitter() {
        return this.appSubmitter;
    }

    public String getNmHostAddress() {
        return this.nmHostAddr;
    }

    public Resource getResource() {
        return this.resource;
    }

    public long getExpiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public int getMasterKeyId() {
        return this.masterKeyId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRMIdentifer() {
        return this.rmIdentifier;
    }

    public void write(DataOutput out) throws IOException {
        LOG.debug((Object)("Writing ContainerTokenIdentifier to RPC layer: " + this));
        ApplicationAttemptId applicationAttemptId = this.containerId.getApplicationAttemptId();
        ApplicationId applicationId = applicationAttemptId.getApplicationId();
        out.writeLong(applicationId.getClusterTimestamp());
        out.writeInt(applicationId.getId());
        out.writeInt(applicationAttemptId.getAttemptId());
        out.writeInt(this.containerId.getId());
        out.writeUTF(this.nmHostAddr);
        out.writeUTF(this.appSubmitter);
        out.writeInt(this.resource.getMemory());
        out.writeInt(this.resource.getVirtualCores());
        out.writeDouble(this.resource.getDisks());
        out.writeLong(this.expiryTimeStamp);
        out.writeInt(this.masterKeyId);
        out.writeLong(this.rmIdentifier);
        out.writeInt(this.priority.getPriority());
        out.writeLong(this.creationTime);
    }

    public void readFields(DataInput in) throws IOException {
        ApplicationId applicationId = ApplicationId.newInstance((long)in.readLong(), (int)in.readInt());
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)in.readInt());
        this.containerId = ContainerId.newInstance((ApplicationAttemptId)applicationAttemptId, (int)in.readInt());
        this.nmHostAddr = in.readUTF();
        this.appSubmitter = in.readUTF();
        int memory = in.readInt();
        int vCores = in.readInt();
        double disks = in.readDouble();
        this.resource = Resource.newInstance((int)memory, (int)vCores, (double)disks);
        this.expiryTimeStamp = in.readLong();
        this.masterKeyId = in.readInt();
        this.rmIdentifier = in.readLong();
        this.priority = Priority.newInstance((int)in.readInt());
        this.creationTime = in.readLong();
    }

    public Text getKind() {
        return KIND;
    }

    public UserGroupInformation getUser() {
        return UserGroupInformation.createRemoteUser((String)this.containerId.toString());
    }
}

