/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;
import org.apache.hadoop.yarn.logaggregation.TestAggregatedLogDeletionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAggregatedLogDeletionService {
    @Before
    public void closeFilesystems() throws IOException {
        FileSystem.closeAll();
    }

    @Test
    public void testDeletion() throws Exception {
        long now = System.currentTimeMillis();
        long toDeleteTime = now - 2000000L;
        long toKeepTime = now - 1500000L;
        String root = "mockfs://foo/";
        String remoteRootLogDir = root + "tmp/logs";
        String suffix = "logs";
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        conf.set("yarn.log-aggregation-enable", "true");
        conf.set("yarn.log-aggregation.retain-seconds", "1800");
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteRootLogDir);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", suffix);
        Path rootPath = new Path(root);
        FileSystem rootFs = rootPath.getFileSystem(conf);
        FileSystem mockFs = ((FilterFileSystem)rootFs).getRawFileSystem();
        Path remoteRootLogPath = new Path(remoteRootLogDir);
        Path userDir = new Path(remoteRootLogPath, "me");
        FileStatus userDirStatus = new FileStatus(0L, true, 0, 0L, toKeepTime, userDir);
        Mockito.when((Object)mockFs.listStatus(remoteRootLogPath)).thenReturn((Object)new FileStatus[]{userDirStatus});
        Path userLogDir = new Path(userDir, suffix);
        Path app1Dir = new Path(userLogDir, "application_1_1");
        FileStatus app1DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app1Dir);
        Path app2Dir = new Path(userLogDir, "application_1_2");
        FileStatus app2DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app2Dir);
        Path app3Dir = new Path(userLogDir, "application_1_3");
        FileStatus app3DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app3Dir);
        Path app4Dir = new Path(userLogDir, "application_1_4");
        FileStatus app4DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app4Dir);
        Mockito.when((Object)mockFs.listStatus(userLogDir)).thenReturn((Object)new FileStatus[]{app1DirStatus, app2DirStatus, app3DirStatus, app4DirStatus});
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenReturn((Object)new FileStatus[0]);
        Path app2Log1 = new Path(app2Dir, "host1");
        FileStatus app2Log1Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app2Log1);
        Path app2Log2 = new Path(app2Dir, "host2");
        FileStatus app2Log2Status = new FileStatus(10L, false, 1, 1L, toKeepTime, app2Log2);
        Mockito.when((Object)mockFs.listStatus(app2Dir)).thenReturn((Object)new FileStatus[]{app2Log1Status, app2Log2Status});
        Path app3Log1 = new Path(app3Dir, "host1");
        FileStatus app3Log1Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app3Log1);
        Path app3Log2 = new Path(app3Dir, "host2");
        FileStatus app3Log2Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app3Log2);
        Mockito.when((Object)mockFs.delete(app3Dir, true)).thenThrow(new Throwable[]{new AccessControlException("Injected Error\nStack Trace :(")});
        Mockito.when((Object)mockFs.listStatus(app3Dir)).thenReturn((Object)new FileStatus[]{app3Log1Status, app3Log2Status});
        Path app4Log1 = new Path(app4Dir, "host1");
        FileStatus app4Log1Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app4Log1);
        Path app4Log2 = new Path(app4Dir, "host2");
        FileStatus app4Log2Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app4Log2);
        Mockito.when((Object)mockFs.listStatus(app4Dir)).thenReturn((Object)new FileStatus[]{app4Log1Status, app4Log2Status});
        AggregatedLogDeletionService.LogDeletionTask task = new AggregatedLogDeletionService.LogDeletionTask(conf, 1800L);
        task.run();
        ((FileSystem)Mockito.verify((Object)mockFs)).delete(app1Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.times((int)0))).delete(app2Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs)).delete(app3Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs)).delete(app4Dir, true);
    }

    @Test
    public void testRefreshLogRetentionSettings() throws IOException {
        long now = System.currentTimeMillis();
        long before2000Secs = now - 2000000L;
        long before50Secs = now - 50000L;
        String root = "mockfs://foo/";
        String remoteRootLogDir = root + "tmp/logs";
        String suffix = "logs";
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        conf.set("yarn.log-aggregation-enable", "true");
        conf.set("yarn.log-aggregation.retain-seconds", "1800");
        conf.set("yarn.log-aggregation.retain-check-interval-seconds", "1");
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteRootLogDir);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", suffix);
        Path rootPath = new Path(root);
        FileSystem rootFs = rootPath.getFileSystem(conf);
        FileSystem mockFs = ((FilterFileSystem)rootFs).getRawFileSystem();
        Path remoteRootLogPath = new Path(remoteRootLogDir);
        Path userDir = new Path(remoteRootLogPath, "me");
        FileStatus userDirStatus = new FileStatus(0L, true, 0, 0L, before50Secs, userDir);
        Mockito.when((Object)mockFs.listStatus(remoteRootLogPath)).thenReturn((Object)new FileStatus[]{userDirStatus});
        Path userLogDir = new Path(userDir, suffix);
        Path app1Dir = new Path(userLogDir, "application_1_1");
        FileStatus app1DirStatus = new FileStatus(0L, true, 0, 0L, before2000Secs, app1Dir);
        Path app2Dir = new Path(userLogDir, "application_1_2");
        FileStatus app2DirStatus = new FileStatus(0L, true, 0, 0L, before50Secs, app2Dir);
        Mockito.when((Object)mockFs.listStatus(userLogDir)).thenReturn((Object)new FileStatus[]{app1DirStatus, app2DirStatus});
        Path app1Log1 = new Path(app1Dir, "host1");
        FileStatus app1Log1Status = new FileStatus(10L, false, 1, 1L, before2000Secs, app1Log1);
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenReturn((Object)new FileStatus[]{app1Log1Status});
        Path app2Log1 = new Path(app2Dir, "host1");
        FileStatus app2Log1Status = new FileStatus(10L, false, 1, 1L, before50Secs, app2Log1);
        Mockito.when((Object)mockFs.listStatus(app2Dir)).thenReturn((Object)new FileStatus[]{app2Log1Status});
        1 deletionSvc = new /* Unavailable Anonymous Inner Class!! */;
        deletionSvc.init(conf);
        deletionSvc.start();
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((int)10000))).delete(app1Dir, true);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((int)3000).times(0))).delete(app2Dir, true);
        conf.set("yarn.log-aggregation.retain-seconds", "50");
        conf.set("yarn.log-aggregation.retain-check-interval-seconds", "2");
        Assert.assertTrue((2000L != deletionSvc.getCheckIntervalMsecs() ? 1 : 0) != 0);
        deletionSvc.refreshLogRetentionSettings();
        Assert.assertTrue((2000L == deletionSvc.getCheckIntervalMsecs() ? 1 : 0) != 0);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((int)10000))).delete(app2Dir, true);
        deletionSvc.stop();
    }

    @Test
    public void testCheckInterval() throws Exception {
        long RETENTION_SECS = 864000L;
        long now = System.currentTimeMillis();
        long toDeleteTime = now - RETENTION_SECS * 1000L;
        String root = "mockfs://foo/";
        String remoteRootLogDir = root + "tmp/logs";
        String suffix = "logs";
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        conf.set("yarn.log-aggregation-enable", "true");
        conf.set("yarn.log-aggregation.retain-seconds", "864000");
        conf.set("yarn.log-aggregation.retain-check-interval-seconds", "1");
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteRootLogDir);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", suffix);
        FileSystem.closeAll();
        Path rootPath = new Path(root);
        FileSystem rootFs = rootPath.getFileSystem(conf);
        FileSystem mockFs = ((FilterFileSystem)rootFs).getRawFileSystem();
        Path remoteRootLogPath = new Path(remoteRootLogDir);
        Path userDir = new Path(remoteRootLogPath, "me");
        FileStatus userDirStatus = new FileStatus(0L, true, 0, 0L, now, userDir);
        Mockito.when((Object)mockFs.listStatus(remoteRootLogPath)).thenReturn((Object)new FileStatus[]{userDirStatus});
        Path userLogDir = new Path(userDir, suffix);
        Path app1Dir = new Path(userLogDir, "application_1_1");
        FileStatus app1DirStatus = new FileStatus(0L, true, 0, 0L, now, app1Dir);
        Mockito.when((Object)mockFs.listStatus(userLogDir)).thenReturn((Object)new FileStatus[]{app1DirStatus});
        Path app1Log1 = new Path(app1Dir, "host1");
        FileStatus app1Log1Status = new FileStatus(10L, false, 1, 1L, now, app1Log1);
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenReturn((Object)new FileStatus[]{app1Log1Status});
        AggregatedLogDeletionService deletionSvc = new AggregatedLogDeletionService();
        deletionSvc.init(conf);
        deletionSvc.start();
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((int)10000).atLeast(4))).listStatus((Path)Mockito.any(Path.class));
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete(app1Dir, true);
        app1DirStatus = new FileStatus(0L, true, 0, 0L, toDeleteTime, app1Dir);
        app1Log1Status = new FileStatus(10L, false, 1, 1L, toDeleteTime, app1Log1);
        Mockito.when((Object)mockFs.listStatus(userLogDir)).thenReturn((Object)new FileStatus[]{app1DirStatus});
        Mockito.when((Object)mockFs.listStatus(app1Dir)).thenReturn((Object)new FileStatus[]{app1Log1Status});
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.timeout((int)10000))).delete(app1Dir, true);
        deletionSvc.stop();
    }
}

