/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.hamlet;

import java.io.PrintWriter;
import java.util.EnumSet;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHamlet {
    @Test
    public void testHamlet() {
        Hamlet h = (Hamlet)((Hamlet)TestHamlet.newHamlet().title("test").h1("heading 1").p("#id.class").b("hello").em("world!")._()).div("#footer")._(new Object[]{"Brought to you by"}).a("http://hostname/", "Somebody")._();
        PrintWriter out = h.getWriter();
        out.flush();
        Assert.assertEquals((long)0L, (long)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out)).print("<title");
        ((PrintWriter)Mockito.verify((Object)out)).print("test");
        ((PrintWriter)Mockito.verify((Object)out)).print("</title>");
        ((PrintWriter)Mockito.verify((Object)out)).print("<h1");
        ((PrintWriter)Mockito.verify((Object)out)).print("heading 1");
        ((PrintWriter)Mockito.verify((Object)out)).print("</h1>");
        ((PrintWriter)Mockito.verify((Object)out)).print("<p");
        ((PrintWriter)Mockito.verify((Object)out)).print(" id=\"id\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(" class=\"class\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("<b");
        ((PrintWriter)Mockito.verify((Object)out)).print("hello");
        ((PrintWriter)Mockito.verify((Object)out)).print("</b>");
        ((PrintWriter)Mockito.verify((Object)out)).print("<em");
        ((PrintWriter)Mockito.verify((Object)out)).print("world!");
        ((PrintWriter)Mockito.verify((Object)out)).print("</em>");
        ((PrintWriter)Mockito.verify((Object)out)).print("<div");
        ((PrintWriter)Mockito.verify((Object)out)).print(" id=\"footer\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("Brought to you by");
        ((PrintWriter)Mockito.verify((Object)out)).print("<a");
        ((PrintWriter)Mockito.verify((Object)out)).print(" href=\"http://hostname/\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("Somebody");
        ((PrintWriter)Mockito.verify((Object)out)).print("</a>");
        ((PrintWriter)Mockito.verify((Object)out)).print("</div>");
        ((PrintWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.never())).print("</p>");
    }

    @Test
    public void testTable() {
        Hamlet h = TestHamlet.newHamlet().title("test table").link("style.css");
        Hamlet.TABLE t = h.table("#id");
        for (int i = 0; i < 3; ++i) {
            t.tr().td("1").td("2")._();
        }
        t._();
        PrintWriter out = h.getWriter();
        out.flush();
        Assert.assertEquals((long)0L, (long)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out)).print("<table");
        ((PrintWriter)Mockito.verify((Object)out)).print("</table>");
        ((PrintWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.never())).print("</td>");
        ((PrintWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.never())).print("</tr>");
    }

    @Test
    public void testEnumAttrs() {
        Hamlet h = (Hamlet)((Hamlet)TestHamlet.newHamlet().meta_http("Content-type", "text/html; charset=utf-8").title("test enum attrs").link().$rel("stylesheet").$media(EnumSet.of(HamletSpec.Media.screen, HamletSpec.Media.print)).$type("text/css").$href("style.css")._()).link().$rel(EnumSet.of(HamletSpec.LinkType.index, HamletSpec.LinkType.start)).$href("index.html")._();
        h.div("#content")._(new Object[]{"content"})._();
        PrintWriter out = h.getWriter();
        out.flush();
        Assert.assertEquals((long)0L, (long)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out)).print(" media=\"screen, print\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(" rel=\"start index\"");
    }

    @Test
    public void testScriptStyle() {
        Hamlet h = TestHamlet.newHamlet().script("a.js").script("b.js").style(new Object[]{"h1 { font-size: 1.2em }"});
        PrintWriter out = h.getWriter();
        out.flush();
        Assert.assertEquals((long)0L, (long)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)2))).print(" type=\"text/javascript\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(" type=\"text/css\"");
    }

    @Test
    public void testPreformatted() {
        Hamlet h = (Hamlet)((Hamlet.DIV)TestHamlet.newHamlet().div().i("inline before pre").pre()._(new Object[]{"pre text1\npre text2"}).i("inline in pre")._(new Object[]{"pre text after inline"})._()).i("inline after pre")._();
        PrintWriter out = h.getWriter();
        out.flush();
        Assert.assertEquals((long)5L, (long)h.indents);
    }

    @Test
    public void testSubViews() {
        Hamlet h = (Hamlet)((Hamlet)TestHamlet.newHamlet().title("test sub-views").div("#view1")._(TestView1.class)._()).div("#view2")._(TestView2.class)._();
        PrintWriter out = h.getWriter();
        out.flush();
        Assert.assertEquals((long)0L, (long)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out)).print("[" + TestView1.class.getName() + "]");
        ((PrintWriter)Mockito.verify((Object)out)).print("[" + TestView2.class.getName() + "]");
    }

    static Hamlet newHamlet() {
        PrintWriter out = (PrintWriter)Mockito.spy((Object)new PrintWriter(System.out));
        return new Hamlet(out, 0, false);
    }

    static class TestView2
    implements SubView {
        TestView2() {
        }

        public void renderPartial() {
        }
    }

    static class TestView1
    implements SubView {
        TestView1() {
        }

        public void renderPartial() {
        }
    }
}

