/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.hamlet;

import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestParseSelector {
    @Test
    public void testNormal() {
        String[] res = HamletImpl.parseSelector((String)"#id.class");
        Assert.assertEquals((Object)"id", (Object)res[0]);
        Assert.assertEquals((Object)"class", (Object)res[1]);
    }

    @Test
    public void testMultiClass() {
        String[] res = HamletImpl.parseSelector((String)"#id.class1.class2");
        Assert.assertEquals((Object)"id", (Object)res[0]);
        Assert.assertEquals((Object)"class1 class2", (Object)res[1]);
    }

    @Test
    public void testMissingId() {
        String[] res = HamletImpl.parseSelector((String)".class");
        Assert.assertNull((Object)res[0]);
        Assert.assertEquals((Object)"class", (Object)res[1]);
    }

    @Test
    public void testMissingClass() {
        String[] res = HamletImpl.parseSelector((String)"#id");
        Assert.assertEquals((Object)"id", (Object)res[0]);
        Assert.assertNull((Object)res[1]);
    }

    @Test(expected=WebAppException.class)
    public void testMissingAll() {
        HamletImpl.parseSelector((String)"");
    }
}

