/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiskBasedDominantResourceCalculator
extends DominantResourceCalculator {
    private static final Log LOG = LogFactory.getLog(DiskBasedDominantResourceCalculator.class);
    private static final double ZERO_LIMIT = 0.0099999999999999;

    private static boolean isZero(double a) {
        return !(Math.abs(a) > 0.0099999999999999);
    }

    public static double divideAndCeilDouble(double a, double b) {
        if (DiskBasedDominantResourceCalculator.isZero((double)b)) {
            LOG.info((Object)("divideAndCeilDouble called with a=" + a + " b=" + b));
            return 0.0;
        }
        return Math.ceil(a / b);
    }

    public static double roundUpDisk(double a, double b) {
        return DiskBasedDominantResourceCalculator.isZero((double)b) ? a : DiskBasedDominantResourceCalculator.divideAndCeilDouble((double)a, (double)b) * b;
    }

    public static double divideAndFloorDouble(double a, double b) {
        if (DiskBasedDominantResourceCalculator.isZero((double)b)) {
            LOG.info((Object)("divideAndFloorDouble called with a=" + a + " b=" + b));
            return 0.0;
        }
        return Math.floor(a / b);
    }

    public static double roundDownDisk(double a, double b) {
        return DiskBasedDominantResourceCalculator.isZero((double)b) ? a : DiskBasedDominantResourceCalculator.divideAndFloorDouble((double)a, (double)b) * b;
    }

    protected float getResourceAsValue(Resource clusterResource, Resource resource, boolean dominant) {
        return dominant ? Math.max(Math.max((float)resource.getMemory() / (float)clusterResource.getMemory(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores()), (float)(resource.getDisks() / clusterResource.getDisks())) : Math.min(Math.min((float)resource.getMemory() / (float)clusterResource.getMemory(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores()), (float)(resource.getDisks() / clusterResource.getDisks()));
    }

    public int computeAvailableContainers(Resource available, Resource required) {
        int min = Math.min(available.getMemory() / required.getMemory(), available.getVirtualCores() / required.getVirtualCores());
        if (!DiskBasedDominantResourceCalculator.isZero((double)required.getDisks())) {
            min = Math.min(min, (int)(available.getDisks() / required.getDisks()));
        }
        return min;
    }

    public float ratio(Resource a, Resource b) {
        float max = Math.max((float)a.getMemory() / (float)b.getMemory(), (float)a.getVirtualCores() / (float)b.getVirtualCores());
        if (!DiskBasedDominantResourceCalculator.isZero((double)b.getDisks())) {
            max = Math.max(max, (float)(a.getDisks() / b.getDisks()));
        }
        return max;
    }

    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource((int)DiskBasedDominantResourceCalculator.divideAndCeil((int)numerator.getMemory(), (int)denominator), (int)DiskBasedDominantResourceCalculator.divideAndCeil((int)numerator.getVirtualCores(), (int)denominator), (double)DiskBasedDominantResourceCalculator.divideAndCeilDouble((double)numerator.getDisks(), (double)denominator));
    }

    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        int normalizedMemory = Math.min(DiskBasedDominantResourceCalculator.roundUp((int)Math.max(r.getMemory(), minimumResource.getMemory()), (int)stepFactor.getMemory()), maximumResource.getMemory());
        int normalizedCores = Math.min(DiskBasedDominantResourceCalculator.roundUp((int)Math.max(r.getVirtualCores(), minimumResource.getVirtualCores()), (int)stepFactor.getVirtualCores()), maximumResource.getVirtualCores());
        double normalizedDisk = Math.min(DiskBasedDominantResourceCalculator.roundUpDisk((double)Math.max(r.getDisks(), minimumResource.getDisks()), (double)stepFactor.getDisks()), maximumResource.getDisks());
        return Resources.createResource((int)normalizedMemory, (int)normalizedCores, (double)normalizedDisk);
    }

    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource((int)DiskBasedDominantResourceCalculator.roundUp((int)r.getMemory(), (int)stepFactor.getMemory()), (int)DiskBasedDominantResourceCalculator.roundUp((int)r.getVirtualCores(), (int)stepFactor.getVirtualCores()), (double)DiskBasedDominantResourceCalculator.roundUpDisk((double)r.getDisks(), (double)stepFactor.getDisks()));
    }

    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource((int)DiskBasedDominantResourceCalculator.roundDown((int)r.getMemory(), (int)stepFactor.getMemory()), (int)DiskBasedDominantResourceCalculator.roundDown((int)r.getVirtualCores(), (int)stepFactor.getVirtualCores()), (double)DiskBasedDominantResourceCalculator.roundDownDisk((double)r.getDisks(), (double)stepFactor.getDisks()));
    }

    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource((int)DiskBasedDominantResourceCalculator.roundUp((int)((int)Math.ceil((double)r.getMemory() * by)), (int)stepFactor.getMemory()), (int)DiskBasedDominantResourceCalculator.roundUp((int)((int)Math.ceil((double)r.getVirtualCores() * by)), (int)stepFactor.getVirtualCores()), (double)DiskBasedDominantResourceCalculator.roundUpDisk((double)(r.getDisks() * by), (double)stepFactor.getDisks()));
    }

    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource((int)DiskBasedDominantResourceCalculator.roundDown((int)((int)((double)r.getMemory() * by)), (int)stepFactor.getMemory()), (int)DiskBasedDominantResourceCalculator.roundDown((int)((int)((double)r.getVirtualCores() * by)), (int)stepFactor.getVirtualCores()), (double)DiskBasedDominantResourceCalculator.roundDownDisk((double)(r.getDisks() * by), (double)stepFactor.getDisks()));
    }
}

