/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import com.google.inject.Injector;
import java.io.PrintWriter;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHtmlPage {
    @Test
    public void testUsual() {
        Injector injector = WebAppTests.testPage(TestView.class);
        PrintWriter out = (PrintWriter)injector.getInstance(PrintWriter.class);
        ((PrintWriter)Mockito.verify((Object)out)).print("test");
        ((PrintWriter)Mockito.verify((Object)out)).print(" id=\"testid\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("test note");
    }

    @Test(expected=WebAppException.class)
    public void testShort() {
        WebAppTests.testPage(ShortView.class);
    }

    public static class ShortView
    extends HtmlPage {
        public void render(Hamlet.HTML<HtmlPage._> html) {
            html.title("short test").p()._(new Object[]{"should throw"});
        }
    }

    public static class TestView
    extends HtmlPage {
        public void render(Hamlet.HTML<HtmlPage._> html) {
            ((Hamlet.HTML)html.title("test").p("#testid")._(new Object[]{"test note"})._())._();
        }
    }
}

