/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.util.LinuxResourceCalculatorPlugin;
import org.junit.Test;

public class TestLinuxResourceCalculatorPlugin
extends TestCase {
    private static final FakeLinuxResourceCalculatorPlugin plugin;
    private static String TEST_ROOT_DIR;
    private static final String FAKE_MEMFILE;
    private static final String FAKE_CPUFILE;
    private static final String FAKE_STATFILE;
    private static final long FAKE_JIFFY_LENGTH = 10L;
    static final String MEMINFO_FORMAT = "MemTotal:      %d kB\nMemFree:         %d kB\nBuffers:        138244 kB\nCached:         947780 kB\nSwapCached:     142880 kB\nActive:        3229888 kB\nInactive:       %d kB\nSwapTotal:     %d kB\nSwapFree:      %d kB\nDirty:          122012 kB\nWriteback:           0 kB\nAnonPages:     2710792 kB\nMapped:          24740 kB\nSlab:           132528 kB\nSReclaimable:   105096 kB\nSUnreclaim:      27432 kB\nPageTables:      11448 kB\nNFS_Unstable:        0 kB\nBounce:              0 kB\nCommitLimit:   4125904 kB\nCommitted_AS:  4143556 kB\nVmallocTotal: 34359738367 kB\nVmallocUsed:      1632 kB\nVmallocChunk: 34359736375 kB\nHugePages_Total:     0\nHugePages_Free:      0\nHugePages_Rsvd:      0\nHugepagesize:     2048 kB";
    static final String CPUINFO_FORMAT = "processor : %s\nvendor_id : AuthenticAMD\ncpu family  : 15\nmodel   : 33\nmodel name  : Dual Core AMD Opteron(tm) Processor 280\nstepping  : 2\ncpu MHz   : %f\ncache size  : 1024 KB\nphysical id : 0\nsiblings  : 2\ncore id   : 0\ncpu cores : 2\nfpu   : yes\nfpu_exception : yes\ncpuid level : 1\nwp    : yes\nflags   : fpu vme de pse tsc msr pae mce cx8 apic sep mtrr pge mca cmov pat pse36 clflush mmx fxsr sse sse2 ht syscall nx mmxext fxsr_opt lm 3dnowext 3dnow pni lahf_lm cmp_legacy\nbogomips  : 4792.41\nTLB size  : 1024 4K pages\nclflush size  : 64\ncache_alignment : 64\naddress sizes : 40 bits physical, 48 bits virtual\npower management: ts fid vid ttp";
    static final String STAT_FILE_FORMAT = "cpu  %d %d %d 1646495089 831319 48713 164346 0\ncpu0 15096055 30805 3823005 411456015 206027 13 14269 0\ncpu1 14760561 89890 6432036 408707910 456857 48074 130857 0\ncpu2 12761169 20842 3758639 413976772 98028 411 10288 0\ncpu3 12355207 47322 5789691 412354390 70406 213 8931 0\nintr 114648668 20010764 2 0 945665 2 0 0 0 0 0 0 0 4 0 0 0 0 0 0\nctxt 242017731764\nbtime 1257808753\nprocesses 26414943\nprocs_running 1\nprocs_blocked 0\n";

    @Test
    public void testParsingProcStatAndCpuFile() throws IOException {
        long numProcessors = 8L;
        long cpuFrequencyKHz = 2392781L;
        String fileContent = "";
        int i = 0;
        while ((long)i < numProcessors) {
            fileContent = fileContent + String.format(CPUINFO_FORMAT, i, (double)cpuFrequencyKHz / 1000.0) + "\n";
            ++i;
        }
        File tempFile = new File(FAKE_CPUFILE);
        tempFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(FAKE_CPUFILE);
        fWriter.write(fileContent);
        fWriter.close();
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getNumProcessors(), (long)numProcessors);
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getCpuFrequency(), (long)cpuFrequencyKHz);
        long uTime = 54972994L;
        long nTime = 188860L;
        long sTime = 19803373L;
        tempFile = new File(FAKE_STATFILE);
        tempFile.deleteOnExit();
        this.updateStatFile(uTime, nTime, sTime);
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getCumulativeCpuTime(), (long)(10L * (uTime + nTime + sTime)));
        TestLinuxResourceCalculatorPlugin.assertEquals((Object)Float.valueOf(plugin.getCpuUsage()), (Object)Float.valueOf(-1.0f));
        plugin.advanceTime(200L);
        this.updateStatFile(uTime += 100L, nTime, sTime);
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getCumulativeCpuTime(), (long)(10L * (uTime + nTime + sTime)));
        TestLinuxResourceCalculatorPlugin.assertEquals((Object)Float.valueOf(plugin.getCpuUsage()), (Object)Float.valueOf(6.25f));
        plugin.advanceTime(300L);
        this.updateStatFile(uTime += 600L, nTime, sTime);
        TestLinuxResourceCalculatorPlugin.assertEquals((Object)Float.valueOf(plugin.getCpuUsage()), (Object)Float.valueOf(25.0f));
        plugin.advanceTime(1L);
        this.updateStatFile(++uTime, nTime, sTime);
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getCumulativeCpuTime(), (long)(10L * (uTime + nTime + sTime)));
        TestLinuxResourceCalculatorPlugin.assertEquals((Object)Float.valueOf(plugin.getCpuUsage()), (Object)Float.valueOf(25.0f));
    }

    private void updateStatFile(long uTime, long nTime, long sTime) throws IOException {
        FileWriter fWriter = new FileWriter(FAKE_STATFILE);
        fWriter.write(String.format(STAT_FILE_FORMAT, uTime, nTime, sTime));
        fWriter.close();
    }

    @Test
    public void testParsingProcMemFile() throws IOException {
        long memTotal = 4058864L;
        long memFree = 99632L;
        long inactive = 567732L;
        long swapTotal = 2096472L;
        long swapFree = 1818480L;
        File tempFile = new File(FAKE_MEMFILE);
        tempFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(FAKE_MEMFILE);
        fWriter.write(String.format(MEMINFO_FORMAT, memTotal, memFree, inactive, swapTotal, swapFree));
        fWriter.close();
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getAvailablePhysicalMemorySize(), (long)(1024L * (memFree + inactive)));
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getAvailableVirtualMemorySize(), (long)(1024L * (memFree + inactive + swapFree)));
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getPhysicalMemorySize(), (long)(1024L * memTotal));
        TestLinuxResourceCalculatorPlugin.assertEquals((long)plugin.getVirtualMemorySize(), (long)(1024L * (memTotal + swapTotal)));
    }

    static {
        TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        int randomNum = new Random().nextInt(1000000000);
        FAKE_MEMFILE = TEST_ROOT_DIR + File.separator + "MEMINFO_" + randomNum;
        FAKE_CPUFILE = TEST_ROOT_DIR + File.separator + "CPUINFO_" + randomNum;
        FAKE_STATFILE = TEST_ROOT_DIR + File.separator + "STATINFO_" + randomNum;
        plugin = new FakeLinuxResourceCalculatorPlugin(FAKE_MEMFILE, FAKE_CPUFILE, FAKE_STATFILE, 10L);
    }

    static class FakeLinuxResourceCalculatorPlugin
    extends LinuxResourceCalculatorPlugin {
        long currentTime = 0L;

        public FakeLinuxResourceCalculatorPlugin(String procfsMemFile, String procfsCpuFile, String procfsStatFile, long jiffyLengthInMillis) {
            super(procfsMemFile, procfsCpuFile, procfsStatFile, jiffyLengthInMillis);
        }

        long getCurrentTime() {
            return this.currentTime;
        }

        public void advanceTime(long adv) {
            this.currentTime += adv * this.jiffyLengthInMillis;
        }
    }
}

