/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;

public class DrainDispatcher
extends AsyncDispatcher {
    private volatile boolean drained = false;
    private final BlockingQueue<Event> queue;

    public DrainDispatcher() {
        this(new LinkedBlockingQueue<Event>());
    }

    private DrainDispatcher(BlockingQueue<Event> eventQueue) {
        super(eventQueue);
        this.queue = eventQueue;
    }

    public void await() {
        while (!this.drained) {
            Thread.yield();
        }
    }

    Runnable createThread() {
        return new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    Event event;
                    DrainDispatcher.this.drained = DrainDispatcher.this.queue.isEmpty();
                    try {
                        event = (Event)DrainDispatcher.this.queue.take();
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                    if (event == null) continue;
                    DrainDispatcher.this.dispatch(event);
                }
            }
        };
    }

    public EventHandler getEventHandler() {
        final EventHandler actual = super.getEventHandler();
        return new EventHandler(){

            public void handle(Event event) {
                DrainDispatcher.this.drained = false;
                actual.handle(event);
            }
        };
    }
}

