/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.Params;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.ToJSON;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.view.DefaultPage;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class Controller
implements Params {
    public static final Logger LOG = LoggerFactory.getLogger(Controller.class);
    static final ObjectMapper jsonMapper = new ObjectMapper();
    private RequestContext context;
    @Inject
    Injector injector;

    public Controller() {
    }

    public Controller(RequestContext ctx) {
        this.context = ctx;
    }

    public RequestContext context() {
        if (this.context == null) {
            if (this.injector == null) {
                throw new WebAppException(StringHelper.join((Object[])new Object[]{"Error accessing RequestContext from\n", "a child constructor, either move the usage of the Controller\n", "methods out of the constructor or inject the RequestContext\n", "into the constructor"}));
            }
            this.context = (RequestContext)this.injector.getInstance(RequestContext.class);
        }
        return this.context;
    }

    public Throwable error() {
        return this.context().error;
    }

    public int status() {
        return this.context().status;
    }

    public void setStatus(int status) {
        this.context().setStatus(status);
    }

    public boolean inDevMode() {
        return this.context().devMode;
    }

    public Injector injector() {
        return this.context().injector;
    }

    public <T> T getInstance(Class<T> cls) {
        return (T)this.injector.getInstance(cls);
    }

    public HttpServletRequest request() {
        return this.context().request;
    }

    public HttpServletResponse response() {
        return this.context().response;
    }

    public void set(String key, String value) {
        this.context().set(key, value);
    }

    public String get(String key, String defaultValue) {
        return this.context().get(key, defaultValue);
    }

    public String $(String key) {
        return this.get(key, "");
    }

    public void setTitle(String title) {
        this.set("title", title);
    }

    public void setTitle(String title, String url) {
        this.setTitle(title);
        this.set("title.href", url);
    }

    public ResponseInfo info(String about) {
        return ((ResponseInfo)this.getInstance(ResponseInfo.class)).about(about);
    }

    public Map<String, Cookie> cookies() {
        return this.context().cookies();
    }

    public String url(String ... parts) {
        return StringHelper.ujoin((String)this.context().prefix, (String[])parts);
    }

    public abstract void index();

    public void echo() {
        this.render(DefaultPage.class);
    }

    protected void render(Class<? extends View> cls) {
        this.context().rendered = true;
        ((View)this.getInstance(cls)).render();
    }

    protected void renderJSON(Object object) {
        LOG.debug("{}: {}", (Object)"application/json; charset=UTF-8", object);
        this.context().rendered = true;
        this.context().response.setContentType("application/json; charset=UTF-8");
        try {
            jsonMapper.writeValue((Writer)this.writer(), object);
        }
        catch (Exception e) {
            throw new WebAppException((Throwable)e);
        }
    }

    protected void renderJSON(Class<? extends ToJSON> cls) {
        this.context().rendered = true;
        this.response().setContentType("application/json; charset=UTF-8");
        ((ToJSON)this.getInstance(cls)).toJSON(this.writer());
    }

    protected void renderText(String s) {
        LOG.debug("{}: {}", (Object)"text/plain; charset=UTF-8", (Object)s);
        this.context().rendered = true;
        this.response().setContentType("text/plain; charset=UTF-8");
        this.writer().print(s);
    }

    protected PrintWriter writer() {
        try {
            return this.response().getWriter();
        }
        catch (Exception e) {
            throw new WebAppException((Throwable)e);
        }
    }
}

