/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RMProxy<T> {
    private static final Log LOG = LogFactory.getLog(RMProxy.class);

    public static <T> T createRMProxy(Configuration conf, Class<T> protocol, InetSocketAddress rmAddress) throws IOException {
        RetryPolicy retryPolicy = RMProxy.createRetryPolicy((Configuration)conf);
        Object proxy = RMProxy.getProxy((Configuration)conf, protocol, (InetSocketAddress)rmAddress);
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        return (T)RetryProxy.create(protocol, (Object)proxy, (RetryPolicy)retryPolicy);
    }

    private static <T> T getProxy(Configuration conf, Class<T> protocol, InetSocketAddress rmAddress) throws IOException {
        return (T)UserGroupInformation.getCurrentUser().doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static RetryPolicy createRetryPolicy(Configuration conf) {
        boolean waitForEver;
        long rmConnectWaitMS = conf.getInt("yarn.resourcemanager.connect.max-wait.ms", 900000);
        long rmConnectionRetryIntervalMS = conf.getLong("yarn.resourcemanager.connect.retry-interval.ms", 30000L);
        if (rmConnectionRetryIntervalMS < 0L) {
            throw new YarnRuntimeException("Invalid Configuration. yarn.resourcemanager.connect.retry-interval.ms should not be negative.");
        }
        boolean bl = waitForEver = rmConnectWaitMS == -1L;
        if (waitForEver) {
            return RetryPolicies.RETRY_FOREVER;
        }
        if (rmConnectWaitMS < 0L) {
            throw new YarnRuntimeException("Invalid Configuration. yarn.resourcemanager.connect.max-wait.ms can be -1, but can not be other negative numbers");
        }
        if (rmConnectWaitMS < rmConnectionRetryIntervalMS) {
            LOG.warn((Object)"yarn.resourcemanager.connect.max-wait.ms is smaller than yarn.resourcemanager.connect.retry-interval.ms. Only try connect once.");
            rmConnectWaitMS = 0L;
        }
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)rmConnectWaitMS, (long)rmConnectionRetryIntervalMS, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class, RetryPolicy> exceptionToPolicyMap = new HashMap<Class, RetryPolicy>();
        exceptionToPolicyMap.put(ConnectException.class, retryPolicy);
        exceptionToPolicyMap.put(IOException.class, retryPolicy);
        return RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
    }
}

