/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.Router;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
class Router {
    static final Logger LOG = LoggerFactory.getLogger(Router.class);
    static final ImmutableList<String> EMPTY_LIST = ImmutableList.of();
    static final CharMatcher SLASH = CharMatcher.is((char)'/');
    static final Pattern controllerRe = Pattern.compile("^/[A-Za-z_]\\w*(?:/.*)?");
    Class<?> hostClass;
    final TreeMap<String, Dest> routes = Maps.newTreeMap();

    Router() {
    }

    synchronized Dest add(WebApp.HTTP httpMethod, String path, Class<? extends Controller> cls, String action, List<String> names) {
        LOG.debug("adding {}({})->{}#{}", new Object[]{path, names, cls, action});
        Dest dest = this.addController(httpMethod, path, cls, action, names);
        this.addDefaultView(dest);
        return dest;
    }

    private Dest addController(WebApp.HTTP httpMethod, String path, Class<? extends Controller> cls, String action, List<String> names) {
        try {
            Method method = cls.getMethod(action, null);
            Dest dest = (Dest)this.routes.get(path);
            if (dest == null) {
                method.setAccessible(true);
                dest = new Dest(path, method, cls, names, httpMethod);
                this.routes.put(path, dest);
                return dest;
            }
            dest.methods.add(httpMethod);
            return dest;
        }
        catch (NoSuchMethodException nsme) {
            throw new WebAppException(action + "() not found in " + cls);
        }
        catch (SecurityException se) {
            throw new WebAppException("Security exception thrown for " + action + "() in " + cls);
        }
    }

    private void addDefaultView(Dest dest) {
        String controllerName = dest.controllerClass.getSimpleName();
        if (controllerName.endsWith("Controller")) {
            controllerName = controllerName.substring(0, controllerName.length() - 10);
        }
        dest.defaultViewClass = this.find(View.class, dest.controllerClass.getPackage().getName(), StringHelper.join((Object[])new Object[]{controllerName + "View"}));
    }

    void setHostClass(Class<?> cls) {
        this.hostClass = cls;
    }

    synchronized Dest resolve(String httpMethod, String path) {
        WebApp.HTTP method = WebApp.HTTP.valueOf((String)httpMethod);
        Dest dest = this.lookupRoute(method, path);
        if (dest == null) {
            return this.resolveDefault(method, path);
        }
        return dest;
    }

    private Dest lookupRoute(WebApp.HTTP method, String path) {
        String key = path;
        while (true) {
            Dest dest;
            if ((dest = (Dest)this.routes.get(key)) != null && Router.methodAllowed((WebApp.HTTP)method, (Dest)dest)) {
                if (key == path) {
                    LOG.debug("exact match for {}: {}", (Object)key, (Object)dest.action);
                    return dest;
                }
                if (Router.isGoodMatch((Dest)dest, (String)path)) {
                    LOG.debug("prefix match2 for {}: {}", (Object)key, (Object)dest.action);
                    return dest;
                }
                return this.resolveAction(method, dest, path);
            }
            Map.Entry lower = this.routes.lowerEntry(key);
            if (lower == null) {
                return null;
            }
            dest = (Dest)lower.getValue();
            if (Router.prefixMatches((Dest)dest, (String)path)) {
                if (Router.methodAllowed((WebApp.HTTP)method, (Dest)dest)) {
                    if (Router.isGoodMatch((Dest)dest, (String)path)) {
                        LOG.debug("prefix match for {}: {}", (Object)lower.getKey(), (Object)dest.action);
                        return dest;
                    }
                    return this.resolveAction(method, dest, path);
                }
                int slashPos = key.lastIndexOf(47);
                key = slashPos > 0 ? path.substring(0, slashPos) : "/";
                continue;
            }
            key = "/";
        }
    }

    static boolean methodAllowed(WebApp.HTTP method, Dest dest) {
        return dest.methods.contains(method) || dest.methods.size() == 1 && dest.methods.contains(WebApp.HTTP.GET);
    }

    static boolean prefixMatches(Dest dest, String path) {
        LOG.debug("checking prefix {}{} for path: {}", new Object[]{dest.prefix, dest.pathParams, path});
        if (!path.startsWith(dest.prefix)) {
            return false;
        }
        int prefixLen = dest.prefix.length();
        return prefixLen <= 1 || path.length() <= prefixLen || path.charAt(prefixLen) == '/';
    }

    static boolean isGoodMatch(Dest dest, String path) {
        if (SLASH.countIn((CharSequence)dest.prefix) > 1) {
            return true;
        }
        if (dest.prefix.length() == 1) {
            return dest.pathParams.size() > 0 && !Router.maybeController((String)path);
        }
        return dest.pathParams.size() > 0 || path.endsWith("/") && SLASH.countIn((CharSequence)path) == 2;
    }

    static boolean maybeController(String path) {
        return controllerRe.matcher(path).matches();
    }

    private Dest resolveDefault(WebApp.HTTP method, String path) {
        List parts = WebApp.parseRoute((String)path);
        String controller = (String)parts.get(1);
        String action = (String)parts.get(2);
        Class cls = this.find(Controller.class, StringHelper.join((Object[])new Object[]{controller, "Controller"}));
        if (cls == null) {
            cls = this.find(Controller.class, controller);
        }
        if (cls == null) {
            throw new WebAppException(StringHelper.join((Object[])new Object[]{path, ": controller for ", controller, " not found"}));
        }
        return this.add(method, this.defaultPrefix(controller, action), cls, action, null);
    }

    private String defaultPrefix(String controller, String action) {
        if (controller.equals("default") && action.equals("index")) {
            return "/";
        }
        if (action.equals("index")) {
            return StringHelper.join((Object[])new Object[]{Character.valueOf('/'), controller});
        }
        return StringHelper.pjoin((Object[])new Object[]{"", controller, action});
    }

    private <T> Class<? extends T> find(Class<T> cls, String cname) {
        String pkg = this.hostClass.getPackage().getName();
        return this.find(cls, pkg, cname);
    }

    private <T> Class<? extends T> find(Class<T> cls, String pkg, String cname) {
        String name = StringUtils.capitalize((String)cname);
        Class found = this.load(cls, StringHelper.djoin((Object[])new Object[]{pkg, name}));
        if (found == null) {
            found = this.load(cls, StringHelper.djoin((Object[])new Object[]{pkg, "webapp", name}));
        }
        if (found == null) {
            found = this.load(cls, StringHelper.join((Object[])new Object[]{this.hostClass.getName(), Character.valueOf('$'), name}));
        }
        return found;
    }

    private <T> Class<? extends T> load(Class<T> cls, String className) {
        LOG.debug("trying: {}", (Object)className);
        try {
            Class<?> found = Class.forName(className);
            if (cls.isAssignableFrom(found)) {
                LOG.debug("found {}", (Object)className);
                return found;
            }
            LOG.warn("found a {} but it's not a {}", (Object)className, (Object)cls.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Dest resolveAction(WebApp.HTTP method, Dest dest, String path) {
        if (dest.prefix.length() == 1) {
            return null;
        }
        Preconditions.checkState((!Router.isGoodMatch((Dest)dest, (String)path) ? 1 : 0) != 0, (Object)dest.prefix);
        Preconditions.checkState((SLASH.countIn((CharSequence)path) > 1 ? 1 : 0) != 0, (Object)path);
        List parts = WebApp.parseRoute((String)path);
        String controller = (String)parts.get(1);
        String action = (String)parts.get(2);
        return this.add(method, StringHelper.pjoin((Object[])new Object[]{"", controller, action}), dest.controllerClass, action, null);
    }
}

