/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationsRequestPBImpl;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetApplicationsRequestPBImpl
extends GetApplicationsRequest {
    YarnServiceProtos.GetApplicationsRequestProto proto = YarnServiceProtos.GetApplicationsRequestProto.getDefaultInstance();
    YarnServiceProtos.GetApplicationsRequestProto.Builder builder = null;
    boolean viaProto = false;
    Set<String> applicationTypes = null;
    EnumSet<YarnApplicationState> applicationStates = null;

    public GetApplicationsRequestPBImpl() {
        this.builder = YarnServiceProtos.GetApplicationsRequestProto.newBuilder();
    }

    public GetApplicationsRequestPBImpl(YarnServiceProtos.GetApplicationsRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetApplicationsRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationTypes != null) {
            this.addLocalApplicationTypesToProto();
        }
        if (this.applicationStates != null) {
            this.maybeInitBuilder();
            this.builder.clearApplicationStates();
            1 iterable = new /* Unavailable Anonymous Inner Class!! */;
            this.builder.addAllApplicationStates((Iterable)iterable);
        }
    }

    private void addLocalApplicationTypesToProto() {
        this.maybeInitBuilder();
        this.builder.clearApplicationTypes();
        if (this.applicationTypes == null) {
            return;
        }
        this.builder.addAllApplicationTypes((Iterable)this.applicationTypes);
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetApplicationsRequestProto.newBuilder((YarnServiceProtos.GetApplicationsRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    private void initApplicationTypes() {
        if (this.applicationTypes != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
        List appTypeList = p.getApplicationTypesList();
        this.applicationTypes = new HashSet();
        this.applicationTypes.addAll(appTypeList);
    }

    private void initApplicationStates() {
        if (this.applicationStates != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
        List appStatesList = p.getApplicationStatesList();
        this.applicationStates = EnumSet.noneOf(YarnApplicationState.class);
        for (YarnProtos.YarnApplicationStateProto c : appStatesList) {
            this.applicationStates.add(ProtoUtils.convertFromProtoFormat((YarnProtos.YarnApplicationStateProto)c));
        }
    }

    public Set<String> getApplicationTypes() {
        this.initApplicationTypes();
        return this.applicationTypes;
    }

    public void setApplicationTypes(Set<String> applicationTypes) {
        this.maybeInitBuilder();
        if (applicationTypes == null) {
            this.builder.clearApplicationTypes();
        }
        this.applicationTypes = applicationTypes;
    }

    public EnumSet<YarnApplicationState> getApplicationStates() {
        this.initApplicationStates();
        return this.applicationStates;
    }

    public void setApplicationStates(EnumSet<YarnApplicationState> applicationStates) {
        this.maybeInitBuilder();
        if (applicationStates == null) {
            this.builder.clearApplicationStates();
        }
        this.applicationStates = applicationStates;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals((Object)((GetApplicationsRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }
}

