/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.AHSClient;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.ApplicationIdNotProvidedException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class YarnClientImpl
extends YarnClient {
    private static final Log LOG = LogFactory.getLog(YarnClientImpl.class);
    protected ApplicationClientProtocol rmClient;
    protected long submitPollIntervalMillis;
    private long asyncApiPollIntervalMillis;
    private long asyncApiPollTimeoutMillis;
    private AHSClient historyClient;
    private boolean historyServiceEnabled;
    protected TimelineClient timelineClient;
    protected Text timelineService;
    protected boolean timelineServiceEnabled;
    private static final String ROOT = "root";

    public YarnClientImpl() {
        super(YarnClientImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.asyncApiPollIntervalMillis = conf.getLong("yarn.client.application-client-protocol.poll-interval-ms", 200L);
        this.asyncApiPollTimeoutMillis = conf.getLong("yarn.client.application-client-protocol.poll-timeout-ms", -1L);
        this.submitPollIntervalMillis = this.asyncApiPollIntervalMillis;
        if (conf.get("yarn.client.app-submission.poll-interval") != null) {
            this.submitPollIntervalMillis = conf.getLong("yarn.client.app-submission.poll-interval", 200L);
        }
        if (conf.getBoolean("yarn.timeline-service.generic-application-history.enabled", false)) {
            this.historyServiceEnabled = true;
            this.historyClient = AHSClient.createAHSClient();
            this.historyClient.init(conf);
        }
        if (conf.getBoolean("yarn.timeline-service.enabled", false)) {
            this.timelineServiceEnabled = true;
            this.timelineClient = TimelineClient.createTimelineClient();
            this.timelineClient.init(conf);
            this.timelineService = TimelineUtils.buildTimelineTokenService((Configuration)conf);
        }
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        try {
            this.rmClient = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)this.getConfig(), ApplicationClientProtocol.class);
            if (this.historyServiceEnabled) {
                this.historyClient.start();
            }
            if (this.timelineServiceEnabled) {
                this.timelineClient.start();
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.rmClient != null) {
            RPC.stopProxy((Object)this.rmClient);
        }
        if (this.historyServiceEnabled) {
            this.historyClient.stop();
        }
        if (this.timelineServiceEnabled) {
            this.timelineClient.stop();
        }
        super.serviceStop();
    }

    private GetNewApplicationResponse getNewApplication() throws YarnException, IOException {
        GetNewApplicationRequest request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
        return this.rmClient.getNewApplication(request);
    }

    public YarnClientApplication createApplication() throws YarnException, IOException {
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        GetNewApplicationResponse newApp = this.getNewApplication();
        ApplicationId appId = newApp.getApplicationId();
        context.setApplicationId(appId);
        return new YarnClientApplication(newApp, context);
    }

    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnException, IOException {
        ApplicationId applicationId = appContext.getApplicationId();
        if (applicationId == null) {
            throw new ApplicationIdNotProvidedException("ApplicationId is not provided in ApplicationSubmissionContext");
        }
        SubmitApplicationRequest request = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        request.setApplicationSubmissionContext(appContext);
        if (this.isSecurityEnabled() && this.timelineServiceEnabled) {
            this.addTimelineDelegationToken(appContext.getAMContainerSpec());
        }
        this.rmClient.submitApplication(request);
        int pollCount = 0;
        long startTime = System.currentTimeMillis();
        block4: while (true) {
            try {
                while (true) {
                    YarnApplicationState state;
                    if (!(state = this.getApplicationReport(applicationId).getYarnApplicationState()).equals((Object)YarnApplicationState.NEW) && !state.equals((Object)YarnApplicationState.NEW_SAVING)) {
                        LOG.info((Object)("Submitted application " + applicationId));
                        break block4;
                    }
                    long elapsedMillis = System.currentTimeMillis() - startTime;
                    if (this.enforceAsyncAPITimeout() && elapsedMillis >= this.asyncApiPollTimeoutMillis) {
                        throw new YarnException("Timed out while waiting for application " + applicationId + " to be submitted successfully");
                    }
                    if (++pollCount % 10 == 0) {
                        LOG.info((Object)("Application submission is not finished, submitted application " + applicationId + " is still in " + state));
                    }
                    try {
                        Thread.sleep(this.submitPollIntervalMillis);
                        continue block4;
                    }
                    catch (InterruptedException ie) {
                        LOG.error((Object)("Interrupted while waiting for application " + applicationId + " to be successfully submitted."));
                        continue;
                    }
                    break;
                }
            }
            catch (ApplicationNotFoundException ex) {
                LOG.info((Object)("Re-submit application " + applicationId + "with the " + "same ApplicationSubmissionContext"));
                this.rmClient.submitApplication(request);
                continue;
            }
            break;
        }
        return applicationId;
    }

    private void addTimelineDelegationToken(ContainerLaunchContext clc) throws YarnException, IOException {
        Token timelineDelegationToken = this.timelineClient.getDelegationToken(UserGroupInformation.getCurrentUser().getUserName());
        if (timelineDelegationToken == null) {
            return;
        }
        Credentials credentials = new Credentials();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        ByteBuffer tokens = clc.getTokens();
        if (tokens != null) {
            dibb.reset(new ByteBuffer[]{tokens});
            credentials.readTokenStorageStream((DataInputStream)dibb);
            tokens.rewind();
        }
        for (Token token : credentials.getAllTokens()) {
            TokenIdentifier tokenIdentifier = token.decodeIdentifier();
            if (!(tokenIdentifier instanceof TimelineDelegationTokenIdentifier)) continue;
            return;
        }
        credentials.addToken(this.timelineService, timelineDelegationToken);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Add timline delegation token into credentials: " + timelineDelegationToken));
        }
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        tokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        clc.setTokens(tokens);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    public void killApplication(ApplicationId applicationId) throws YarnException, IOException {
        KillApplicationRequest request = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(applicationId);
        try {
            int pollCount = 0;
            long startTime = System.currentTimeMillis();
            while (true) {
                KillApplicationResponse response;
                if ((response = this.rmClient.forceKillApplication(request)).getIsKillCompleted()) {
                    LOG.info((Object)("Killed application " + applicationId));
                    break;
                }
                long elapsedMillis = System.currentTimeMillis() - startTime;
                if (this.enforceAsyncAPITimeout() && elapsedMillis >= this.asyncApiPollTimeoutMillis) {
                    throw new YarnException("Timed out while waiting for application " + applicationId + " to be killed.");
                }
                if (++pollCount % 10 == 0) {
                    LOG.info((Object)("Waiting for application " + applicationId + " to be killed."));
                }
                Thread.sleep(this.asyncApiPollIntervalMillis);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Interrupted while waiting for application " + applicationId + " to be killed."));
        }
    }

    @VisibleForTesting
    boolean enforceAsyncAPITimeout() {
        return this.asyncApiPollTimeoutMillis >= 0L;
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        GetApplicationReportResponse response = null;
        try {
            GetApplicationReportRequest request = (GetApplicationReportRequest)Records.newRecord(GetApplicationReportRequest.class);
            request.setApplicationId(appId);
            response = this.rmClient.getApplicationReport(request);
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (((Object)((Object)e)).getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getApplicationReport(appId);
        }
        return response.getApplicationReport();
    }

    public Token<AMRMTokenIdentifier> getAMRMToken(ApplicationId appId) throws YarnException, IOException {
        org.apache.hadoop.yarn.api.records.Token token = this.getApplicationReport(appId).getAMRMToken();
        Token amrmToken = null;
        if (token != null) {
            amrmToken = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)token, (Text)null);
        }
        return amrmToken;
    }

    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        return this.getApplications(null, null);
    }

    public List<ApplicationReport> getApplications(Set<String> applicationTypes) throws YarnException, IOException {
        return this.getApplications(applicationTypes, null);
    }

    public List<ApplicationReport> getApplications(EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        return this.getApplications(null, applicationStates);
    }

    public List<ApplicationReport> getApplications(Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        GetApplicationsRequest request = GetApplicationsRequest.newInstance(applicationTypes, applicationStates);
        GetApplicationsResponse response = this.rmClient.getApplications(request);
        return response.getApplicationList();
    }

    public YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException {
        GetClusterMetricsRequest request = (GetClusterMetricsRequest)Records.newRecord(GetClusterMetricsRequest.class);
        GetClusterMetricsResponse response = this.rmClient.getClusterMetrics(request);
        return response.getClusterMetrics();
    }

    public List<NodeReport> getNodeReports(NodeState ... states) throws YarnException, IOException {
        EnumSet<NodeState> statesSet = states.length == 0 ? EnumSet.allOf(NodeState.class) : EnumSet.noneOf(NodeState.class);
        for (NodeState state : states) {
            statesSet.add(state);
        }
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(statesSet);
        GetClusterNodesResponse response = this.rmClient.getClusterNodes(request);
        return response.getNodeReports();
    }

    public org.apache.hadoop.yarn.api.records.Token getRMDelegationToken(Text renewer) throws YarnException, IOException {
        GetDelegationTokenRequest rmDTRequest = (GetDelegationTokenRequest)Records.newRecord(GetDelegationTokenRequest.class);
        rmDTRequest.setRenewer(renewer.toString());
        GetDelegationTokenResponse response = this.rmClient.getDelegationToken(rmDTRequest);
        return response.getRMDelegationToken();
    }

    private GetQueueInfoRequest getQueueInfoRequest(String queueName, boolean includeApplications, boolean includeChildQueues, boolean recursive) {
        GetQueueInfoRequest request = (GetQueueInfoRequest)Records.newRecord(GetQueueInfoRequest.class);
        request.setQueueName(queueName);
        request.setIncludeApplications(includeApplications);
        request.setIncludeChildQueues(includeChildQueues);
        request.setRecursive(recursive);
        return request;
    }

    public QueueInfo getQueueInfo(String queueName) throws YarnException, IOException {
        GetQueueInfoRequest request = this.getQueueInfoRequest(queueName, true, false, false);
        Records.newRecord(GetQueueInfoRequest.class);
        return this.rmClient.getQueueInfo(request).getQueueInfo();
    }

    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException {
        GetQueueUserAclsInfoRequest request = (GetQueueUserAclsInfoRequest)Records.newRecord(GetQueueUserAclsInfoRequest.class);
        return this.rmClient.getQueueUserAcls(request).getUserAclsInfoList();
    }

    public List<QueueInfo> getAllQueues() throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(ROOT, false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, true);
        return queues;
    }

    public List<QueueInfo> getRootQueueInfos() throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(ROOT, false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, false);
        return queues;
    }

    public List<QueueInfo> getChildQueueInfos(String parent) throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo parentQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(parent, false, true, false)).getQueueInfo();
        this.getChildQueues(parentQueue, queues, true);
        return queues;
    }

    private void getChildQueues(QueueInfo parent, List<QueueInfo> queues, boolean recursive) {
        List childQueues = parent.getChildQueues();
        for (QueueInfo child : childQueues) {
            queues.add(child);
            if (!recursive) continue;
            this.getChildQueues(child, queues, recursive);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setRMClient(ApplicationClientProtocol rmClient) {
        this.rmClient = rmClient;
    }

    public ApplicationAttemptReport getApplicationAttemptReport(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        try {
            GetApplicationAttemptReportRequest request = (GetApplicationAttemptReportRequest)Records.newRecord(GetApplicationAttemptReportRequest.class);
            request.setApplicationAttemptId(appAttemptId);
            GetApplicationAttemptReportResponse response = this.rmClient.getApplicationAttemptReport(request);
            return response.getApplicationAttemptReport();
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (((Object)((Object)e)).getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getApplicationAttemptReport(appAttemptId);
        }
    }

    public List<ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws YarnException, IOException {
        try {
            GetApplicationAttemptsRequest request = (GetApplicationAttemptsRequest)Records.newRecord(GetApplicationAttemptsRequest.class);
            request.setApplicationId(appId);
            GetApplicationAttemptsResponse response = this.rmClient.getApplicationAttempts(request);
            return response.getApplicationAttemptList();
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (((Object)((Object)e)).getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getApplicationAttempts(appId);
        }
    }

    public ContainerReport getContainerReport(ContainerId containerId) throws YarnException, IOException {
        try {
            GetContainerReportRequest request = (GetContainerReportRequest)Records.newRecord(GetContainerReportRequest.class);
            request.setContainerId(containerId);
            GetContainerReportResponse response = this.rmClient.getContainerReport(request);
            return response.getContainerReport();
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (((Object)((Object)e)).getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getContainerReport(containerId);
        }
    }

    public List<ContainerReport> getContainers(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        try {
            GetContainersRequest request = (GetContainersRequest)Records.newRecord(GetContainersRequest.class);
            request.setApplicationAttemptId(applicationAttemptId);
            GetContainersResponse response = this.rmClient.getContainers(request);
            return response.getContainerList();
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (((Object)((Object)e)).getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getContainers(applicationAttemptId);
        }
    }

    public void moveApplicationAcrossQueues(ApplicationId appId, String queue) throws YarnException, IOException {
        MoveApplicationAcrossQueuesRequest request = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)appId, (String)queue);
        this.rmClient.moveApplicationAcrossQueues(request);
    }

    public List<NodeToLabelsList> getClusterNodeLabels() throws YarnException, IOException {
        GetClusterNodeLabelsRequest request = GetClusterNodeLabelsRequest.newInstance();
        GetClusterNodeLabelsResponse response = this.rmClient.getClusterNodeLabels(request);
        return response.getClusterNodeLabels();
    }

    public boolean refreshClusterNodeLabels() throws YarnException, IOException {
        RefreshClusterNodeLabelsRequest request = RefreshClusterNodeLabelsRequest.newInstance();
        RefreshClusterNodeLabelsResponse response = this.rmClient.refreshClusterNodeLabels(request);
        return response.getIsRefreshLabelsComplete();
    }
}

