/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.async.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.TestAMRMClientAsync;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAMRMClientAsync {
    private static final Log LOG = LogFactory.getLog(TestAMRMClientAsync.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAMRMClientAsync() throws Exception {
        Configuration conf = new Configuration();
        AtomicBoolean heartbeatBlock = new AtomicBoolean(true);
        List<ContainerStatus> completed1 = Arrays.asList(ContainerStatus.newInstance((ContainerId)TestAMRMClientAsync.newContainerId((int)0, (int)0, (long)0L, (int)0), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0));
        List<Container> allocated1 = Arrays.asList(Container.newInstance(null, null, null, null, null, null));
        AllocateResponse response1 = this.createAllocateResponse(new ArrayList(), allocated1, null);
        AllocateResponse response2 = this.createAllocateResponse(completed1, new ArrayList(), null);
        AllocateResponse emptyResponse = this.createAllocateResponse(new ArrayList(), new ArrayList(), null);
        TestCallbackHandler callbackHandler = new TestCallbackHandler(this, null);
        AMRMClient client = (AMRMClient)Mockito.mock(AMRMClientImpl.class);
        AtomicInteger secondHeartbeatSync = new AtomicInteger(0);
        Mockito.when((Object)client.allocate(Matchers.anyFloat())).thenReturn((Object)response1).thenAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).thenReturn((Object)emptyResponse);
        Mockito.when((Object)client.registerApplicationMaster(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString())).thenReturn(null);
        Mockito.when((Object)client.getAvailableResources()).thenAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */);
        AMRMClientAsync asyncClient = AMRMClientAsync.createAMRMClientAsync((AMRMClient)client, (int)20, (AMRMClientAsync.CallbackHandler)callbackHandler);
        asyncClient.init(conf);
        asyncClient.start();
        asyncClient.registerApplicationMaster("localhost", 1234, null);
        while (secondHeartbeatSync.get() < 1) {
            Thread.sleep(10L);
        }
        assert (secondHeartbeatSync.get() < 2);
        asyncClient.getAvailableResources();
        assert (secondHeartbeatSync.get() < 2);
        AtomicBoolean atomicBoolean = heartbeatBlock;
        synchronized (atomicBoolean) {
            heartbeatBlock.set(false);
            heartbeatBlock.notifyAll();
        }
        Assert.assertEquals(null, (Object)callbackHandler.takeCompletedContainers());
        while (callbackHandler.takeAllocatedContainers() == null) {
            Assert.assertEquals(null, (Object)callbackHandler.takeCompletedContainers());
            Thread.sleep(10L);
        }
        while (callbackHandler.takeCompletedContainers() == null) {
            Thread.sleep(10L);
        }
        asyncClient.stop();
        Assert.assertEquals(null, (Object)callbackHandler.takeAllocatedContainers());
        Assert.assertEquals(null, (Object)callbackHandler.takeCompletedContainers());
    }

    @Test(timeout=10000L)
    public void testAMRMClientAsyncException() throws Exception {
        String exStr = "TestException";
        YarnException mockException = (YarnException)Mockito.mock(YarnException.class);
        Mockito.when((Object)mockException.getMessage()).thenReturn((Object)exStr);
        this.runHeartBeatThrowOutException((Exception)mockException);
    }

    @Test(timeout=10000L)
    public void testAMRMClientAsyncRunTimeException() throws Exception {
        String exStr = "TestRunTimeException";
        RuntimeException mockRunTimeException = (RuntimeException)Mockito.mock(RuntimeException.class);
        Mockito.when((Object)mockRunTimeException.getMessage()).thenReturn((Object)exStr);
        this.runHeartBeatThrowOutException((Exception)mockRunTimeException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHeartBeatThrowOutException(Exception ex) throws Exception {
        Configuration conf = new Configuration();
        TestCallbackHandler callbackHandler = new TestCallbackHandler(this, null);
        AMRMClient client = (AMRMClient)Mockito.mock(AMRMClientImpl.class);
        Mockito.when((Object)client.allocate(Matchers.anyFloat())).thenThrow(new Throwable[]{ex});
        AMRMClientAsync asyncClient = AMRMClientAsync.createAMRMClientAsync((AMRMClient)client, (int)20, (AMRMClientAsync.CallbackHandler)callbackHandler);
        asyncClient.init(conf);
        asyncClient.start();
        Object object = callbackHandler.notifier;
        synchronized (object) {
            asyncClient.registerApplicationMaster("localhost", 1234, null);
            while (callbackHandler.savedException == null) {
                try {
                    callbackHandler.notifier.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        Assert.assertTrue((boolean)callbackHandler.savedException.getMessage().contains(ex.getMessage()));
        asyncClient.stop();
        Assert.assertTrue((callbackHandler.callbackCount == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAMRMClientAsyncReboot() throws Exception {
        Configuration conf = new Configuration();
        TestCallbackHandler callbackHandler = new TestCallbackHandler(this, null);
        AMRMClient client = (AMRMClient)Mockito.mock(AMRMClientImpl.class);
        AllocateResponse rebootResponse = this.createAllocateResponse(new ArrayList(), new ArrayList(), null);
        rebootResponse.setAMCommand(AMCommand.AM_RESYNC);
        Mockito.when((Object)client.allocate(Matchers.anyFloat())).thenReturn((Object)rebootResponse);
        AMRMClientAsync asyncClient = AMRMClientAsync.createAMRMClientAsync((AMRMClient)client, (int)20, (AMRMClientAsync.CallbackHandler)callbackHandler);
        asyncClient.init(conf);
        asyncClient.start();
        Object object = callbackHandler.notifier;
        synchronized (object) {
            asyncClient.registerApplicationMaster("localhost", 1234, null);
            while (!callbackHandler.reboot) {
                try {
                    callbackHandler.notifier.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        asyncClient.stop();
        Assert.assertTrue((callbackHandler.callbackCount == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testAMRMClientAsyncShutDown() throws Exception {
        Configuration conf = new Configuration();
        TestCallbackHandler callbackHandler = new TestCallbackHandler(this, null);
        AMRMClient client = (AMRMClient)Mockito.mock(AMRMClientImpl.class);
        AllocateResponse shutDownResponse = this.createAllocateResponse(new ArrayList(), new ArrayList(), null);
        shutDownResponse.setAMCommand(AMCommand.AM_SHUTDOWN);
        Mockito.when((Object)client.allocate(Matchers.anyFloat())).thenReturn((Object)shutDownResponse);
        AMRMClientAsync asyncClient = AMRMClientAsync.createAMRMClientAsync((AMRMClient)client, (int)10, (AMRMClientAsync.CallbackHandler)callbackHandler);
        asyncClient.init(conf);
        asyncClient.start();
        asyncClient.registerApplicationMaster("localhost", 1234, null);
        Thread.sleep(50L);
        ((AMRMClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).allocate(Matchers.anyFloat());
        asyncClient.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testCallAMRMClientAsyncStopFromCallbackHandler() throws YarnException, IOException, InterruptedException {
        AMRMClientAsync asyncClient;
        Configuration conf = new Configuration();
        TestCallbackHandler2 callbackHandler = new TestCallbackHandler2(this, null);
        AMRMClient client = (AMRMClient)Mockito.mock(AMRMClientImpl.class);
        List<ContainerStatus> completed = Arrays.asList(ContainerStatus.newInstance((ContainerId)TestAMRMClientAsync.newContainerId((int)0, (int)0, (long)0L, (int)0), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0));
        AllocateResponse response = this.createAllocateResponse(completed, new ArrayList(), null);
        Mockito.when((Object)client.allocate(Matchers.anyFloat())).thenReturn((Object)response);
        callbackHandler.asynClient = asyncClient = AMRMClientAsync.createAMRMClientAsync((AMRMClient)client, (int)20, (AMRMClientAsync.CallbackHandler)callbackHandler);
        asyncClient.init(conf);
        asyncClient.start();
        Object object = callbackHandler.notifier;
        synchronized (object) {
            asyncClient.registerApplicationMaster("localhost", 1234, null);
            while (!callbackHandler.notify) {
                try {
                    callbackHandler.notifier.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCallBackThrowOutException(TestCallbackHandler2 callbackHandler) throws InterruptedException, YarnException, IOException {
        AMRMClientAsync asyncClient;
        Configuration conf = new Configuration();
        AMRMClient client = (AMRMClient)Mockito.mock(AMRMClientImpl.class);
        List<ContainerStatus> completed = Arrays.asList(ContainerStatus.newInstance((ContainerId)TestAMRMClientAsync.newContainerId((int)0, (int)0, (long)0L, (int)0), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0));
        AllocateResponse response = this.createAllocateResponse(completed, new ArrayList(), null);
        Mockito.when((Object)client.allocate(Matchers.anyFloat())).thenReturn((Object)response);
        callbackHandler.asynClient = asyncClient = AMRMClientAsync.createAMRMClientAsync((AMRMClient)client, (int)20, (AMRMClientAsync.CallbackHandler)callbackHandler);
        callbackHandler.throwOutException = true;
        asyncClient.init(conf);
        asyncClient.start();
        Object object = callbackHandler.notifier;
        synchronized (object) {
            asyncClient.registerApplicationMaster("localhost", 1234, null);
            while (!callbackHandler.notify) {
                try {
                    callbackHandler.notifier.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        ((TestCallbackHandler2)Mockito.verify((Object)callbackHandler, (VerificationMode)Mockito.times((int)0))).getProgress();
        ((TestCallbackHandler2)Mockito.verify((Object)callbackHandler, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Matchers.any(Exception.class));
        Thread.sleep(50L);
        ((TestCallbackHandler2)Mockito.verify((Object)callbackHandler, (VerificationMode)Mockito.times((int)0))).getProgress();
        ((TestCallbackHandler2)Mockito.verify((Object)callbackHandler, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Matchers.any(Exception.class));
    }

    @Test(timeout=5000L)
    public void testCallBackThrowOutException() throws YarnException, IOException, InterruptedException {
        TestCallbackHandler2 callbackHandler = (TestCallbackHandler2)Mockito.spy((Object)new TestCallbackHandler2(this, null));
        this.runCallBackThrowOutException(callbackHandler);
    }

    @Test(timeout=5000L)
    public void testCallBackThrowOutExceptionNoStop() throws YarnException, IOException, InterruptedException {
        TestCallbackHandler2 callbackHandler = (TestCallbackHandler2)Mockito.spy((Object)new TestCallbackHandler2(this, null));
        callbackHandler.stop = false;
        this.runCallBackThrowOutException(callbackHandler);
    }

    private AllocateResponse createAllocateResponse(List<ContainerStatus> completed, List<Container> allocated, List<NMToken> nmTokens) {
        AllocateResponse response = AllocateResponse.newInstance((int)0, completed, allocated, new ArrayList(), null, null, (int)1, null, nmTokens);
        return response;
    }

    public static ContainerId newContainerId(int appId, int appAttemptId, long timestamp, int containerId) {
        ApplicationId applicationId = ApplicationId.newInstance((long)timestamp, (int)appId);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)appAttemptId);
        return ContainerId.newInstance((ApplicationAttemptId)applicationAttemptId, (int)containerId);
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }
}

