/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.async;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.NMClientImpl;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class NMClientAsync
extends AbstractService {
    protected NMClient client;
    protected CallbackHandler callbackHandler;

    public static NMClientAsync createNMClientAsync(CallbackHandler callbackHandler) {
        return new NMClientAsyncImpl(callbackHandler);
    }

    protected NMClientAsync(CallbackHandler callbackHandler) {
        this(NMClientAsync.class.getName(), callbackHandler);
    }

    protected NMClientAsync(String name, CallbackHandler callbackHandler) {
        this(name, (NMClient)new NMClientImpl(), callbackHandler);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected NMClientAsync(String name, NMClient client, CallbackHandler callbackHandler) {
        super(name);
        this.setClient(client);
        this.setCallbackHandler(callbackHandler);
    }

    public abstract void startContainerAsync(Container var1, ContainerLaunchContext var2);

    public abstract void stopContainerAsync(ContainerId var1, NodeId var2);

    public abstract void getContainerStatusAsync(ContainerId var1, NodeId var2);

    public NMClient getClient() {
        return this.client;
    }

    public void setClient(NMClient client) {
        this.client = client;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }
}

