/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.tools.GetGroupsTestBase;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.yarn.client.GetGroupsForTesting;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestGetGroups
extends GetGroupsTestBase {
    private static final Log LOG = LogFactory.getLog(TestGetGroups.class);
    private static ResourceManager resourceManager;
    private static Configuration conf;

    @BeforeClass
    public static void setUpResourceManager() throws IOException, InterruptedException {
        conf = new YarnConfiguration();
        resourceManager = new /* Unavailable Anonymous Inner Class!! */;
        resourceManager.init(conf);
        new /* Unavailable Anonymous Inner Class!! */.start();
        int waitCount = 0;
        while (resourceManager.getServiceState() == Service.STATE.INITED && waitCount++ < 10) {
            LOG.info((Object)"Waiting for RM to start...");
            Thread.sleep(1000L);
        }
        if (resourceManager.getServiceState() != Service.STATE.STARTED) {
            throw new IOException("ResourceManager failed to start. Final state is " + resourceManager.getServiceState());
        }
        LOG.info((Object)("ResourceManager RMAdmin address: " + conf.get("yarn.resourcemanager.admin.address")));
    }

    @Before
    public void setUpConf() {
        this.conf = conf;
    }

    @AfterClass
    public static void tearDownResourceManager() throws InterruptedException {
        if (resourceManager != null) {
            LOG.info((Object)"Stopping ResourceManager...");
            resourceManager.stop();
        }
    }

    protected Tool getTool(PrintStream o) {
        return new GetGroupsForTesting(conf, o);
    }

    static /* synthetic */ ResourceManager access$000() {
        return resourceManager;
    }
}

