/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class TestDSFailedAppMaster
extends ApplicationMaster {
    private static final Log LOG = LogFactory.getLog(TestDSFailedAppMaster.class);

    public void run() throws YarnException, IOException {
        super.run();
        if (this.appAttemptID.getAttemptId() == 2 && (this.numAllocatedContainers.get() != 1 || this.numRequestedContainers.get() != this.numTotalContainers)) {
            LOG.info((Object)("NumAllocatedContainers is " + this.numAllocatedContainers.get() + " and NumRequestedContainers is " + this.numAllocatedContainers.get() + ".Application Master failed. exiting"));
            System.exit(200);
        }
    }

    public static void main(String[] args) {
        boolean result = false;
        try {
            TestDSFailedAppMaster appMaster = new TestDSFailedAppMaster();
            boolean doRun = appMaster.init(args);
            if (!doRun) {
                System.exit(0);
            }
            appMaster.run();
            if (appMaster.appAttemptID.getAttemptId() == 1) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                System.exit(100);
            }
            result = appMaster.finish();
        }
        catch (Throwable t) {
            System.exit(1);
        }
        if (result) {
            LOG.info((Object)"Application Master completed successfully. exiting");
            System.exit(0);
        } else {
            LOG.info((Object)"Application Master failed. exiting");
            System.exit(2);
        }
    }
}

