/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.applications.distributedshell.Log4jPropertyHelper;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Client {
    private static final Log LOG = LogFactory.getLog(Client.class);
    private Configuration conf;
    private YarnClient yarnClient;
    private String appName = "";
    private int amPriority = 0;
    private String amQueue = "";
    private int amMemory = 10;
    private int amVCores = 1;
    private String appMasterJar = "";
    private final String appMasterMainClass;
    private String shellCommand = "";
    private String shellScriptPath = "";
    private String[] shellArgs = new String[0];
    private Map<String, String> shellEnv = new HashMap();
    private int shellCmdPriority = 0;
    private int containerMemory = 10;
    private int containerVirtualCores = 1;
    private int numContainers = 1;
    private String nodeLabelExpression = null;
    private String log4jPropFile = "";
    private final long clientStartTime = System.currentTimeMillis();
    private long clientTimeout = 600000L;
    private boolean keepContainers = false;
    private long attemptFailuresValidityInterval = -1L;
    boolean debugFlag = false;
    private String domainId = null;
    private boolean toCreateDomain = false;
    private String viewACLs = null;
    private String modifyACLs = null;
    private Options opts;
    private static final String shellCommandPath = "shellCommands";
    private static final String shellArgsPath = "shellArgs";
    private static final String appMasterJarPath = "AppMaster.jar";
    private static final String log4jPath = "log4j.properties";
    public static final String SCRIPT_PATH = "ExecScript";

    public static void main(String[] args) {
        boolean result = false;
        try {
            Client client = new Client();
            LOG.info((Object)"Initializing Client");
            try {
                boolean doRun = client.init(args);
                if (!doRun) {
                    System.exit(0);
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getLocalizedMessage());
                client.printUsage();
                System.exit(-1);
            }
            result = client.run();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error running Client", t);
            System.exit(1);
        }
        if (result) {
            LOG.info((Object)"Application completed successfully");
            System.exit(0);
        }
        LOG.error((Object)"Application failed to complete successfully");
        System.exit(2);
    }

    public Client(Configuration conf) throws Exception {
        this("org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster", conf);
    }

    Client(String appMasterMainClass, Configuration conf) {
        this.conf = conf;
        this.appMasterMainClass = appMasterMainClass;
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init(conf);
        this.opts = new Options();
        this.opts.addOption("appname", true, "Application Name. Default value - DistributedShell");
        this.opts.addOption("priority", true, "Application Priority. Default 0");
        this.opts.addOption("queue", true, "RM Queue in which this application is to be submitted");
        this.opts.addOption("timeout", true, "Application timeout in milliseconds");
        this.opts.addOption("master_memory", true, "Amount of memory in MB to be requested to run the application master");
        this.opts.addOption("master_vcores", true, "Amount of virtual cores to be requested to run the application master");
        this.opts.addOption("jar", true, "Jar file containing the application master");
        this.opts.addOption("shell_command", true, "Shell command to be executed by the Application Master. Can only specify either --shell_command or --shell_script");
        this.opts.addOption("shell_script", true, "Location of the shell script to be executed. Can only specify either --shell_command or --shell_script");
        this.opts.addOption("shell_args", true, "Command line args for the shell script.Multiple args can be separated by empty space.");
        this.opts.getOption("shell_args").setArgs(-2);
        this.opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
        this.opts.addOption("shell_cmd_priority", true, "Priority for the shell command containers");
        this.opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the shell command");
        this.opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the shell command");
        this.opts.addOption("num_containers", true, "No. of containers on which the shell command needs to be executed");
        this.opts.addOption("log_properties", true, "log4j.properties file");
        this.opts.addOption("keep_containers_across_application_attempts", false, "Flag to indicate whether to keep containers across application attempts. If the flag is true, running containers will not be killed when application attempt fails and these containers will be retrieved by the new application attempt ");
        this.opts.addOption("attempt_failures_validity_interval", true, "when attempt_failures_validity_interval in milliseconds is set to > 0,the failure number will not take failures which happen out of the validityInterval into failure count. If failure count reaches to maxAppAttempts, the application will be failed.");
        this.opts.addOption("debug", false, "Dump out debug information");
        this.opts.addOption("domain", true, "ID of the timeline domain where the timeline entities will be put");
        this.opts.addOption("view_acls", true, "Users and groups that allowed to view the timeline entities in the given domain");
        this.opts.addOption("modify_acls", true, "Users and groups that allowed to modify the timeline entities in the given domain");
        this.opts.addOption("create", false, "Flag to indicate whether to create the domain specified with -domain.");
        this.opts.addOption("help", false, "Print usage");
        this.opts.addOption("node_label_expression", true, "Node label expression to determine the nodes where all the containers of this application will be allocated, \"\" means containers can be allocated anywhere, if you don't specify the option, default node_label_expression of queue will be used.");
    }

    public Client() throws Exception {
        this((Configuration)new YarnConfiguration());
    }

    private void printUsage() {
        new HelpFormatter().printHelp("Client", this.opts);
    }

    public boolean init(String[] args) throws ParseException {
        CommandLine cliParser = new GnuParser().parse(this.opts, args);
        if (args.length == 0) {
            throw new IllegalArgumentException("No args specified for client to initialize");
        }
        if (cliParser.hasOption("log_properties")) {
            String log4jPath = cliParser.getOptionValue("log_properties");
            try {
                Log4jPropertyHelper.updateLog4jConfiguration(Client.class, (String)log4jPath);
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not set up custom log4j properties. " + e));
            }
        }
        if (cliParser.hasOption("help")) {
            this.printUsage();
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.debugFlag = true;
        }
        if (cliParser.hasOption("keep_containers_across_application_attempts")) {
            LOG.info((Object)"keep_containers_across_application_attempts");
            this.keepContainers = true;
        }
        this.appName = cliParser.getOptionValue("appname", "DistributedShell");
        this.amPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        this.amQueue = cliParser.getOptionValue("queue", "default");
        this.amMemory = Integer.parseInt(cliParser.getOptionValue("master_memory", "10"));
        this.amVCores = Integer.parseInt(cliParser.getOptionValue("master_vcores", "1"));
        if (this.amMemory < 0) {
            throw new IllegalArgumentException("Invalid memory specified for application master, exiting. Specified memory=" + this.amMemory);
        }
        if (this.amVCores < 0) {
            throw new IllegalArgumentException("Invalid virtual cores specified for application master, exiting. Specified virtual cores=" + this.amVCores);
        }
        if (!cliParser.hasOption("jar")) {
            throw new IllegalArgumentException("No jar file specified for application master");
        }
        this.appMasterJar = cliParser.getOptionValue("jar");
        if (!cliParser.hasOption("shell_command") && !cliParser.hasOption("shell_script")) {
            throw new IllegalArgumentException("No shell command or shell script specified to be executed by application master");
        }
        if (cliParser.hasOption("shell_command") && cliParser.hasOption("shell_script")) {
            throw new IllegalArgumentException("Can not specify shell_command option and shell_script option at the same time");
        }
        if (cliParser.hasOption("shell_command")) {
            this.shellCommand = cliParser.getOptionValue("shell_command");
        } else {
            this.shellScriptPath = cliParser.getOptionValue("shell_script");
        }
        if (cliParser.hasOption("shell_args")) {
            this.shellArgs = cliParser.getOptionValues("shell_args");
        }
        if (cliParser.hasOption("shell_env")) {
            String[] envs;
            for (String env : envs = cliParser.getOptionValues("shell_env")) {
                int index = (env = env.trim()).indexOf(61);
                if (index == -1) {
                    this.shellEnv.put(env, "");
                    continue;
                }
                String key = env.substring(0, index);
                String val = "";
                if (index < env.length() - 1) {
                    val = env.substring(index + 1);
                }
                this.shellEnv.put(key, val);
            }
        }
        this.shellCmdPriority = Integer.parseInt(cliParser.getOptionValue("shell_cmd_priority", "0"));
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "1"));
        this.numContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.containerMemory < 0 || this.containerVirtualCores < 0 || this.numContainers < 1) {
            throw new IllegalArgumentException("Invalid no. of containers or container memory/vcores specified, exiting. Specified containerMemory=" + this.containerMemory + ", containerVirtualCores=" + this.containerVirtualCores + ", numContainer=" + this.numContainers);
        }
        this.nodeLabelExpression = cliParser.getOptionValue("node_label_expression", null);
        this.clientTimeout = Integer.parseInt(cliParser.getOptionValue("timeout", "600000"));
        this.attemptFailuresValidityInterval = Long.parseLong(cliParser.getOptionValue("attempt_failures_validity_interval", "-1"));
        this.log4jPropFile = cliParser.getOptionValue("log_properties", "");
        if (cliParser.hasOption("domain")) {
            this.domainId = cliParser.getOptionValue("domain");
            this.toCreateDomain = cliParser.hasOption("create");
            if (cliParser.hasOption("view_acls")) {
                this.viewACLs = cliParser.getOptionValue("view_acls");
            }
            if (cliParser.hasOption("modify_acls")) {
                this.modifyACLs = cliParser.getOptionValue("modify_acls");
            }
        }
        return true;
    }

    public boolean run() throws IOException, YarnException {
        LOG.info((Object)"Running Client");
        this.yarnClient.start();
        YarnClusterMetrics clusterMetrics = this.yarnClient.getYarnClusterMetrics();
        LOG.info((Object)("Got Cluster metric info from ASM, numNodeManagers=" + clusterMetrics.getNumNodeManagers()));
        List clusterNodeReports = this.yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
        LOG.info((Object)"Got Cluster node info from ASM");
        for (NodeReport node : clusterNodeReports) {
            LOG.info((Object)("Got node report from ASM for, nodeId=" + node.getNodeId() + ", nodeAddress" + node.getHttpAddress() + ", nodeRackName" + node.getRackName() + ", nodeNumContainers" + node.getNumContainers()));
        }
        QueueInfo queueInfo = this.yarnClient.getQueueInfo(this.amQueue);
        LOG.info((Object)("Queue info, queueName=" + queueInfo.getQueueName() + ", queueCurrentCapacity=" + queueInfo.getCurrentCapacity() + ", queueMaxCapacity=" + queueInfo.getMaximumCapacity() + ", queueApplicationCount=" + queueInfo.getApplications().size() + ", queueChildQueueCount=" + queueInfo.getChildQueues().size()));
        List listAclInfo = this.yarnClient.getQueueAclsInfo();
        for (QueueUserACLInfo aclInfo : listAclInfo) {
            for (QueueACL userAcl : aclInfo.getUserAcls()) {
                LOG.info((Object)("User ACL Info for Queue, queueName=" + aclInfo.getQueueName() + ", userAcl=" + userAcl.name()));
            }
        }
        if (this.domainId != null && this.domainId.length() > 0 && this.toCreateDomain) {
            this.prepareTimelineDomain();
        }
        YarnClientApplication app = this.yarnClient.createApplication();
        GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
        int maxMem = appResponse.getMaximumResourceCapability().getMemory();
        LOG.info((Object)("Max mem capabililty of resources in this cluster " + maxMem));
        if (this.amMemory > maxMem) {
            LOG.info((Object)("AM memory specified above max threshold of cluster. Using max value., specified=" + this.amMemory + ", max=" + maxMem));
            this.amMemory = maxMem;
        }
        int maxVCores = appResponse.getMaximumResourceCapability().getVirtualCores();
        LOG.info((Object)("Max virtual cores capabililty of resources in this cluster " + maxVCores));
        if (this.amVCores > maxVCores) {
            LOG.info((Object)("AM virtual cores specified above max threshold of cluster. Using max value., specified=" + this.amVCores + ", max=" + maxVCores));
            this.amVCores = maxVCores;
        }
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        ApplicationId appId = appContext.getApplicationId();
        appContext.setKeepContainersAcrossApplicationAttempts(this.keepContainers);
        appContext.setApplicationName(this.appName);
        if (this.attemptFailuresValidityInterval >= 0L) {
            appContext.setAttemptFailuresValidityInterval(this.attemptFailuresValidityInterval);
        }
        HashMap localResources = new HashMap();
        LOG.info((Object)"Copy App Master jar from local filesystem and add to local environment");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        this.addToLocalResources(fs, this.appMasterJar, appMasterJarPath, appId.toString(), localResources, null);
        if (!this.log4jPropFile.isEmpty()) {
            this.addToLocalResources(fs, this.log4jPropFile, log4jPath, appId.toString(), localResources, null);
        }
        String hdfsShellScriptLocation = "";
        long hdfsShellScriptLen = 0L;
        long hdfsShellScriptTimestamp = 0L;
        if (!this.shellScriptPath.isEmpty()) {
            Path shellSrc = new Path(this.shellScriptPath);
            String shellPathSuffix = this.appName + "/" + appId.toString() + "/" + SCRIPT_PATH;
            Path shellDst = new Path(fs.getHomeDirectory(), shellPathSuffix);
            fs.copyFromLocalFile(false, true, shellSrc, shellDst);
            hdfsShellScriptLocation = shellDst.toUri().toString();
            FileStatus shellFileStatus = fs.getFileStatus(shellDst);
            hdfsShellScriptLen = shellFileStatus.getLen();
            hdfsShellScriptTimestamp = shellFileStatus.getModificationTime();
        }
        if (!this.shellCommand.isEmpty()) {
            this.addToLocalResources(fs, null, shellCommandPath, appId.toString(), localResources, this.shellCommand);
        }
        if (this.shellArgs.length > 0) {
            this.addToLocalResources(fs, null, shellArgsPath, appId.toString(), localResources, StringUtils.join((Object[])this.shellArgs, (String)" "));
        }
        LOG.info((Object)"Set the environment for the application master");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("DISTRIBUTEDSHELLSCRIPTLOCATION", hdfsShellScriptLocation);
        env.put("DISTRIBUTEDSHELLSCRIPTTIMESTAMP", Long.toString(hdfsShellScriptTimestamp));
        env.put("DISTRIBUTEDSHELLSCRIPTLEN", Long.toString(hdfsShellScriptLen));
        if (this.domainId != null && this.domainId.length() > 0) {
            env.put("DISTRIBUTEDSHELLTIMELINEDOMAIN", this.domainId);
        }
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$$()).append("<CPS>").append("./*");
        for (String string : this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH)) {
            classPathEnv.append("<CPS>");
            classPathEnv.append(string.trim());
        }
        classPathEnv.append("<CPS>").append("./log4j.properties");
        if (this.conf.getBoolean("yarn.is.minicluster", false)) {
            classPathEnv.append(':');
            classPathEnv.append(System.getProperty("java.class.path"));
        }
        env.put("CLASSPATH", classPathEnv.toString());
        Vector<String> vargs = new Vector<String>(30);
        LOG.info((Object)"Setting up app master command");
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$$() + "/bin/java");
        vargs.add("-Xmx" + this.amMemory + "m");
        vargs.add(this.appMasterMainClass);
        vargs.add("--container_memory " + String.valueOf(this.containerMemory));
        vargs.add("--container_vcores " + String.valueOf(this.containerVirtualCores));
        vargs.add("--num_containers " + String.valueOf(this.numContainers));
        if (null != this.nodeLabelExpression) {
            appContext.setNodeLabelExpression(this.nodeLabelExpression);
        }
        vargs.add("--priority " + String.valueOf(this.shellCmdPriority));
        for (Map.Entry entry : this.shellEnv.entrySet()) {
            vargs.add("--shell_env " + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        if (this.debugFlag) {
            vargs.add("--debug");
        }
        vargs.add("1><LOG_DIR>/AppMaster.stdout");
        vargs.add("2><LOG_DIR>/AppMaster.stderr");
        StringBuilder command = new StringBuilder();
        for (CharSequence charSequence : vargs) {
            command.append(charSequence).append(" ");
        }
        LOG.info((Object)("Completed setting up app master command " + command.toString()));
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(command.toString());
        ContainerLaunchContext containerLaunchContext = ContainerLaunchContext.newInstance(localResources, env, commands, null, null, null);
        Resource capability = Resource.newInstance((int)this.amMemory, (int)this.amVCores);
        appContext.setResource(capability);
        if (UserGroupInformation.isSecurityEnabled()) {
            Credentials credentials = new Credentials();
            String tokenRenewer = this.conf.get("yarn.resourcemanager.principal");
            if (tokenRenewer == null || tokenRenewer.length() == 0) {
                throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
            }
            Token[] tokens = fs.addDelegationTokens(tokenRenewer, credentials);
            if (tokens != null) {
                for (Token token : tokens) {
                    LOG.info((Object)("Got dt for " + fs.getUri() + "; " + token));
                }
            }
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer fsTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            containerLaunchContext.setTokens(fsTokens);
        }
        appContext.setAMContainerSpec(containerLaunchContext);
        Priority pri = Priority.newInstance((int)this.amPriority);
        appContext.setPriority(pri);
        appContext.setQueue(this.amQueue);
        LOG.info((Object)"Submitting application to ASM");
        this.yarnClient.submitApplication(appContext);
        return this.monitorApplication(appId);
    }

    private boolean monitorApplication(ApplicationId appId) throws YarnException, IOException {
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Thread sleep in monitoring loop interrupted");
            }
            ApplicationReport report = this.yarnClient.getApplicationReport(appId);
            LOG.info((Object)("Got application report from ASM for, appId=" + appId.getId() + ", clientToAMToken=" + report.getClientToAMToken() + ", appDiagnostics=" + report.getDiagnostics() + ", appMasterHost=" + report.getHost() + ", appQueue=" + report.getQueue() + ", appMasterRpcPort=" + report.getRpcPort() + ", appStartTime=" + report.getStartTime() + ", yarnAppState=" + report.getYarnApplicationState().toString() + ", distributedFinalState=" + report.getFinalApplicationStatus().toString() + ", appTrackingUrl=" + report.getTrackingUrl() + ", appUser=" + report.getUser()));
            YarnApplicationState state = report.getYarnApplicationState();
            FinalApplicationStatus dsStatus = report.getFinalApplicationStatus();
            if (YarnApplicationState.FINISHED == state) {
                if (FinalApplicationStatus.SUCCEEDED == dsStatus) {
                    LOG.info((Object)"Application has completed successfully. Breaking monitoring loop");
                    return true;
                }
                LOG.info((Object)("Application did finished unsuccessfully. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop"));
                return false;
            }
            if (YarnApplicationState.KILLED != state && YarnApplicationState.FAILED != state) continue;
            LOG.info((Object)("Application did not finish. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop"));
            return false;
        } while (System.currentTimeMillis() <= this.clientStartTime + this.clientTimeout);
        LOG.info((Object)"Reached client specified timeout for application. Killing application");
        this.forceKillApplication(appId);
        return false;
    }

    private void forceKillApplication(ApplicationId appId) throws YarnException, IOException {
        this.yarnClient.killApplication(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLocalResources(FileSystem fs, String fileSrcPath, String fileDstPath, String appId, Map<String, LocalResource> localResources, String resources) throws IOException {
        Path dst;
        block3: {
            block2: {
                String suffix = this.appName + "/" + appId + "/" + fileDstPath;
                dst = new Path(fs.getHomeDirectory(), suffix);
                if (fileSrcPath != null) break block2;
                FSDataOutputStream ostream = null;
                try {
                    ostream = FileSystem.create((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(456));
                    ostream.writeUTF(resources);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ostream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)ostream);
                break block3;
            }
            fs.copyFromLocalFile(new Path(fileSrcPath), dst);
        }
        FileStatus scFileStatus = fs.getFileStatus(dst);
        LocalResource scRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)dst.toUri()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        localResources.put(fileDstPath, scRsrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTimelineDomain() {
        TimelineClient timelineClient = null;
        if (!this.conf.getBoolean("yarn.timeline-service.enabled", false)) {
            LOG.warn((Object)("Cannot put the domain " + this.domainId + " because the timeline service is not enabled"));
            return;
        }
        timelineClient = TimelineClient.createTimelineClient();
        timelineClient.init(this.conf);
        timelineClient.start();
        try {
            TimelineDomain domain = new TimelineDomain();
            domain.setId(this.domainId);
            domain.setReaders(this.viewACLs != null && this.viewACLs.length() > 0 ? this.viewACLs : " ");
            domain.setWriters(this.modifyACLs != null && this.modifyACLs.length() > 0 ? this.modifyACLs : " ");
            timelineClient.putDomain(domain);
            LOG.info((Object)("Put the timeline domain: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)domain)));
        }
        catch (Exception e) {
            LOG.error((Object)"Error when putting the timeline domain", (Throwable)e);
        }
        finally {
            timelineClient.stop();
        }
    }
}

