/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.applications.distributedshell.Client;
import org.apache.hadoop.yarn.applications.distributedshell.TestDistributedShell;
import org.apache.hadoop.yarn.applications.distributedshell.TestDistributedShellWithNodeLabels;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDistributedShellWithNodeLabels {
    private static final Log LOG = LogFactory.getLog(TestDistributedShellWithNodeLabels.class);
    static final int NUM_NMS = 2;
    TestDistributedShell distShellTest;

    @Before
    public void setup() throws Exception {
        this.distShellTest = new TestDistributedShell();
        this.distShellTest.setupInternal(2);
    }

    private void initializeNodeLabels() throws IOException {
        RMContext rmContext = this.distShellTest.yarnCluster.getResourceManager(0).getRMContext();
        RMNodeLabelsManager labelsMgr = rmContext.getNodeLabelManager();
        HashSet<String> labels = new HashSet<String>();
        labels.add("x");
        labelsMgr.addToCluserNodeLabels(labels);
        this.distShellTest.conf.set("yarn.scheduler.capacity.root.accessible-node-labels", "x");
        this.distShellTest.conf.set("yarn.scheduler.capacity.root.accessible-node-labels.x.capacity", "100");
        this.distShellTest.conf.set("yarn.scheduler.capacity.root.default.accessible-node-labels", "x");
        this.distShellTest.conf.set("yarn.scheduler.capacity.root.default.accessible-node-labels.x.capacity", "100");
        rmContext.getScheduler().reinitialize((Configuration)this.distShellTest.conf, rmContext);
        NodeId[] nodeIds = new NodeId[2];
        for (int i = 0; i < 2; ++i) {
            NodeManager mgr = this.distShellTest.yarnCluster.getNodeManager(i);
            nodeIds[i] = mgr.getNMContext().getNodeId();
        }
        labelsMgr.addLabelsToNode((Map)ImmutableMap.of((Object)nodeIds[1], labels));
    }

    @Test(timeout=90000L)
    public void testDSShellWithNodeLabelExpression() throws Exception {
        this.initializeNodeLabels();
        NMContainerMonitor mon = new NMContainerMonitor(this);
        Thread t = new Thread((Runnable)mon);
        t.start();
        String[] args = new String[]{"--jar", TestDistributedShell.APPMASTER_JAR, "--num_containers", "4", "--shell_command", "sleep", "--shell_args", "15", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1", "--node_label_expression", "x"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.distShellTest.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        t.interrupt();
        int[] maxRunningContainersOnNMs = mon.getMaxRunningContainersReport();
        Assert.assertEquals((long)0L, (long)maxRunningContainersOnNMs[0]);
        Assert.assertTrue((maxRunningContainersOnNMs[1] > 0 ? 1 : 0) != 0);
    }
}

