/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationMaster {
    private static final Log LOG = LogFactory.getLog(ApplicationMaster.class);
    private Configuration conf;
    private AMRMClientAsync amRMClient;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    private ApplicationAttemptId appAttemptID;
    private String appMasterHostname = "";
    private int appMasterRpcPort = -1;
    private String appMasterTrackingUrl = "";
    private int numTotalContainers = 1;
    private int containerMemory = 10;
    private int requestPriority;
    private AtomicInteger numCompletedContainers = new AtomicInteger();
    private AtomicInteger numAllocatedContainers = new AtomicInteger();
    private AtomicInteger numFailedContainers = new AtomicInteger();
    private AtomicInteger numRequestedContainers = new AtomicInteger();
    private String shellCommand = "";
    private String shellArgs = "";
    private Map<String, String> shellEnv = new HashMap();
    private String shellScriptPath = "";
    private long shellScriptPathTimestamp = 0L;
    private long shellScriptPathLen = 0L;
    private final String ExecShellStringPath = "ExecShellScript.sh";
    private volatile boolean done;
    private volatile boolean success;
    private ByteBuffer allTokens;
    private List<Thread> launchThreads = new ArrayList();

    public static void main(String[] args) {
        boolean result = false;
        try {
            ApplicationMaster appMaster = new ApplicationMaster();
            LOG.info((Object)"Initializing ApplicationMaster");
            boolean doRun = appMaster.init(args);
            if (!doRun) {
                System.exit(0);
            }
            result = appMaster.run();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error running ApplicationMaster", t);
            System.exit(1);
        }
        if (result) {
            LOG.info((Object)"Application Master completed successfully. exiting");
            System.exit(0);
        } else {
            LOG.info((Object)"Application Master failed. exiting");
            System.exit(2);
        }
    }

    private void dumpOutDebugInfo() {
        LOG.info((Object)"Dump debug output");
        Map<String, String> envs = System.getenv();
        for (Map.Entry<String, String> env : envs.entrySet()) {
            LOG.info((Object)("System env: key=" + env.getKey() + ", val=" + env.getValue()));
            System.out.println("System env: key=" + env.getKey() + ", val=" + env.getValue());
        }
        String cmd = "ls -al";
        Runtime run = Runtime.getRuntime();
        Process pr = null;
        try {
            pr = run.exec(cmd);
            pr.waitFor();
            BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = "";
            while ((line = buf.readLine()) != null) {
                LOG.info((Object)("System CWD content: " + line));
                System.out.println("System CWD content: " + line);
            }
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public ApplicationMaster() {
        this.conf = new YarnConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(String[] args) throws ParseException, IOException {
        Map<String, String> envs;
        Options opts = new Options();
        opts.addOption("app_attempt_id", true, "App Attempt ID. Not to be used unless for testing purposes");
        opts.addOption("shell_command", true, "Shell command to be executed by the Application Master");
        opts.addOption("shell_script", true, "Location of the shell script to be executed");
        opts.addOption("shell_args", true, "Command line args for the shell script");
        opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
        opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the shell command");
        opts.addOption("num_containers", true, "No. of containers on which the shell command needs to be executed");
        opts.addOption("priority", true, "Application Priority. Default 0");
        opts.addOption("debug", false, "Dump out debug information");
        opts.addOption("help", false, "Print usage");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (args.length == 0) {
            this.printUsage(opts);
            throw new IllegalArgumentException("No args specified for application master to initialize");
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.dumpOutDebugInfo();
        }
        if (!(envs = System.getenv()).containsKey(ApplicationConstants.Environment.CONTAINER_ID.name())) {
            if (!cliParser.hasOption("app_attempt_id")) throw new IllegalArgumentException("Application Attempt Id not set in the environment");
            String appIdStr = cliParser.getOptionValue("app_attempt_id", "");
            this.appAttemptID = ConverterUtils.toApplicationAttemptId((String)appIdStr);
        } else {
            ContainerId containerId = ConverterUtils.toContainerId((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
            this.appAttemptID = containerId.getApplicationAttemptId();
        }
        if (!envs.containsKey("APP_SUBMIT_TIME_ENV")) {
            throw new RuntimeException("APP_SUBMIT_TIME_ENV not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HOST.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HOST.name() + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HTTP_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HTTP_PORT + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_PORT.name() + " not set in the environment");
        }
        LOG.info((Object)("Application master for app, appId=" + this.appAttemptID.getApplicationId().getId() + ", clustertimestamp=" + this.appAttemptID.getApplicationId().getClusterTimestamp() + ", attemptId=" + this.appAttemptID.getAttemptId()));
        if (!cliParser.hasOption("shell_command")) {
            throw new IllegalArgumentException("No shell command specified to be executed by application master");
        }
        this.shellCommand = cliParser.getOptionValue("shell_command");
        if (cliParser.hasOption("shell_args")) {
            this.shellArgs = cliParser.getOptionValue("shell_args");
        }
        if (cliParser.hasOption("shell_env")) {
            String[] shellEnvs;
            for (String env : shellEnvs = cliParser.getOptionValues("shell_env")) {
                int index = (env = env.trim()).indexOf(61);
                if (index == -1) {
                    this.shellEnv.put(env, "");
                    continue;
                }
                String key = env.substring(0, index);
                String val = "";
                if (index < env.length() - 1) {
                    val = env.substring(index + 1);
                }
                this.shellEnv.put(key, val);
            }
        }
        if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTLOCATION")) {
            this.shellScriptPath = envs.get("DISTRIBUTEDSHELLSCRIPTLOCATION");
            if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTTIMESTAMP")) {
                this.shellScriptPathTimestamp = Long.valueOf(envs.get("DISTRIBUTEDSHELLSCRIPTTIMESTAMP"));
            }
            if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTLEN")) {
                this.shellScriptPathLen = Long.valueOf(envs.get("DISTRIBUTEDSHELLSCRIPTLEN"));
            }
            if (!(this.shellScriptPath.isEmpty() || this.shellScriptPathTimestamp > 0L && this.shellScriptPathLen > 0L)) {
                LOG.error((Object)("Illegal values in env for shell script path, path=" + this.shellScriptPath + ", len=" + this.shellScriptPathLen + ", timestamp=" + this.shellScriptPathTimestamp));
                throw new IllegalArgumentException("Illegal values in env for shell script path");
            }
        }
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.numTotalContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.numTotalContainers == 0) {
            throw new IllegalArgumentException("Cannot run distributed shell with no containers");
        }
        this.requestPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        return true;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("ApplicationMaster", opts);
    }

    public boolean run() throws YarnException, IOException {
        LOG.info((Object)"Starting ApplicationMaster");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        this.allTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        RMCallbackHandler allocListener = new RMCallbackHandler(this, null);
        this.amRMClient = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.CallbackHandler)allocListener);
        this.amRMClient.init(this.conf);
        this.amRMClient.start();
        this.containerListener = this.createNMCallbackHandler();
        this.nmClientAsync = new NMClientAsyncImpl((NMClientAsync.CallbackHandler)this.containerListener);
        this.nmClientAsync.init(this.conf);
        this.nmClientAsync.start();
        this.appMasterHostname = NetUtils.getHostname();
        RegisterApplicationMasterResponse response = this.amRMClient.registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
        int maxMem = response.getMaximumResourceCapability().getMemory();
        LOG.info((Object)("Max mem capabililty of resources in this cluster " + maxMem));
        if (this.containerMemory > maxMem) {
            LOG.info((Object)("Container memory specified above max threshold of cluster. Using max value., specified=" + this.containerMemory + ", max=" + maxMem));
            this.containerMemory = maxMem;
        }
        for (int i = 0; i < this.numTotalContainers; ++i) {
            AMRMClient.ContainerRequest containerAsk = this.setupContainerAskForRM();
            this.amRMClient.addContainerRequest(containerAsk);
        }
        this.numRequestedContainers.set(this.numTotalContainers);
        while (!this.done && this.numCompletedContainers.get() != this.numTotalContainers) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {}
        }
        this.finish();
        return this.success;
    }

    @VisibleForTesting
    NMCallbackHandler createNMCallbackHandler() {
        return new NMCallbackHandler(this);
    }

    private void finish() {
        FinalApplicationStatus appStatus;
        for (Thread launchThread : this.launchThreads) {
            try {
                launchThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Exception thrown in thread join: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        LOG.info((Object)"Application completed. Stopping running containers");
        this.nmClientAsync.stop();
        LOG.info((Object)"Application completed. Signalling finish to RM");
        String appMessage = null;
        this.success = true;
        if (this.numFailedContainers.get() == 0 && this.numCompletedContainers.get() == this.numTotalContainers) {
            appStatus = FinalApplicationStatus.SUCCEEDED;
        } else {
            appStatus = FinalApplicationStatus.FAILED;
            appMessage = "Diagnostics., total=" + this.numTotalContainers + ", completed=" + this.numCompletedContainers.get() + ", allocated=" + this.numAllocatedContainers.get() + ", failed=" + this.numFailedContainers.get();
            this.success = false;
        }
        try {
            this.amRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (YarnException ex) {
            LOG.error((Object)"Failed to unregister application", (Throwable)ex);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to unregister application", (Throwable)e);
        }
        this.amRMClient.stop();
    }

    private AMRMClient.ContainerRequest setupContainerAskForRM() {
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(this.requestPriority);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(this.containerMemory);
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, null, null, pri);
        LOG.info((Object)("Requested container ask: " + request.toString()));
        return request;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ AtomicInteger access$200(ApplicationMaster x0) {
        return x0.numCompletedContainers;
    }

    static /* synthetic */ AtomicInteger access$300(ApplicationMaster x0) {
        return x0.numFailedContainers;
    }

    static /* synthetic */ AtomicInteger access$400(ApplicationMaster x0) {
        return x0.numAllocatedContainers;
    }

    static /* synthetic */ AtomicInteger access$500(ApplicationMaster x0) {
        return x0.numRequestedContainers;
    }

    static /* synthetic */ int access$600(ApplicationMaster x0) {
        return x0.numTotalContainers;
    }

    static /* synthetic */ AMRMClient.ContainerRequest access$700(ApplicationMaster x0) {
        return x0.setupContainerAskForRM();
    }

    static /* synthetic */ AMRMClientAsync access$800(ApplicationMaster x0) {
        return x0.amRMClient;
    }

    static /* synthetic */ boolean access$902(ApplicationMaster x0, boolean x1) {
        x0.done = x1;
        return x0.done;
    }

    static /* synthetic */ NMCallbackHandler access$1000(ApplicationMaster x0) {
        return x0.containerListener;
    }

    static /* synthetic */ List access$1100(ApplicationMaster x0) {
        return x0.launchThreads;
    }

    static /* synthetic */ NMClientAsync access$1200(ApplicationMaster x0) {
        return x0.nmClientAsync;
    }

    static /* synthetic */ Map access$1300(ApplicationMaster x0) {
        return x0.shellEnv;
    }

    static /* synthetic */ String access$1400(ApplicationMaster x0) {
        return x0.shellScriptPath;
    }

    static /* synthetic */ long access$1500(ApplicationMaster x0) {
        return x0.shellScriptPathTimestamp;
    }

    static /* synthetic */ long access$1600(ApplicationMaster x0) {
        return x0.shellScriptPathLen;
    }

    static /* synthetic */ String access$1700(ApplicationMaster x0) {
        return x0.shellCommand;
    }

    static /* synthetic */ String access$1800(ApplicationMaster x0) {
        return x0.shellArgs;
    }

    static /* synthetic */ ByteBuffer access$1900(ApplicationMaster x0) {
        return x0.allTokens;
    }
}

