/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.applications.distributedshell.Client;
import org.apache.hadoop.yarn.applications.distributedshell.ContainerLaunchFailAppMaster;
import org.apache.hadoop.yarn.applications.distributedshell.TestDistributedShell;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistributedShell {
    private static final Log LOG = LogFactory.getLog(TestDistributedShell.class);
    protected static MiniYARNCluster yarnCluster = null;
    protected static Configuration conf = new YarnConfiguration();
    protected static String APPMASTER_JAR = JarFinder.getJar(ApplicationMaster.class);

    @BeforeClass
    public static void setup() throws Exception {
        LOG.info((Object)"Starting up YARN cluster");
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 128);
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        if (yarnCluster == null) {
            yarnCluster = new MiniYARNCluster(TestDistributedShell.class.getSimpleName(), 1, 1, 1);
            yarnCluster.init(conf);
            yarnCluster.start();
            NodeManager nm = yarnCluster.getNodeManager(0);
            TestDistributedShell.waitForNMToRegister((NodeManager)nm);
            URL url = Thread.currentThread().getContextClassLoader().getResource("yarn-site.xml");
            if (url == null) {
                throw new RuntimeException("Could not find 'yarn-site.xml' dummy file in classpath");
            }
            Configuration yarnClusterConfig = yarnCluster.getConfig();
            yarnClusterConfig.set("yarn.application.classpath", new File(url.getPath()).getParent());
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            yarnClusterConfig.writeXml((OutputStream)bytesOut);
            bytesOut.close();
            FileOutputStream os = new FileOutputStream(new File(url.getPath()));
            ((OutputStream)os).write(bytesOut.toByteArray());
            ((OutputStream)os).close();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOG.info((Object)("setup thread sleep interrupted. message=" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDown() throws IOException {
        if (yarnCluster != null) {
            try {
                yarnCluster.stop();
            }
            finally {
                yarnCluster = null;
            }
        }
    }

    @Test(timeout=90000L)
    public void testDSShell() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        AtomicBoolean result = new AtomicBoolean(false);
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init(new Configuration(yarnCluster.getConfig()));
        yarnClient.start();
        String hostName = NetUtils.getHostname();
        boolean verified = false;
        while (!verified) {
            List apps = yarnClient.getApplications();
            if (apps.size() == 0) {
                Thread.sleep(10L);
                continue;
            }
            ApplicationReport appReport = (ApplicationReport)apps.get(0);
            if (appReport.getHost().startsWith(hostName) && appReport.getRpcPort() == -1) {
                verified = true;
            }
            if (appReport.getYarnApplicationState() != YarnApplicationState.FINISHED) continue;
            break;
        }
        Assert.assertTrue((boolean)verified);
        t.join();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertTrue((boolean)result.get());
    }

    @Test(timeout=90000L)
    public void testDSShellWithInvalidArgs() throws Exception {
        String[] args;
        Client client = new Client(new Configuration(yarnCluster.getConfig()));
        LOG.info((Object)"Initializing DS Client with no args");
        try {
            client.init(new String[0]);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No args"));
        }
        LOG.info((Object)"Initializing DS Client with no jar file");
        try {
            args = new String[]{"--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No jar"));
        }
        LOG.info((Object)"Initializing DS Client with no shell command");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No shell command"));
        }
        LOG.info((Object)"Initializing DS Client with invalid no. of containers");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "-1", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("Invalid no. of containers"));
        }
    }

    protected static void waitForNMToRegister(NodeManager nm) throws Exception {
        int attempt = 60;
        ContainerManagerImpl cm = (ContainerManagerImpl)nm.getNMContext().getContainerManager();
        while (cm.getBlockNewContainerRequestsStatus() && attempt-- > 0) {
            Thread.sleep(2000L);
        }
    }

    @Test(timeout=90000L)
    public void testContainerLaunchFailureHandling() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(ContainerLaunchFailAppMaster.class.getName(), new Configuration(yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertFalse((boolean)result);
    }
}

