/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class Resource
implements Comparable<Resource> {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(int memory, int vCores) {
        Resource resource = Records.newRecord(Resource.class);
        resource.setMemory(memory);
        resource.setVirtualCores(vCores);
        resource.setDisks(0.0);
        return resource;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(int memory, int vCores, double disks) {
        Resource resource = Resource.newInstance(memory, vCores);
        resource.setDisks(disks);
        return resource;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getMemory();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setMemory(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract int getVirtualCores();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract void setVirtualCores(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract double getDisks();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setDisks(double var1);

    public int hashCode() {
        int prime = 263167;
        int result = 3571;
        result = 939769357 + this.getMemory();
        result = 263167 * result + this.getVirtualCores();
        result = 263167 * result + Resource.getAbsIntValue(this.getDisks());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return this.getMemory() == other.getMemory() && this.getVirtualCores() == other.getVirtualCores() && this.getDisks() == other.getDisks();
    }

    public String toString() {
        return "<memory:" + this.getMemory() + ", vCores:" + this.getVirtualCores() + ", disks:" + this.getDisks() + ">";
    }

    public static int getAbsIntValue(double dValue) {
        double absValue = dValue;
        if (dValue > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (dValue < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (Math.abs(dValue) < 1.0) {
            absValue = Math.ceil(Math.abs(dValue));
            if (dValue < 0.0) {
                absValue *= -1.0;
            }
        }
        return (int)absValue;
    }
}

