/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DistCp
implements Tool {
    public static final Log LOG = LogFactory.getLog(DistCp.class);
    private static final String NAME = "distcp";
    private static final String usage = "distcp [OPTIONS] <srcurl>* <desturl>\n\nOPTIONS:\n-p[rbugp]              Preserve status\n                       r: replication number\n                       b: block size\n                       u: user\n                       g: group\n                       p: permission\n                       -p alone is equivalent to -prbugp\n-i                     Ignore failures\n-log <logdir>          Write logs to <logdir>\n-m <num_maps>          Maximum number of simultaneous copies\n-overwrite             Overwrite destination\n-update                Overwrite if src size different from dst size\n-skipcrccheck          Do not use CRC check to determine if src is \n                       different from dest. Relevant only if -update\n                       is specified\n-f <urilist_uri>       Use list at <urilist_uri> as src list\n-filelimit <n>         Limit the total number of files to be <= n\n-sizelimit <n>         Limit the total size to be <= n bytes\n-filesizemin <n>       Limit the file size to be >= n bytes (default 0)\n-filesizemax <n>       Limit the file size to be < n bytes (default 8 exbibyte)\n-delete                Delete the files existing in the dst but not in src\n-mapredSslConf <f>     Filename of SSL configuration for mapper task\n\nNOTE 1: if -overwrite or -update are set, each source URI is \n      interpreted as an isomorphic update to an existing directory.\nFor example:\nhadoop distcp -p -update \"hdfs://A:8020/user/foo/bar\" \"hdfs://B:8020/user/foo/baz\"\n\n     would update all descendants of 'baz' also in 'bar'; it would \n     *not* update /user/foo/baz/bar\n\nNOTE 2: The parameter <n> in -filelimit, -sizelimit, -filesizemin and -filesizemax can be \n     specified with symbolic representation.  For examples,\n       1230k = 1230 * 1024 = 1259520\n       891g = 891 * 1024^3 = 956703965184\n";
    private static final long BYTES_PER_MAP = 0x10000000L;
    private static final int MAX_MAPS_PER_NODE = 20;
    private static final int SYNC_FILE_MAX = 10;
    static final String TMP_DIR_LABEL = "distcp.tmp.dir";
    static final String DST_DIR_LABEL = "distcp.dest.path";
    static final String JOB_DIR_LABEL = "distcp.job.dir";
    static final String MAX_MAPS_LABEL = "distcp.max.map.tasks";
    static final String SRC_LIST_LABEL = "distcp.src.list";
    static final String SRC_COUNT_LABEL = "distcp.src.count";
    static final String TOTAL_SIZE_LABEL = "distcp.total.size";
    static final String DST_DIR_LIST_LABEL = "distcp.dst.dir.list";
    static final String BYTES_PER_MAP_LABEL = "distcp.bytes.per.map";
    static final String PRESERVE_STATUS_LABEL = Options.PRESERVE_STATUS.propertyname + ".value";
    private JobConf conf;
    private static final Random RANDOM = new Random();

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public DistCp(Configuration conf) {
        this.setConf(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Path> fetchFileList(Configuration conf, Path srcList) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        FileSystem fs = srcList.getFileSystem(conf);
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader((InputStream)fs.open(srcList)));
            String line = input.readLine();
            while (line != null) {
                result.add(new Path(line));
                line = input.readLine();
            }
        }
        catch (Throwable throwable) {
            DistCp.checkAndClose(input);
            throw throwable;
        }
        DistCp.checkAndClose(input);
        return result;
    }

    @Deprecated
    public static void copy(Configuration conf, String srcPath, String destPath, Path logPath, boolean srcAsList, boolean ignoreReadFailures) throws IOException {
        Path src = new Path(srcPath);
        ArrayList<Path> tmp = new ArrayList<Path>();
        if (srcAsList) {
            tmp.addAll(DistCp.fetchFileList(conf, src));
        } else {
            tmp.add(src);
        }
        EnumSet<Options> flags = ignoreReadFailures ? EnumSet.of(Options.IGNORE_READ_FAILURES) : EnumSet.noneOf(Options.class);
        Path dst = new Path(destPath);
        DistCp.copy(conf, new Arguments(tmp, dst, logPath, flags, null, Long.MAX_VALUE, Long.MAX_VALUE, 0L, Long.MAX_VALUE, null));
    }

    private static void checkSrcPath(JobConf jobConf, List<Path> srcPaths) throws IOException {
        ArrayList<IOException> rslt = new ArrayList<IOException>();
        Path[] ps = new Path[srcPaths.size()];
        ps = srcPaths.toArray(ps);
        TokenCache.obtainTokensForNamenodes((Credentials)jobConf.getCredentials(), (Path[])ps, (Configuration)jobConf);
        for (Path p : srcPaths) {
            FileSystem fs = p.getFileSystem((Configuration)jobConf);
            if (fs.exists(p)) continue;
            rslt.add(new IOException("Input source " + p + " does not exist."));
        }
        if (!rslt.isEmpty()) {
            throw new InvalidInputException(rslt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(Configuration conf, Arguments args) throws IOException {
        LOG.info((Object)("srcPaths=" + args.srcs));
        LOG.info((Object)("destPath=" + args.dst));
        JobConf job = DistCp.createJobConf(conf);
        DistCp.checkSrcPath(job, args.srcs);
        if (args.preservedAttributes != null) {
            job.set(PRESERVE_STATUS_LABEL, args.preservedAttributes);
        }
        if (args.mapredSslConf != null) {
            job.set("dfs.https.client.keystore.resource", args.mapredSslConf);
        }
        try {
            if (DistCp.setup(conf, job, args)) {
                JobClient.runJob((JobConf)job);
            }
            DistCp.finalize(conf, job, args.dst, args.preservedAttributes);
        }
        finally {
            DistCp.fullyDelete(job.get(TMP_DIR_LABEL), (Configuration)job);
            DistCp.fullyDelete(job.get(JOB_DIR_LABEL), (Configuration)job);
        }
    }

    private static void updatePermissions(FileStatus src, FileStatus dst, EnumSet<FileAttribute> preseved, FileSystem destFileSys) throws IOException {
        String owner = null;
        String group = null;
        if (preseved.contains((Object)FileAttribute.USER) && !src.getOwner().equals(dst.getOwner())) {
            owner = src.getOwner();
        }
        if (preseved.contains((Object)FileAttribute.GROUP) && !src.getGroup().equals(dst.getGroup())) {
            group = src.getGroup();
        }
        if (owner != null || group != null) {
            destFileSys.setOwner(dst.getPath(), owner, group);
        }
        if (preseved.contains((Object)FileAttribute.PERMISSION) && !src.getPermission().equals((Object)dst.getPermission())) {
            destFileSys.setPermission(dst.getPath(), src.getPermission());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finalize(Configuration conf, JobConf jobconf, Path destPath, String presevedAttributes) throws IOException {
        if (presevedAttributes == null) {
            return;
        }
        EnumSet<FileAttribute> preseved = FileAttribute.parse(presevedAttributes);
        if (!(preseved.contains((Object)FileAttribute.USER) || preseved.contains((Object)FileAttribute.GROUP) || preseved.contains((Object)FileAttribute.PERMISSION))) {
            return;
        }
        FileSystem dstfs = destPath.getFileSystem(conf);
        Path dstdirlist = new Path(jobconf.get(DST_DIR_LIST_LABEL));
        SequenceFile.Reader in = null;
        try {
            in = new SequenceFile.Reader(dstdirlist.getFileSystem((Configuration)jobconf), dstdirlist, (Configuration)jobconf);
            Text dsttext = new Text();
            FilePair pair = new FilePair();
            while (in.next((Writable)dsttext, (Writable)pair)) {
                Path absdst = new Path(destPath, pair.output);
                DistCp.updatePermissions(pair.input, dstfs.getFileStatus(absdst), preseved, dstfs);
            }
        }
        catch (Throwable throwable) {
            DistCp.checkAndClose(in);
            throw throwable;
        }
        DistCp.checkAndClose((Closeable)in);
    }

    public int run(String[] args) {
        try {
            DistCp.copy((Configuration)this.conf, Arguments.valueOf(args, (Configuration)this.conf));
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println(StringUtils.stringifyException((Throwable)e) + "\n" + usage);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return -1;
        }
        catch (DuplicationException e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            return -2;
        }
        catch (RemoteException e) {
            IOException unwrapped = e.unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class, QuotaExceededException.class});
            System.err.println(StringUtils.stringifyException((Throwable)unwrapped));
            return -3;
        }
        catch (Exception e) {
            System.err.println("With failures, global counters are inaccurate; consider running with -i");
            System.err.println("Copy failed: " + StringUtils.stringifyException((Throwable)e));
            return -999;
        }
    }

    public static void main(String[] args) throws Exception {
        JobConf job = new JobConf(DistCp.class);
        job.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
        DistCp distcp = new DistCp((Configuration)job);
        int res = ToolRunner.run((Tool)distcp, (String[])args);
        System.exit(res);
    }

    static String makeRelative(Path root, Path absPath) {
        if (!absPath.isAbsolute()) {
            throw new IllegalArgumentException("!absPath.isAbsolute(), absPath=" + absPath);
        }
        String p = absPath.toUri().getPath();
        StringTokenizer pathTokens = new StringTokenizer(p, "/");
        StringTokenizer rootTokens = new StringTokenizer(root.toUri().getPath(), "/");
        while (rootTokens.hasMoreTokens()) {
            if (rootTokens.nextToken().equals(pathTokens.nextToken())) continue;
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (pathTokens.hasMoreTokens()) {
            sb.append(pathTokens.nextToken());
            if (!pathTokens.hasMoreTokens()) continue;
            sb.append("/");
        }
        return sb.length() == 0 ? "." : sb.toString();
    }

    private static void setMapCount(long totalBytes, JobConf job) throws IOException {
        int numMaps = (int)(totalBytes / job.getLong(BYTES_PER_MAP_LABEL, 0x10000000L));
        numMaps = Math.min(numMaps, job.getInt(MAX_MAPS_LABEL, 20 * new JobClient(job).getClusterStatus().getTaskTrackers()));
        job.setNumMapTasks(Math.max(numMaps, 1));
    }

    static void fullyDelete(String dir, Configuration conf) throws IOException {
        Path tmp;
        boolean success;
        if (dir != null && !(success = (tmp = new Path(dir)).getFileSystem(conf).delete(tmp, true))) {
            LOG.warn((Object)("Could not fully delete " + tmp));
        }
    }

    private static JobConf createJobConf(Configuration conf) {
        JobConf jobconf = new JobConf(conf, DistCp.class);
        jobconf.setJobName(NAME);
        jobconf.setMapSpeculativeExecution(false);
        jobconf.setInputFormat(CopyInputFormat.class);
        jobconf.setOutputKeyClass(Text.class);
        jobconf.setOutputValueClass(Text.class);
        jobconf.setMapperClass(CopyFilesMapper.class);
        jobconf.setNumReduceTasks(0);
        return jobconf;
    }

    public static String getRandomId() {
        return Integer.toString(RANDOM.nextInt(Integer.MAX_VALUE), 36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setup(Configuration conf, JobConf jobConf, Arguments args) throws IOException {
        Path logPath;
        Path stagingArea;
        jobConf.set(DST_DIR_LABEL, args.dst.toUri().toString());
        boolean update = args.flags.contains((Object)Options.UPDATE);
        boolean skipCRCCheck = args.flags.contains((Object)Options.SKIPCRC);
        boolean overwrite = !update && args.flags.contains((Object)Options.OVERWRITE);
        jobConf.setBoolean(Options.UPDATE.propertyname, update);
        jobConf.setBoolean(Options.SKIPCRC.propertyname, skipCRCCheck);
        jobConf.setBoolean(Options.OVERWRITE.propertyname, overwrite);
        jobConf.setBoolean(Options.IGNORE_READ_FAILURES.propertyname, args.flags.contains((Object)Options.IGNORE_READ_FAILURES));
        jobConf.setBoolean(Options.PRESERVE_STATUS.propertyname, args.flags.contains((Object)Options.PRESERVE_STATUS));
        String randomId = DistCp.getRandomId();
        JobClient jClient = new JobClient(jobConf);
        try {
            stagingArea = JobSubmissionFiles.getStagingDir((JobClient)jClient, (Configuration)conf);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        Path jobDirectory = new Path(stagingArea + NAME + "_" + randomId);
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        FileSystem.mkdirs((FileSystem)jClient.getFs(), (Path)jobDirectory, (FsPermission)mapredSysPerms);
        jobConf.set(JOB_DIR_LABEL, jobDirectory.toString());
        long maxBytesPerMap = conf.getLong(BYTES_PER_MAP_LABEL, 0x10000000L);
        FileSystem dstfs = args.dst.getFileSystem(conf);
        TokenCache.obtainTokensForNamenodes((Credentials)jobConf.getCredentials(), (Path[])new Path[]{args.dst}, (Configuration)conf);
        boolean dstExists = dstfs.exists(args.dst);
        boolean dstIsDir = false;
        if (dstExists) {
            dstIsDir = dstfs.getFileStatus(args.dst).isDir();
        }
        if ((logPath = args.log) == null) {
            String filename = "_distcp_logs_" + randomId;
            if (!dstExists || !dstIsDir) {
                Path parent = args.dst.getParent();
                if (null == parent) {
                    parent = args.dst;
                }
                if (!dstfs.exists(parent)) {
                    dstfs.mkdirs(parent);
                }
                logPath = new Path(parent, filename);
            } else {
                logPath = new Path(args.dst, filename);
            }
        }
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)logPath);
        FileSystem jobfs = jobDirectory.getFileSystem((Configuration)jobConf);
        Path srcfilelist = new Path(jobDirectory, "_distcp_src_files");
        jobConf.set(SRC_LIST_LABEL, srcfilelist.toString());
        SequenceFile.Writer src_writer = SequenceFile.createWriter((FileSystem)jobfs, (Configuration)jobConf, (Path)srcfilelist, LongWritable.class, FilePair.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        Path dstfilelist = new Path(jobDirectory, "_distcp_dst_files");
        SequenceFile.Writer dst_writer = SequenceFile.createWriter((FileSystem)jobfs, (Configuration)jobConf, (Path)dstfilelist, Text.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        Path dstdirlist = new Path(jobDirectory, "_distcp_dst_dirs");
        jobConf.set(DST_DIR_LIST_LABEL, dstdirlist.toString());
        SequenceFile.Writer dir_writer = SequenceFile.createWriter((FileSystem)jobfs, (Configuration)jobConf, (Path)dstdirlist, Text.class, FilePair.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        boolean special = args.srcs.size() == 1 && !dstExists || update || overwrite;
        int srcCount = 0;
        int cnsyncf = 0;
        int dirsyn = 0;
        long fileCount = 0L;
        long byteCount = 0L;
        long cbsyncs = 0L;
        try {
            for (Path src : args.srcs) {
                Path root;
                FileSystem srcfs = src.getFileSystem(conf);
                FileStatus srcfilestat = srcfs.getFileStatus(src);
                Path path = root = special && srcfilestat.isDir() ? src : src.getParent();
                if (srcfilestat.isDir()) {
                    ++srcCount;
                }
                Stack<FileStatus> pathstack = new Stack<FileStatus>();
                pathstack.push(srcfilestat);
                while (!pathstack.empty()) {
                    FileStatus cur = (FileStatus)pathstack.pop();
                    FileStatus[] children = srcfs.listStatus(cur.getPath());
                    for (int i = 0; i < children.length; ++i) {
                        boolean skipfile = false;
                        FileStatus child = children[i];
                        String dst = DistCp.makeRelative(root, child.getPath());
                        ++srcCount;
                        if (child.isDir()) {
                            pathstack.push(child);
                        } else if (child.getLen() < args.filesizemin || child.getLen() >= args.filesizemax) {
                            skipfile = true;
                            LOG.info((Object)("Skipping file '" + child.getPath() + "' as its size " + child.getLen() + " is outside of the reqested filesize range."));
                        } else {
                            skipfile = update && DistCp.sameFile(srcfs, child, dstfs, new Path(args.dst, dst), skipCRCCheck);
                            if (!(skipfile |= fileCount == args.filelimit || byteCount + child.getLen() > args.sizelimit)) {
                                ++fileCount;
                                byteCount += child.getLen();
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("adding file " + child.getPath()));
                                }
                                if (++cnsyncf > 10 || (cbsyncs += child.getLen()) > maxBytesPerMap) {
                                    src_writer.sync();
                                    dst_writer.sync();
                                    cnsyncf = 0;
                                    cbsyncs = 0L;
                                }
                            }
                        }
                        if (!skipfile) {
                            src_writer.append((Writable)new LongWritable(child.isDir() ? 0L : child.getLen()), (Writable)new FilePair(child, dst));
                        }
                        dst_writer.append((Writable)new Text(dst), (Writable)new Text(child.getPath().toString()));
                    }
                    if (!cur.isDir()) continue;
                    String dst = DistCp.makeRelative(root, cur.getPath());
                    dir_writer.append((Writable)new Text(dst), (Writable)new FilePair(cur, dst));
                    if (++dirsyn <= 10) continue;
                    dirsyn = 0;
                    dir_writer.sync();
                }
            }
        }
        finally {
            DistCp.checkAndClose((Closeable)src_writer);
            DistCp.checkAndClose((Closeable)dst_writer);
            DistCp.checkAndClose((Closeable)dir_writer);
        }
        FileStatus dststatus = null;
        try {
            dststatus = dstfs.getFileStatus(args.dst);
        }
        catch (FileNotFoundException fnfe) {
            LOG.info((Object)(args.dst + " does not exist."));
        }
        if (dststatus == null && srcCount > 1 && !dstfs.mkdirs(args.dst)) {
            throw new IOException("Failed to create" + args.dst);
        }
        Path sorted = new Path(jobDirectory, "_distcp_sorted");
        DistCp.checkDuplication(jobfs, dstfilelist, sorted, conf);
        if (dststatus != null && args.flags.contains((Object)Options.DELETE)) {
            DistCp.deleteNonexisting(dstfs, dststatus, sorted, jobfs, jobDirectory, jobConf, conf);
        }
        Path tmpDir = new Path(dstExists && !dstIsDir || !dstExists && srcCount == 1 ? args.dst.getParent() : args.dst, "_distcp_tmp_" + randomId);
        jobConf.set(TMP_DIR_LABEL, tmpDir.toUri().toString());
        tmpDir.getFileSystem(conf).mkdirs(tmpDir);
        LOG.info((Object)("sourcePathsCount=" + srcCount));
        LOG.info((Object)("filesToCopyCount=" + fileCount));
        LOG.info((Object)("bytesToCopyCount=" + StringUtils.humanReadableInt((long)byteCount)));
        jobConf.setInt(SRC_COUNT_LABEL, srcCount);
        jobConf.setLong(TOTAL_SIZE_LABEL, byteCount);
        DistCp.setMapCount(byteCount, jobConf);
        return fileCount > 0L;
    }

    private static boolean sameFile(FileSystem srcfs, FileStatus srcstatus, FileSystem dstfs, Path dstpath, boolean skipCRCCheck) throws IOException {
        FileChecksum srccs;
        FileStatus dststatus;
        try {
            dststatus = dstfs.getFileStatus(dstpath);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        if (srcstatus.getLen() != dststatus.getLen()) {
            return false;
        }
        if (skipCRCCheck) {
            LOG.debug((Object)"Skipping CRC Check");
            return true;
        }
        try {
            srccs = srcfs.getFileChecksum(srcstatus.getPath());
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        try {
            FileChecksum dstcs = dstfs.getFileChecksum(dststatus.getPath());
            return srccs == null || dstcs == null || srccs.equals((Object)dstcs);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteNonexisting(FileSystem dstfs, FileStatus dstroot, Path dstsorted, FileSystem jobfs, Path jobdir, JobConf jobconf, Configuration conf) throws IOException {
        if (!dstroot.isDir()) {
            throw new IOException("dst must be a directory when option " + Options.DELETE.cmd + " is set, but dst (= " + dstroot.getPath() + ") is not a directory.");
        }
        Path dstlsr = new Path(jobdir, "_distcp_dst_lsr");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)jobfs, (Configuration)jobconf, (Path)dstlsr, Text.class, dstroot.getClass(), (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        try {
            Stack<FileStatus> lsrstack = new Stack<FileStatus>();
            lsrstack.push(dstroot);
            while (!lsrstack.isEmpty()) {
                FileStatus status = (FileStatus)lsrstack.pop();
                if (!status.isDir()) continue;
                for (FileStatus child : dstfs.listStatus(status.getPath())) {
                    String relative = DistCp.makeRelative(dstroot.getPath(), child.getPath());
                    writer.append((Writable)new Text(relative), (Writable)child);
                    lsrstack.push(child);
                }
            }
        }
        finally {
            DistCp.checkAndClose((Closeable)writer);
        }
        Path sortedlsr = new Path(jobdir, "_distcp_dst_lsr_sorted");
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(jobfs, (RawComparator)new Text.Comparator(), Text.class, FileStatus.class, (Configuration)jobconf);
        sorter.sort(dstlsr, sortedlsr);
        SequenceFile.Reader lsrin = null;
        SequenceFile.Reader dstin = null;
        try {
            lsrin = new SequenceFile.Reader(jobfs, sortedlsr, (Configuration)jobconf);
            dstin = new SequenceFile.Reader(jobfs, dstsorted, (Configuration)jobconf);
            Text lsrpath = new Text();
            FileStatus lsrstatus = new FileStatus();
            Text dstpath = new Text();
            Text dstfrom = new Text();
            FsShell shell = new FsShell(conf);
            String[] shellargs = new String[]{"-rmr", null};
            boolean hasnext = dstin.next((Writable)dstpath, (Writable)dstfrom);
            while (lsrin.next((Writable)lsrpath, (Writable)lsrstatus)) {
                int dst_cmp_lsr = dstpath.compareTo((BinaryComparable)lsrpath);
                while (hasnext && dst_cmp_lsr < 0) {
                    hasnext = dstin.next((Writable)dstpath, (Writable)dstfrom);
                    dst_cmp_lsr = dstpath.compareTo((BinaryComparable)lsrpath);
                }
                if (dst_cmp_lsr == 0) {
                    hasnext = dstin.next((Writable)dstpath, (Writable)dstfrom);
                    continue;
                }
                String s = new Path(dstroot.getPath(), lsrpath.toString()).toString();
                if (shellargs[1] != null && DistCp.isAncestorPath(shellargs[1], s)) continue;
                shellargs[1] = s;
                int r = 0;
                try {
                    r = shell.run(shellargs);
                }
                catch (Exception e) {
                    throw new IOException("Exception from shell.", e);
                }
                if (r == 0) continue;
                throw new IOException("\"" + shellargs[0] + " " + shellargs[1] + "\" returns non-zero value " + r);
            }
        }
        catch (Throwable throwable) {
            DistCp.checkAndClose(lsrin);
            DistCp.checkAndClose(dstin);
            throw throwable;
        }
        DistCp.checkAndClose((Closeable)lsrin);
        DistCp.checkAndClose((Closeable)dstin);
    }

    private static boolean isAncestorPath(String x, String y) {
        if (!y.startsWith(x)) {
            return false;
        }
        int len = x.length();
        return y.length() == len || y.charAt(len) == '/';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkDuplication(FileSystem fs, Path file, Path sorted, Configuration conf) throws IOException {
        SequenceFile.Reader in = null;
        try {
            SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, (RawComparator)new Text.Comparator(), Text.class, Text.class, conf);
            sorter.sort(file, sorted);
            in = new SequenceFile.Reader(fs, sorted, conf);
            Text prevdst = null;
            Text curdst = new Text();
            Text prevsrc = null;
            Text cursrc = new Text();
            while (in.next((Writable)curdst, (Writable)cursrc)) {
                if (prevdst != null && curdst.equals((Object)prevdst)) {
                    throw new DuplicationException("Invalid input, there are duplicated files in the sources: " + prevsrc + ", " + cursrc);
                }
                prevdst = curdst;
                curdst = new Text();
                prevsrc = cursrc;
                cursrc = new Text();
            }
        }
        catch (Throwable throwable) {
            DistCp.checkAndClose(in);
            throw throwable;
        }
        DistCp.checkAndClose((Closeable)in);
    }

    static boolean checkAndClose(Closeable io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)StringUtils.stringifyException((Throwable)ioe));
                return false;
            }
        }
        return true;
    }

    public static class DuplicationException
    extends IOException {
        private static final long serialVersionUID = 1L;
        public static final int ERROR_CODE = -2;

        DuplicationException(String message) {
            super(message);
        }
    }

    private static class Arguments {
        final List<Path> srcs;
        final Path dst;
        final Path log;
        final EnumSet<Options> flags;
        final String preservedAttributes;
        final long filelimit;
        final long sizelimit;
        final long filesizemin;
        final long filesizemax;
        final String mapredSslConf;

        Arguments(List<Path> srcs, Path dst, Path log, EnumSet<Options> flags, String preservedAttributes, long filelimit, long sizelimit, long filesizemin, long filesizemax, String mapredSslConf) {
            this.srcs = srcs;
            this.dst = dst;
            this.log = log;
            this.flags = flags;
            this.preservedAttributes = preservedAttributes;
            this.filelimit = filelimit;
            this.sizelimit = sizelimit;
            this.filesizemin = filesizemin;
            this.filesizemax = filesizemax;
            this.mapredSslConf = mapredSslConf;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("this = " + this));
            }
        }

        static Arguments valueOf(String[] args, Configuration conf) throws IOException {
            ArrayList<Path> srcs = new ArrayList<Path>();
            Path dst = null;
            Path log = null;
            EnumSet<Options> flags = EnumSet.noneOf(Options.class);
            String presevedAttributes = null;
            String mapredSslConf = null;
            long filelimit = Long.MAX_VALUE;
            long sizelimit = Long.MAX_VALUE;
            long filesizemin = 0L;
            long filesizemax = Long.MAX_VALUE;
            for (int idx = 0; idx < args.length; ++idx) {
                int i;
                Options[] opt = Options.values();
                for (i = 0; i < opt.length && !args[idx].startsWith(opt[i].cmd); ++i) {
                }
                if (i < opt.length) {
                    flags.add(opt[i]);
                    if (opt[i] == Options.PRESERVE_STATUS) {
                        presevedAttributes = args[idx].substring(2);
                        FileAttribute.parse(presevedAttributes);
                        continue;
                    }
                    if (opt[i] == Options.FILE_LIMIT) {
                        filelimit = Options.FILE_LIMIT.parseLong(args, ++idx);
                        continue;
                    }
                    if (opt[i] == Options.SIZE_LIMIT) {
                        sizelimit = Options.SIZE_LIMIT.parseLong(args, ++idx);
                        continue;
                    }
                    if (opt[i] == Options.FILE_SIZE_MIN) {
                        filesizemin = Options.FILE_SIZE_MIN.parseLong(args, ++idx);
                        continue;
                    }
                    if (opt[i] != Options.FILE_SIZE_MAX) continue;
                    filesizemax = Options.FILE_SIZE_MAX.parseLong(args, ++idx);
                    continue;
                }
                if ("-f".equals(args[idx])) {
                    if (++idx == args.length) {
                        throw new IllegalArgumentException("urilist_uri not specified in -f");
                    }
                    srcs.addAll(DistCp.fetchFileList(conf, new Path(args[idx])));
                    continue;
                }
                if ("-log".equals(args[idx])) {
                    if (++idx == args.length) {
                        throw new IllegalArgumentException("logdir not specified in -log");
                    }
                    log = new Path(args[idx]);
                    continue;
                }
                if ("-mapredSslConf".equals(args[idx])) {
                    if (++idx == args.length) {
                        throw new IllegalArgumentException("ssl conf file not specified in -mapredSslConf");
                    }
                    mapredSslConf = args[idx];
                    continue;
                }
                if ("-m".equals(args[idx])) {
                    if (++idx == args.length) {
                        throw new IllegalArgumentException("num_maps not specified in -m");
                    }
                    try {
                        conf.setInt(DistCp.MAX_MAPS_LABEL, Integer.valueOf(args[idx]).intValue());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid argument to -m: " + args[idx]);
                    }
                }
                if (45 == args[idx].codePointAt(0)) {
                    throw new IllegalArgumentException("Invalid switch " + args[idx]);
                }
                if (idx == args.length - 1) {
                    dst = new Path(args[idx]);
                    continue;
                }
                srcs.add(new Path(args[idx]));
            }
            if (srcs.isEmpty() || dst == null) {
                throw new IllegalArgumentException("Missing " + (dst == null ? "dst path" : "src"));
            }
            boolean isOverwrite = flags.contains((Object)Options.OVERWRITE);
            boolean isUpdate = flags.contains((Object)Options.UPDATE);
            boolean isDelete = flags.contains((Object)Options.DELETE);
            boolean skipCRC = flags.contains((Object)Options.SKIPCRC);
            if (filesizemin > filesizemax) {
                throw new IllegalArgumentException(Options.FILE_SIZE_MAX.cmd + " must be greater than or equal to " + Options.FILE_SIZE_MIN.cmd + ".");
            }
            if (isOverwrite && isUpdate) {
                throw new IllegalArgumentException("Conflicting overwrite policies");
            }
            if (isDelete && !isOverwrite && !isUpdate) {
                throw new IllegalArgumentException(Options.DELETE.cmd + " must be specified with " + (Object)((Object)Options.OVERWRITE) + " or " + (Object)((Object)Options.UPDATE) + ".");
            }
            if (!isUpdate && skipCRC) {
                throw new IllegalArgumentException(Options.SKIPCRC.cmd + " is relevant only with the " + Options.UPDATE.cmd + " option");
            }
            return new Arguments(srcs, dst, log, flags, presevedAttributes, filelimit, sizelimit, filesizemin, filesizemax, mapredSslConf);
        }

        public String toString() {
            return this.getClass().getName() + "{" + "\n  srcs = " + this.srcs + "\n  dst = " + this.dst + "\n  log = " + this.log + "\n  flags = " + this.flags + "\n  preservedAttributes = " + this.preservedAttributes + "\n  filelimit = " + this.filelimit + "\n  sizelimit = " + this.sizelimit + "\n  filesizemin = " + this.filesizemin + "\n  filesizemax = " + this.filesizemax + "\n  mapredSslConf = " + this.mapredSslConf + "\n}";
        }
    }

    static class CopyFilesMapper
    implements Mapper<LongWritable, FilePair, WritableComparable<?>, Text> {
        private int sizeBuf = 131072;
        private FileSystem destFileSys = null;
        private boolean ignoreReadFailures;
        private boolean preserve_status;
        private EnumSet<FileAttribute> preseved;
        private boolean overwrite;
        private boolean update;
        private Path destPath = null;
        private byte[] buffer = null;
        private JobConf job;
        private boolean skipCRCCheck = false;
        private int failcount = 0;
        private int skipcount = 0;
        private int copycount = 0;

        CopyFilesMapper() {
        }

        private String getCountString() {
            return "Copied: " + this.copycount + " Skipped: " + this.skipcount + " Failed: " + this.failcount;
        }

        private void updateStatus(Reporter reporter) {
            reporter.setStatus(this.getCountString());
        }

        private boolean needsUpdate(FileStatus srcstatus, FileSystem dstfs, Path dstpath) throws IOException {
            return this.update && !DistCp.sameFile(srcstatus.getPath().getFileSystem((Configuration)this.job), srcstatus, dstfs, dstpath, this.skipCRCCheck);
        }

        private FSDataOutputStream create(Path f, Reporter reporter, FileStatus srcstat) throws IOException {
            if (this.destFileSys.exists(f)) {
                this.destFileSys.delete(f, false);
            }
            if (!this.preserve_status) {
                return this.destFileSys.create(f, true, this.sizeBuf, (Progressable)reporter);
            }
            FsPermission permission = this.preseved.contains((Object)FileAttribute.PERMISSION) ? srcstat.getPermission() : null;
            short replication = this.preseved.contains((Object)FileAttribute.REPLICATION) ? srcstat.getReplication() : this.destFileSys.getDefaultReplication();
            long blockSize = this.preseved.contains((Object)FileAttribute.BLOCK_SIZE) ? srcstat.getBlockSize() : this.destFileSys.getDefaultBlockSize();
            return this.destFileSys.create(f, permission, true, this.sizeBuf, replication, blockSize, (Progressable)reporter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(FileStatus srcstat, Path relativedst, OutputCollector<WritableComparable<?>, Text> outc, Reporter reporter) throws IOException {
            Path dstparent;
            Path absdst = new Path(this.destPath, relativedst);
            int totfiles = this.job.getInt(DistCp.SRC_COUNT_LABEL, -1);
            assert (totfiles >= 0) : "Invalid file count " + totfiles;
            if (srcstat.isDir()) {
                if (this.destFileSys.exists(absdst)) {
                    if (!this.destFileSys.getFileStatus(absdst).isDir()) {
                        throw new IOException("Failed to mkdirs: " + absdst + " is a file.");
                    }
                } else if (!this.destFileSys.mkdirs(absdst)) {
                    throw new IOException("Failed to mkdirs " + absdst);
                }
                return;
            }
            if (this.destFileSys.exists(absdst) && !this.overwrite && !this.needsUpdate(srcstat, this.destFileSys, absdst)) {
                outc.collect(null, (Object)new Text("SKIP: " + srcstat.getPath()));
                ++this.skipcount;
                reporter.incrCounter((Enum)Counter.SKIP, 1L);
                this.updateStatus(reporter);
                return;
            }
            Path tmpfile = new Path(this.job.get(DistCp.TMP_DIR_LABEL), relativedst);
            long cbcopied = 0L;
            FSDataInputStream in = null;
            FSDataOutputStream out = null;
            try {
                int cbread;
                try {
                    in = srcstat.getPath().getFileSystem((Configuration)this.job).open(srcstat.getPath());
                }
                catch (NullPointerException e) {
                    LOG.error((Object)("Hit NPE for: " + srcstat.getPath()));
                    throw e;
                }
                reporter.incrCounter((Enum)Counter.BYTESEXPECTED, srcstat.getLen());
                out = this.create(tmpfile, reporter, srcstat);
                while ((cbread = in.read(this.buffer)) >= 0) {
                    out.write(this.buffer, 0, cbread);
                    reporter.setStatus(String.format("%.2f ", (double)(cbcopied += (long)cbread) * 100.0 / (double)srcstat.getLen()) + absdst + " [ " + StringUtils.humanReadableInt((long)cbcopied) + " / " + StringUtils.humanReadableInt((long)srcstat.getLen()) + " ]");
                }
            }
            catch (Throwable throwable) {
                block25: {
                    try {
                        if (in != null) {
                            in.adviseFile(FSDataInputStream.FadviseType.FILE_DONTNEED, 0L, cbcopied);
                        }
                    }
                    catch (IOException ioe) {
                        if (!LOG.isInfoEnabled()) break block25;
                        LOG.info((Object)("Error " + ioe + " in fadvise. Ignoring it."));
                    }
                }
                DistCp.checkAndClose(in);
                DistCp.checkAndClose(out);
                throw throwable;
            }
            try {
                if (in != null) {
                    in.adviseFile(FSDataInputStream.FadviseType.FILE_DONTNEED, 0L, cbcopied);
                }
            }
            catch (IOException ioe) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Error " + ioe + " in fadvise. Ignoring it."));
                }
            }
            DistCp.checkAndClose((Closeable)in);
            DistCp.checkAndClose((Closeable)out);
            if (cbcopied != srcstat.getLen()) {
                throw new IOException("File size not matched: copied " + CopyFilesMapper.bytesString(cbcopied) + " to tmpfile (=" + tmpfile + ") but expected " + CopyFilesMapper.bytesString(srcstat.getLen()) + " from " + srcstat.getPath());
            }
            if (!(totfiles != 1 || this.destFileSys.exists(dstparent = absdst.getParent()) && this.destFileSys.getFileStatus(dstparent).isDir())) {
                absdst = dstparent;
            }
            if (this.destFileSys.exists(absdst) && this.destFileSys.getFileStatus(absdst).isDir()) {
                throw new IOException(absdst + " is a directory");
            }
            if (!this.destFileSys.mkdirs(absdst.getParent())) {
                throw new IOException("Failed to create parent dir: " + absdst.getParent());
            }
            this.rename(tmpfile, absdst);
            FileStatus dststat = this.destFileSys.getFileStatus(absdst);
            if (dststat.getLen() != srcstat.getLen()) {
                this.destFileSys.delete(absdst, false);
                throw new IOException("File size not matched: copied " + CopyFilesMapper.bytesString(dststat.getLen()) + " to dst (=" + absdst + ") but expected " + CopyFilesMapper.bytesString(srcstat.getLen()) + " from " + srcstat.getPath());
            }
            this.updatePermissions(srcstat, dststat);
            ++this.copycount;
            reporter.incrCounter((Enum)Counter.BYTESCOPIED, cbcopied);
            reporter.incrCounter((Enum)Counter.COPY, 1L);
            this.updateStatus(reporter);
        }

        private void rename(Path tmp, Path dst) throws IOException {
            try {
                if (this.destFileSys.exists(dst)) {
                    this.destFileSys.delete(dst, true);
                }
                if (!this.destFileSys.rename(tmp, dst)) {
                    throw new IOException();
                }
            }
            catch (IOException cause) {
                throw (IOException)new IOException("Fail to rename tmp file (=" + tmp + ") to destination file (=" + dst + ")").initCause(cause);
            }
        }

        private void updatePermissions(FileStatus src, FileStatus dst) throws IOException {
            if (this.preserve_status) {
                DistCp.updatePermissions(src, dst, this.preseved, this.destFileSys);
            }
        }

        static String bytesString(long b) {
            return b + " bytes (" + StringUtils.humanReadableInt((long)b) + ")";
        }

        public void configure(JobConf job) {
            this.destPath = new Path(job.get(DistCp.DST_DIR_LABEL, "/"));
            try {
                this.destFileSys = this.destPath.getFileSystem((Configuration)job);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to get the named file system.", ex);
            }
            this.sizeBuf = job.getInt("copy.buf.size", 131072);
            this.buffer = new byte[this.sizeBuf];
            this.ignoreReadFailures = job.getBoolean(Options.IGNORE_READ_FAILURES.propertyname, false);
            this.preserve_status = job.getBoolean(Options.PRESERVE_STATUS.propertyname, false);
            if (this.preserve_status) {
                this.preseved = FileAttribute.parse(job.get(PRESERVE_STATUS_LABEL));
            }
            this.update = job.getBoolean(Options.UPDATE.propertyname, false);
            this.overwrite = !this.update && job.getBoolean(Options.OVERWRITE.propertyname, false);
            this.skipCRCCheck = job.getBoolean(Options.SKIPCRC.propertyname, false);
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(LongWritable key, FilePair value, OutputCollector<WritableComparable<?>, Text> out, Reporter reporter) throws IOException {
            FileStatus srcstat = value.input;
            Path relativedst = new Path(value.output);
            try {
                this.copy(srcstat, relativedst, out, reporter);
            }
            catch (IOException e) {
                ++this.failcount;
                reporter.incrCounter((Enum)Counter.FAIL, 1L);
                this.updateStatus(reporter);
                String sfailure = "FAIL " + relativedst + " : " + StringUtils.stringifyException((Throwable)e);
                out.collect(null, (Object)new Text(sfailure));
                LOG.info((Object)sfailure);
                try {
                    for (int i = 0; i < 3; ++i) {
                        block11: {
                            try {
                                Path tmp = new Path(this.job.get(DistCp.TMP_DIR_LABEL), relativedst);
                                if (!this.destFileSys.delete(tmp, true)) break block11;
                                break;
                            }
                            catch (Throwable ex) {
                                LOG.debug((Object)"Ignoring cleanup exception", ex);
                            }
                        }
                        this.updateStatus(reporter);
                        Thread.sleep(3000L);
                    }
                }
                catch (InterruptedException inte) {
                    throw (IOException)new IOException().initCause(inte);
                }
            }
            finally {
                this.updateStatus(reporter);
            }
        }

        public void close() throws IOException {
            if (0 == this.failcount || this.ignoreReadFailures) {
                return;
            }
            throw new IOException(this.getCountString());
        }
    }

    static class CopyInputFormat
    implements InputFormat<Text, Text> {
        CopyInputFormat() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            int cnfiles = job.getInt(DistCp.SRC_COUNT_LABEL, -1);
            long cbsize = job.getLong(DistCp.TOTAL_SIZE_LABEL, -1L);
            String srcfilelist = job.get(DistCp.SRC_LIST_LABEL, "");
            if (cnfiles < 0 || cbsize < 0L || "".equals(srcfilelist)) {
                throw new RuntimeException("Invalid metadata: #files(" + cnfiles + ") total_size(" + cbsize + ") listuri(" + srcfilelist + ")");
            }
            Path src = new Path(srcfilelist);
            FileSystem fs = src.getFileSystem((Configuration)job);
            FileStatus srcst = fs.getFileStatus(src);
            ArrayList<FileSplit> splits = new ArrayList<FileSplit>(numSplits);
            LongWritable key = new LongWritable();
            FilePair value = new FilePair();
            long targetsize = cbsize / (long)numSplits;
            long pos = 0L;
            long last = 0L;
            long acc = 0L;
            long cbrem = srcst.getLen();
            SequenceFile.Reader sl = null;
            try {
                sl = new SequenceFile.Reader(fs, src, (Configuration)job);
                while (sl.next((Writable)key, (Writable)value)) {
                    if (acc + key.get() > targetsize && acc != 0L) {
                        long splitsize = last - pos;
                        splits.add(new FileSplit(src, pos, splitsize, (String[])null));
                        cbrem -= splitsize;
                        pos = last;
                        acc = 0L;
                    }
                    acc += key.get();
                    last = sl.getPosition();
                }
            }
            catch (Throwable throwable) {
                DistCp.checkAndClose(sl);
                throw throwable;
            }
            DistCp.checkAndClose((Closeable)sl);
            if (cbrem != 0L) {
                splits.add(new FileSplit(src, pos, cbrem, (String[])null));
            }
            return (InputSplit[])splits.toArray(new FileSplit[splits.size()]);
        }

        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new SequenceFileRecordReader((Configuration)job, (FileSplit)split);
        }
    }

    static class FilePair
    implements Writable {
        FileStatus input = new FileStatus();
        String output;

        FilePair() {
        }

        FilePair(FileStatus input, String output) {
            this.input = input;
            this.output = output;
        }

        public void readFields(DataInput in) throws IOException {
            this.input.readFields(in);
            this.output = Text.readString((DataInput)in);
        }

        public void write(DataOutput out) throws IOException {
            this.input.write(out);
            Text.writeString((DataOutput)out, (String)this.output);
        }

        public String toString() {
            return this.input + " : " + this.output;
        }
    }

    static enum FileAttribute {
        BLOCK_SIZE,
        REPLICATION,
        USER,
        GROUP,
        PERMISSION;

        final char symbol = this.toString().toLowerCase().charAt(0);

        static EnumSet<FileAttribute> parse(String s) {
            if (s == null || s.length() == 0) {
                return EnumSet.allOf(FileAttribute.class);
            }
            EnumSet<FileAttribute> set = EnumSet.noneOf(FileAttribute.class);
            FileAttribute[] attributes = FileAttribute.values();
            for (char c : s.toCharArray()) {
                int i;
                for (i = 0; i < attributes.length && c != attributes[i].symbol; ++i) {
                }
                if (i < attributes.length) {
                    if (set.contains((Object)attributes[i])) {
                        throw new IllegalArgumentException("There are more than one '" + attributes[i].symbol + "' in " + s);
                    }
                } else {
                    throw new IllegalArgumentException("'" + c + "' in " + s + " is undefined.");
                }
                set.add(attributes[i]);
            }
            return set;
        }
    }

    static enum Options {
        DELETE("-delete", "distcp.delete"),
        FILE_LIMIT("-filelimit", "distcp.limit.file"),
        SIZE_LIMIT("-sizelimit", "distcp.limit.size"),
        IGNORE_READ_FAILURES("-i", "distcp.ignore.read.failures"),
        PRESERVE_STATUS("-p", "distcp.preserve.status"),
        OVERWRITE("-overwrite", "distcp.overwrite.always"),
        UPDATE("-update", "distcp.overwrite.ifnewer"),
        SKIPCRC("-skipcrccheck", "distcp.skip.crc.check"),
        FILE_SIZE_MIN("-filesizemin", "distcp.file.size.min"),
        FILE_SIZE_MAX("-filesizemax", "distcp.file.size.max");

        final String cmd;
        final String propertyname;

        private Options(String cmd, String propertyname) {
            this.cmd = cmd;
            this.propertyname = propertyname;
        }

        private long parseLong(String[] args, int offset) {
            if (offset == args.length) {
                throw new IllegalArgumentException("<n> not specified in " + this.cmd);
            }
            long n = StringUtils.TraditionalBinaryPrefix.string2long((String)args[offset]);
            if (n <= 0L) {
                throw new IllegalArgumentException("n = " + n + " <= 0 in " + this.cmd);
            }
            return n;
        }
    }

    static enum Counter {
        COPY,
        SKIP,
        FAIL,
        BYTESCOPIED,
        BYTESEXPECTED;

    }
}

