/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestJobHistory;
import org.apache.hadoop.mapred.UtilsForTests;
import org.junit.Ignore;

@Ignore
public class TestJobTrackerRestartWithLostTracker
extends TestCase {
    final Path testDir = new Path("/jt-restart-lost-tt-testing");
    final Path inDir = new Path(this.testDir, "input");
    final Path shareDir = new Path(this.testDir, "share");
    final Path outputDir = new Path(this.testDir, "output");

    private JobConf configureJob(JobConf conf, int maps, int reduces, String mapSignal, String redSignal) throws IOException {
        UtilsForTests.configureWaitingJobConf(conf, this.inDir, this.outputDir, maps, reduces, "test-jobtracker-restart-with-lost-tt", mapSignal, redSignal);
        return conf;
    }

    public void testRecoveryWithLostTracker(MiniDFSCluster dfs, MiniMRCluster mr) throws IOException {
        DistributedFileSystem fileSys = dfs.getFileSystem();
        JobConf jobConf = mr.createJobConf();
        int numMaps = 50;
        int numReds = 1;
        String mapSignalFile = UtilsForTests.getMapSignalFile(this.shareDir);
        String redSignalFile = UtilsForTests.getReduceSignalFile(this.shareDir);
        JobConf job = this.configureJob(jobConf, numMaps, numReds, mapSignalFile, redSignalFile);
        fileSys.delete(this.shareDir, true);
        JobClient jobClient = new JobClient(job);
        RunningJob rJob = jobClient.submitJob(job);
        JobID id = rJob.getID();
        mr.initializeJob(id);
        while (UtilsForTests.getJobStatus(jobClient, id).mapProgress() < 0.5f) {
            UtilsForTests.waitFor(100L);
        }
        mr.stopJobTracker();
        UtilsForTests.signalTasks(dfs, (FileSystem)fileSys, true, mapSignalFile, redSignalFile);
        mr.getJobTrackerConf().setBoolean("mapred.jobtracker.restart.recover", true);
        mr.stopTaskTracker(1);
        UtilsForTests.waitFor(60000L);
        mr.startJobTracker();
        UtilsForTests.waitForJobTracker(jobClient);
        UtilsForTests.signalTasks(dfs, (FileSystem)fileSys, false, mapSignalFile, redSignalFile);
        UtilsForTests.waitTillDone(jobClient);
        TestJobTrackerRestartWithLostTracker.assertEquals((String)"Tracker killed while the jobtracker was down did not get lost upon restart", (int)jobClient.getClusterStatus().getTaskTrackers(), (int)1);
        TestJobHistory.validateJobHistoryFileFormat(id, job, "SUCCESS", true);
        TestJobHistory.validateJobHistoryFileContent(mr, rJob, job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestartWithLostTracker() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, null, null);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            fileSys.delete(this.testDir, true);
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file"), (short)1);
            dfs.startDataNodes(conf, 1, true, null, null, null, null);
            dfs.waitActive();
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            JobConf jtConf = new JobConf();
            jtConf.set("mapred.jobtracker.job.history.block.size", "1024");
            jtConf.set("mapred.jobtracker.job.history.buffer.size", "1024");
            jtConf.setInt("mapred.tasktracker.reduce.tasks.maximum", 1);
            jtConf.setLong("mapred.tasktracker.expiry.interval", 25000L);
            jtConf.setInt("mapred.reduce.copy.backoff", 4);
            mr = new MiniMRCluster(2, namenode, 1, null, null, jtConf);
            this.testRecoveryWithLostTracker(dfs, mr);
        }
        finally {
            if (mr != null) {
                try {
                    mr.shutdown();
                }
                catch (Exception e) {}
            }
            if (dfs != null) {
                try {
                    dfs.shutdown();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void main(String[] args) throws IOException {
        new TestJobTrackerRestartWithLostTracker().testRestartWithLostTracker();
    }
}

