/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.RandomWriter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestCompressedEmptyMapOutputs
extends TestCase {
    private static final Path SORT_INPUT_PATH = new Path("/sort/input");
    private static final Path SORT_OUTPUT_PATH = new Path("/sort/output");
    private static final int NUM_HADOOP_SLAVES = 3;
    private static final int RW_BYTES_PER_MAP = 50000;
    private static final int RW_MAPS_PER_HOST = 5;

    private static void runRandomWriter(JobConf job, Path sortInput) throws Exception {
        job.setInt("test.randomwrite.bytes_per_map", 50000);
        job.setInt("test.randomwriter.maps_per_host", 5);
        String[] rwArgs = new String[]{sortInput.toString()};
        TestCompressedEmptyMapOutputs.assertEquals((int)ToolRunner.run((Configuration)job, (Tool)new RandomWriter(), (String[])rwArgs), (int)0);
    }

    private static void runSort(JobConf jobConf, Path sortInput, Path sortOutput) throws Exception {
        jobConf.setJobName("null-sorter");
        jobConf.setMapperClass(SinkMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setNumReduceTasks(2);
        jobConf.setInputFormat(SequenceFileInputFormat.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        jobConf.setOutputKeyClass(BytesWritable.class);
        jobConf.setOutputValueClass(BytesWritable.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{sortInput});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)sortOutput);
        jobConf.setCompressMapOutput(true);
        JobClient.runJob((JobConf)jobConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapReduceSortWithCompressedEmptyMapOutputs() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 3, true, null);
            fileSys = dfs.getFileSystem();
            mr = new MiniMRCluster(3, fileSys.getUri().toString(), 1);
            TestCompressedEmptyMapOutputs.runRandomWriter(mr.createJobConf(), SORT_INPUT_PATH);
            TestCompressedEmptyMapOutputs.runSort(mr.createJobConf(), SORT_INPUT_PATH, SORT_OUTPUT_PATH);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static class SinkMapper<K, V>
    extends MapReduceBase
    implements Mapper<K, V, K, V> {
        SinkMapper() {
        }

        public void map(K key, V val, OutputCollector<K, V> output, Reporter reporter) throws IOException {
        }
    }
}

