/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class TestCombineFileInputFormat
extends TestCase {
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};
    private static final String[] rack2 = new String[]{"/r2"};
    private static final String[] hosts2 = new String[]{"host2.rack2.com"};
    private static final String[] rack3 = new String[]{"/r3"};
    private static final String[] hosts3 = new String[]{"host3.rack3.com"};
    final Path inDir = new Path("/racktesting");
    final Path outputPath = new Path("/output");
    final Path dir1 = new Path(this.inDir, "/dir1");
    final Path dir2 = new Path(this.inDir, "/dir2");
    final Path dir3 = new Path(this.inDir, "/dir3");
    final Path dir4 = new Path(this.inDir, "/dir4");
    static final int BLOCKSIZE = 1024;
    static final byte[] databuf = new byte[1024];
    private static final Log LOG = LogFactory.getLog(TestCombineFileInputFormat.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitPlacement() throws IOException {
        String namenode = null;
        MiniHDFSCluster dfs = null;
        Object mr = null;
        DistributedFileSystem fileSys = null;
        String testName = "TestSplitPlacement";
        try {
            int i;
            JobConf conf = new JobConf();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniHDFSCluster((Configuration)conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile((Configuration)conf, file1, (short)1, 1);
            dfs.startDataNodes((Configuration)conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2");
            TestCombineFileInputFormat.writeFile((Configuration)conf, file2, (short)2, 2);
            DummyInputFormat inFormat = new DummyInputFormat();
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(1024L);
            InputSplit[] splits = inFormat.getSplits(conf, 1);
            System.out.println("Made splits(Test1): " + splits.length);
            CombineFileSplit fileSplit = null;
            for (int i2 = 0; i2 < splits.length; ++i2) {
                fileSplit = (CombineFileSplit)splits[i2];
                System.out.println("File split(Test1): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)2);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            dfs.startDataNodes((Configuration)conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3");
            TestCombineFileInputFormat.writeFile((Configuration)conf, new Path(this.dir3 + "/file3"), (short)3, 3);
            inFormat = new DummyInputFormat();
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits(conf, 1);
            for (int i3 = 0; i3 < splits.length; ++i3) {
                fileSplit = (CombineFileSplit)splits[i3];
                System.out.println("File split(Test2): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)3);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            Path file4 = new Path(this.dir4 + "/file4");
            TestCombineFileInputFormat.writeFile((Configuration)conf, file4, (short)3, 3);
            inFormat = new DummyInputFormat();
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test3): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)3);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(2048L);
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test4): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)5);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            inFormat = new DummyInputFormat();
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(3072L);
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test5): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)4);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host2.rack2.com");
            fileSplit = (CombineFileSplit)splits[3];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host1.rack1.com");
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(4096L);
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test6): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)3);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)4);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file3.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)4);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(1).getName(), (String)file2.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(1), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(2).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(2), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(3).getName(), (String)file4.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(3), (long)2048L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(3), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host2.rack2.com");
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getPath(0).getName(), (String)file1.getName());
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getOffset(0), (long)0L);
            TestCombineFileInputFormat.assertEquals((long)fileSplit.getLength(0), (long)1024L);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            inFormat = new DummyInputFormat();
            inFormat.setMaxSplitSize(7168L);
            inFormat.setMinSplitSizeNode(3072L);
            inFormat.setMinSplitSizeRack(3072L);
            DummyInputFormat.setInputPaths((JobConf)conf, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(Test7): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)2);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host3.rack3.com");
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)3);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)"host1.rack1.com");
            file1 = new Path(conf.getWorkingDirectory(), file1);
            file2 = new Path(conf.getWorkingDirectory(), file2);
            file3 = new Path(conf.getWorkingDirectory(), file3);
            file4 = new Path(conf.getWorkingDirectory(), file4);
            inFormat = new DummyInputFormat();
            DummyInputFormat.addInputPath((JobConf)conf, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(conf, new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits(conf, 1);
            for (i = 0; i < splits.length; ++i) {
                fileSplit = (CombineFileSplit)splits[i];
                System.out.println("File split(TestPool1): " + fileSplit);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.length, (int)3);
            fileSplit = (CombineFileSplit)splits[0];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)2);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts2[0]);
            fileSplit = (CombineFileSplit)splits[1];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)1);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts1[0]);
            fileSplit = (CombineFileSplit)splits[2];
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getNumPaths(), (int)6);
            TestCombineFileInputFormat.assertEquals((int)fileSplit.getLocations().length, (int)1);
            TestCombineFileInputFormat.assertEquals((String)fileSplit.getLocations()[0], (String)hosts3[0]);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static void writeFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L);
        for (int i = 0; i < numBlocks; ++i) {
            stm.write(databuf);
        }
        stm.close();
        try {
            DFSTestUtil.waitReplication((FileSystem)fileSys, (Path)name, (short)replication);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void splitRealFiles(String[] args) throws IOException {
        JobConf conf = new JobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IOException("Wrong file system: " + fs.getClass().getName());
        }
        int blockSize = conf.getInt("dfs.block.size", 0x8000000);
        DummyInputFormat inFormat = new DummyInputFormat();
        for (int i = 0; i < args.length; ++i) {
            DummyInputFormat.addInputPaths((JobConf)conf, (String)args[i]);
        }
        inFormat.setMinSplitSizeRack(blockSize);
        inFormat.setMaxSplitSize(10 * blockSize);
        InputSplit[] splits = inFormat.getSplits(conf, 1);
        System.out.println("Total number of splits " + splits.length);
        for (int i = 0; i < splits.length; ++i) {
            CombineFileSplit fileSplit = (CombineFileSplit)splits[i];
            System.out.println("Split[" + i + "] " + fileSplit);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.splitRealFiles(args);
        } else {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.testSplitPlacement();
        }
    }

    static class TestFilter
    implements PathFilter {
        private Path p;

        public TestFilter(Path p) {
            this.p = p;
        }

        public boolean accept(Path path) {
            return path.toString().indexOf(this.p.toString()) == 0;
        }

        public String toString() {
            return "PathFilter:" + this.p;
        }
    }

    private class DummyInputFormat
    extends CombineFileInputFormat<Text, Text> {
        private DummyInputFormat() {
        }

        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return null;
        }
    }
}

