/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.TestMiniMRMapRedDebugScript;
import org.apache.hadoop.mapred.TestWebUIAuthorization;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestTaskTrackerLogIndex
extends TestCase {
    private static String taskLog = "Task attempt log";
    private static String INDEX_FILENAME_DIRS = "test.tracker.log.index.directory";
    static String cleanupLog = "cleanup attempt log";
    private static Pattern ATTEMPT_ID_PATTERN = Pattern.compile(".+_([0-9a-z]+)_([0-9]+)_([a-z]+)_([0-9]+)_([0-9]+)$");

    public RunningJob launchJob(JobConf conf, Path inDir, Path outDir, Path indexDir, String input) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setMapperClass(MapperClass.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.set(INDEX_FILENAME_DIRS, indexDir.toString());
        conf.setSpeculativeExecution(false);
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
        return new JobClient(conf).submitJob(conf);
    }

    private void validateAttempt(TaskInProgress tip, TaskAttemptID attemptId, TaskStatus ts, boolean isCleanup, JobTracker jt) throws IOException {
        TestTaskTrackerLogIndex.assertEquals((boolean)isCleanup, (boolean)tip.isCleanupAttempt(attemptId));
        TestTaskTrackerLogIndex.assertTrue((ts != null ? 1 : 0) != 0);
        TestTaskTrackerLogIndex.assertEquals((Object)TaskStatus.State.FAILED, (Object)ts.getRunState());
        String log = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.STDERR, attemptId, false);
        TestTaskTrackerLogIndex.assertTrue((boolean)log.contains(taskLog));
        TaskTrackerStatus ttStatus = jt.getTaskTracker(tip.machineWhereTaskRan(attemptId)).getStatus();
        String tasklogUrl = TaskLogServlet.getTaskLogUrl((String)"localhost", (String)String.valueOf(ttStatus.getHttpPort()), (String)attemptId.toString());
        TestTaskTrackerLogIndex.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(tasklogUrl, tip.getUser(), "GET"));
        if (!isCleanup) {
            TestTaskTrackerLogIndex.assertTrue((boolean)log.contains(cleanupLog));
        } else {
            log = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.STDERR, attemptId, true);
            TestTaskTrackerLogIndex.assertTrue((boolean)log.contains(cleanupLog));
            ttStatus = jt.getTaskTracker(tip.machineWhereCleanupRan(attemptId)).getStatus();
            String cleanupTasklogUrl = TaskLogServlet.getTaskLogUrl((String)"localhost", (String)String.valueOf(ttStatus.getHttpPort()), (String)attemptId.toString()) + "&cleanup=true";
            TestTaskTrackerLogIndex.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(cleanupTasklogUrl, tip.getUser(), "GET"));
        }
    }

    private void validateJob(RunningJob job, JobTracker jt) throws IOException {
        TestTaskTrackerLogIndex.assertEquals((int)2, (int)job.getJobState());
        JobID jobId = job.getID();
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, 0), 0);
        TaskInProgress tip = jt.getTip(attemptId.getTaskID());
        TaskStatus ts = jt.getTaskStatus(attemptId);
        this.validateAttempt(tip, attemptId, ts, false, jt);
        attemptId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, 0), 1);
        ts = jt.getTaskStatus(attemptId);
        this.validateAttempt(tip, attemptId, ts, true, jt);
        attemptId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, 0), 2);
        ts = jt.getTaskStatus(attemptId);
        this.validateAttempt(tip, attemptId, ts, true, jt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithDFS() throws IOException {
        MiniHDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            int taskTrackers = 4;
            Configuration conf = new Configuration();
            dfs = new MiniHDFSCluster(conf, 4, true, null);
            fileSys = dfs.getFileSystem();
            mr = new MiniMRCluster(4, fileSys.getUri().toString(), 1);
            JobTracker jt = mr.getJobTrackerRunner().getJobTracker();
            Path inDir = new Path("./input");
            Path outDir = new Path("./output");
            Path indexDir = new Path(fileSys.getHomeDirectory(), "index-names");
            String input = "The quick brown fox\nhas many silly\nred fox sox\n";
            fileSys.delete(indexDir, true);
            fileSys.delete(indexDir, true);
            JobConf jobConf = mr.createJobConf();
            jobConf.setOutputCommitter(CommitterWithLogs.class);
            jobConf.setNumTasksToExecutePerJvm(1);
            RunningJob rJob = this.launchJob(jobConf, inDir, outDir, indexDir, input);
            rJob.waitForCompletion();
            this.validateJob(rJob, jt);
            fileSys.delete(outDir, true);
            jobConf.setOutputCommitter(CommitterWithFailTaskCleanup.class);
            jobConf.setNumTasksToExecutePerJvm(2);
            rJob = this.launchJob(jobConf, inDir, outDir, indexDir, input);
            rJob.waitForCompletion();
            this.validateJob(rJob, jt);
            fileSys.delete(outDir, true);
            jobConf.setOutputCommitter(CommitterWithFailTaskCleanup2.class);
            jobConf.setNumTasksToExecutePerJvm(-1);
            rJob = this.launchJob(jobConf, inDir, outDir, indexDir, input);
            rJob.waitForCompletion();
            this.validateJob(rJob, jt);
            FileStatus[] statuses = fileSys.listStatus(indexDir);
            for (int i = 0; i < statuses.length; ++i) {
                String pathName = statuses[i].getPath().toString();
                Matcher matcher = ATTEMPT_ID_PATTERN.matcher(pathName);
                TestTaskTrackerLogIndex.assertTrue((String)("Syntactically invalid file name, " + pathName), (boolean)matcher.matches());
                int jobIndex = Integer.parseInt(matcher.group(2));
                TaskAttemptID attemptId = new TaskAttemptID(matcher.group(1), jobIndex, true, Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)));
                File indexFile = TaskLog.getIndexFile((TaskAttemptID)attemptId, (boolean)false);
                BufferedReader fis = null;
                try {
                    fis = new BufferedReader(new FileReader(indexFile));
                    String str = fis.readLine();
                    int count = 0;
                    while (str != null && count < 10) {
                        if (str.contains(TaskLog.LogName.STDERR.toString())) {
                            str = str.substring(TaskLog.LogName.STDERR.toString().length() + 1);
                            String[] startAndLen = str.split(" ");
                            long declaredLength = Long.parseLong(startAndLen[1]);
                            TestTaskTrackerLogIndex.assertTrue((String)"The first job has a non-default length", (jobIndex != 1 || declaredLength == -1L ? 1 : 0) != 0);
                            TestTaskTrackerLogIndex.assertTrue((String)"A subsequent job has a default length", (jobIndex == 1 || declaredLength > -1L ? 1 : 0) != 0);
                        }
                        str = fis.readLine();
                    }
                    continue;
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        TestTaskTrackerLogIndex td = new TestTaskTrackerLogIndex();
        td.testWithDFS();
    }

    static class CommitterWithFailTaskCleanup2
    extends FileOutputCommitter {
        CommitterWithFailTaskCleanup2() {
        }

        public void abortTask(TaskAttemptContext context) throws IOException {
            System.err.println(cleanupLog);
            throw new IOException();
        }
    }

    static class CommitterWithFailTaskCleanup
    extends FileOutputCommitter {
        CommitterWithFailTaskCleanup() {
        }

        public void abortTask(TaskAttemptContext context) throws IOException {
            System.err.println(cleanupLog);
            System.exit(-1);
        }
    }

    static class CommitterWithLogs
    extends FileOutputCommitter {
        CommitterWithLogs() {
        }

        public void abortTask(TaskAttemptContext context) throws IOException {
            System.err.println(cleanupLog);
            String attemptId = System.getProperty("hadoop.tasklog.taskid");
            Assert.assertNotNull((Object)attemptId);
            if (attemptId.endsWith("_0")) {
                Assert.assertFalse((boolean)Boolean.getBoolean(System.getProperty("hadoop.tasklog.iscleanup")));
            } else {
                Assert.assertTrue((boolean)Boolean.getBoolean(System.getProperty("hadoop.tasklog.iscleanup")));
            }
            super.abortTask(context);
        }
    }

    public static class MapperClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        String taskid;

        public void configure(JobConf job) {
            this.taskid = job.get("mapred.task.id");
            String indexDir = job.get(INDEX_FILENAME_DIRS);
            Path indexDirPath = new Path(indexDir);
            Path thisIndexPath = new Path(indexDirPath, this.taskid);
            try {
                FileSystem fs = indexDirPath.getFileSystem((Configuration)job);
                fs.create(thisIndexPath).close();
            }
            catch (IOException e) {
                throw new RuntimeException("TestTaskTrackerLogIndex.MapperClass.configure(...)", e);
            }
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            System.err.println(taskLog);
            Assert.assertFalse((boolean)Boolean.getBoolean(System.getProperty("hadoop.tasklog.iscleanup")));
            if (this.taskid.endsWith("_0")) {
                throw new IOException();
            }
            if (this.taskid.endsWith("_1")) {
                System.exit(-1);
            } else if (this.taskid.endsWith("_2")) {
                throw new Error();
            }
        }
    }
}

