/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestMiniMRClasspath;
import org.apache.hadoop.mapred.TestSubmitJob;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.security.UserGroupInformation;

public class TestMiniMRWithDFSWithDistinctUsers
extends TestCase {
    static final UserGroupInformation DFS_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("dfs", true);
    static final UserGroupInformation PI_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("pi", false);
    static final UserGroupInformation WC_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("wc", false);

    static UserGroupInformation createUGI(String name, boolean issuper) {
        String group = issuper ? "supergroup" : name;
        return UserGroupInformation.createUserForTesting((String)name, (String[])new String[]{group});
    }

    static void mkdir(FileSystem fs, String dir) throws IOException {
        Path p = new Path(dir);
        fs.mkdirs(p);
        fs.setPermission(p, new FsPermission(511));
    }

    RunningJob runJobAsUser(final JobConf job, UserGroupInformation ugi) throws Exception {
        JobSubmissionProtocol jobSubmitClient = TestSubmitJob.getJobSubmitClient(job, ugi);
        JobID id = jobSubmitClient.getNewJobId();
        InputSplit[] splits = this.computeJobSplit(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id), job);
        final Path jobSubmitDir = new Path(id.toString());
        FileSystem fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return jobSubmitDir.getFileSystem((Configuration)job);
            }
        });
        Path qJobSubmitDir = jobSubmitDir.makeQualified(fs);
        this.uploadJobFiles(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id), splits, qJobSubmitDir, ugi, job);
        jobSubmitClient.submitJob(id, qJobSubmitDir.toString(), null);
        JobClient jc = new JobClient(job);
        return jc.getJob(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id));
    }

    private InputSplit[] computeJobSplit(JobID id, JobConf conf) throws IOException {
        InputSplit[] splits = conf.getInputFormat().getSplits(conf, conf.getNumMapTasks());
        conf.setNumMapTasks(splits.length);
        return splits;
    }

    private void uploadJobFiles(JobID id, InputSplit[] splits, Path jobSubmitDir, UserGroupInformation ugi, final JobConf conf) throws Exception {
        final Path confLocation = JobSubmissionFiles.getJobConfPath((Path)jobSubmitDir);
        FileSystem fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return confLocation.getFileSystem((Configuration)conf);
            }
        });
        JobSplitWriter.createSplitFiles((Path)jobSubmitDir, (Configuration)conf, (FileSystem)fs, (InputSplit[])splits);
        FsPermission perm = new FsPermission(448);
        FSDataOutputStream confOut = FileSystem.create((FileSystem)fs, (Path)confLocation, (FsPermission)perm);
        conf.writeXml((OutputStream)confOut);
        confOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistinctUsers() throws Exception {
        MiniMRCluster mr = null;
        Configuration conf = new Configuration();
        final MiniHDFSCluster dfs = new MiniHDFSCluster(conf, 4, true, null);
        try {
            FileSystem fs = (FileSystem)DFS_UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return dfs.getFileSystem();
                }
            });
            TestMiniMRWithDFSWithDistinctUsers.mkdir(fs, "/user");
            TestMiniMRWithDFSWithDistinctUsers.mkdir(fs, "/mapred");
            UserGroupInformation MR_UGI = UserGroupInformation.getLoginUser();
            mr = new MiniMRCluster(0, 0, 4, dfs.getFileSystem().getUri().toString(), 1, null, null, MR_UGI);
            String jobTrackerName = "localhost:" + mr.getJobTrackerPort();
            JobConf job1 = mr.createJobConf();
            String input = "The quick brown fox\nhas many silly\nred fox sox\n";
            Path inDir = new Path("/testing/distinct/input");
            Path outDir = new Path("/testing/distinct/output");
            TestMiniMRClasspath.configureWordCount(fs, jobTrackerName, job1, input, 2, 1, inDir, outDir);
            this.runJobAsUser(job1, PI_UGI);
            JobConf job2 = mr.createJobConf();
            Path inDir2 = new Path("/testing/distinct/input2");
            Path outDir2 = new Path("/testing/distinct/output2");
            TestMiniMRClasspath.configureWordCount(fs, jobTrackerName, job2, input, 2, 1, inDir2, outDir2);
            this.runJobAsUser(job2, WC_UGI);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

