/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.junit.Ignore;

@Ignore
public class TestMiniMRMapRedDebugScript
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMiniMRMapRedDebugScript.class.getName());
    private MiniMRCluster mr;
    private MiniHDFSCluster dfs;
    private FileSystem fileSys;

    public static String readTaskLog(TaskLog.LogName filter, TaskAttemptID taskId, boolean isCleanup) throws IOException {
        int res;
        StringBuffer result = new StringBuffer();
        TaskLog.Reader taskLogReader = new TaskLog.Reader(taskId, filter, 0L, -1L, TaskLog.getAllLogsFileDetails((TaskAttemptID)taskId, (boolean)isCleanup, (boolean)false), false);
        byte[] b = new byte[65536];
        while ((res = taskLogReader.read(b)) > 0) {
            result.append(new String(b));
        }
        taskLogReader.close();
        String str = result.toString();
        str = str.trim();
        return str;
    }

    public String launchFailMapAndDebug(JobConf conf, Path inDir, Path outDir, Path debugDir, String debugScript, String input) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("failmap");
        conf.setMapperClass(MapClass.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(0);
        conf.setMapDebugScript(debugScript);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
        FileSystem debugFs = debugDir.getFileSystem((Configuration)conf);
        Path scriptPath = new Path(debugDir, "testscript.txt");
        Path cachePath = new Path("/cacheDir");
        if (!debugFs.mkdirs(cachePath)) {
            throw new IOException("Mkdirs failed to create " + cachePath.toString());
        }
        debugFs.copyFromLocalFile(scriptPath, cachePath);
        URI uri = debugFs.getUri().resolve(cachePath + "/testscript.txt#testscript");
        DistributedCache.createSymlink((Configuration)conf);
        DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
        RunningJob job = null;
        try {
            job = new JobClient(conf).submitJob(conf);
        }
        catch (IOException e) {
            LOG.info((Object)"Running Job failed", (Throwable)e);
        }
        JobID jobId = job.getID();
        TaskAttemptID taskId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, 0), 0);
        while (!job.isComplete()) {
        }
        return TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.DEBUGOUT, taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapDebugScript() throws Exception {
        try {
            Configuration cnf = new Configuration();
            this.dfs = new MiniHDFSCluster(cnf, 1, true, null);
            this.fileSys = this.dfs.getFileSystem();
            this.mr = new MiniMRCluster(2, this.fileSys.getName(), 1);
            JobConf conf = this.mr.createJobConf();
            Path debugDir = new Path("build/test/debug");
            Path inDir = new Path("testing/wc/input");
            Path outDir = new Path("testing/wc/output");
            String debugScript = "./testscript";
            String input = "The input";
            String result = this.launchFailMapAndDebug(conf, inDir, outDir, debugDir, debugScript, input);
            TestMiniMRMapRedDebugScript.assertTrue((boolean)result.contains("Test Script\nBailing out"));
        }
        finally {
            try {
                if (this.fileSys != null) {
                    this.fileSys.close();
                }
                if (this.dfs != null) {
                    this.dfs.shutdown();
                }
                if (this.mr != null) {
                    this.mr.shutdown();
                }
            }
            catch (IOException ioe) {
                LOG.info((Object)("IO exception in closing file system:" + ioe.getMessage()), (Throwable)ioe);
            }
        }
    }

    public static void main(String[] args) {
        TestMiniMRMapRedDebugScript tmds = new TestMiniMRMapRedDebugScript();
        try {
            tmds.testMapDebugScript();
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in test: " + e.getMessage()), (Throwable)e);
        }
    }

    public static class MapClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            System.err.println("Bailing out");
            throw new IOException();
        }
    }
}

