/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestMiniMRChildTask
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMiniMRChildTask.class.getName());
    private static final String OLD_CONFIGS = "test.old.configs";
    private static final String TASK_OPTS_VAL = "-Xmx200m";
    private static final String MAP_OPTS_VAL = "-Xmx200m";
    private static final String REDUCE_OPTS_VAL = "-Xmx300m";
    private MiniMRCluster mr;
    private MiniHDFSCluster dfs;
    private FileSystem fileSys;

    private void configure(JobConf conf, Path inDir, Path outDir, String input, Class<? extends Mapper> map, Class<? extends Reducer> reduce) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("testmap");
        conf.setMapperClass(map);
        conf.setReducerClass(reduce);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
    }

    public void launchTest(JobConf conf, Path inDir, Path outDir, String input) throws IOException {
        this.configure(conf, inDir, outDir, input, MapClass.class, IdentityReducer.class);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        JobClient.runJob((JobConf)conf);
        outFs.delete(outDir, true);
        conf.set("mapred.child.tmp", "../temp");
        JobClient.runJob((JobConf)conf);
        outFs.delete(outDir, true);
        conf.set("mapred.child.tmp", "/tmp");
        JobClient.runJob((JobConf)conf);
        outFs.delete(outDir, true);
    }

    private static void checkEnv(String envName, String expValue, String mode) {
        String envValue = System.getenv(envName).trim();
        if ("append".equals(mode)) {
            if (envValue == null || !envValue.contains(":")) {
                throw new RuntimeException("Missing env variable");
            }
            String[] parts = envValue.split(":");
            if (!parts[parts.length - 1].equals(expValue)) {
                throw new RuntimeException("Wrong env variable in append mode");
            }
        } else if (envValue == null || !envValue.equals(expValue)) {
            throw new RuntimeException("Wrong env variable in noappend mode");
        }
    }

    public void setUp() {
        try {
            this.dfs = new MiniHDFSCluster(new Configuration(), 1, true, null);
            this.fileSys = this.dfs.getFileSystem();
            this.mr = new MiniMRCluster(2, this.fileSys.getUri().toString(), 1);
        }
        catch (IOException ioe) {
            this.tearDown();
        }
    }

    public void tearDown() {
        try {
            if (this.fileSys != null) {
                this.fileSys.close();
            }
            if (this.dfs != null) {
                this.dfs.shutdown();
            }
            if (this.mr != null) {
                this.mr.shutdown();
            }
        }
        catch (IOException ioe) {
            LOG.info((Object)"IO exception in closing file system)");
            ioe.printStackTrace();
        }
    }

    public void testTaskTempDir() {
        try {
            JobConf conf = this.mr.createJobConf();
            Path inDir = new Path("testing/wc/input");
            Path outDir = new Path("testing/wc/output");
            String input = "The input";
            this.launchTest(conf, inDir, outDir, input);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestMiniMRChildTask.fail((String)"Exception in testing temp dir");
            this.tearDown();
        }
    }

    public void testTaskEnv() {
        try {
            JobConf conf = this.mr.createJobConf();
            Path inDir = new Path("testing/wc/input1");
            Path outDir = new Path("testing/wc/output1");
            FileSystem outFs = outDir.getFileSystem((Configuration)conf);
            this.runTestTaskEnv(conf, inDir, outDir, false);
            outFs.delete(outDir, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestMiniMRChildTask.fail((String)"Exception in testing child env");
            this.tearDown();
        }
    }

    public void testTaskOldEnv() {
        try {
            JobConf conf = this.mr.createJobConf();
            Path inDir = new Path("testing/wc/input1");
            Path outDir = new Path("testing/wc/output1");
            FileSystem outFs = outDir.getFileSystem((Configuration)conf);
            this.runTestTaskEnv(conf, inDir, outDir, true);
            outFs.delete(outDir, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestMiniMRChildTask.fail((String)"Exception in testing child env");
            this.tearDown();
        }
    }

    void runTestTaskEnv(JobConf conf, Path inDir, Path outDir, boolean oldConfigs) throws IOException {
        String input = "The input";
        this.configure(conf, inDir, outDir, input, EnvCheckMapper.class, EnvCheckReducer.class);
        String mapTaskEnvKey = "mapred.map.child.env";
        String reduceTaskEnvKey = "mapred.map.child.env";
        String mapTaskJavaOptsKey = "mapred.map.child.java.opts";
        String reduceTaskJavaOptsKey = "mapred.reduce.child.java.opts";
        String mapTaskJavaOpts = "-Xmx200m";
        String reduceTaskJavaOpts = REDUCE_OPTS_VAL;
        conf.setBoolean(OLD_CONFIGS, oldConfigs);
        if (oldConfigs) {
            reduceTaskEnvKey = "mapred.child.env";
            mapTaskEnvKey = "mapred.child.env";
            reduceTaskJavaOptsKey = "mapred.child.java.opts";
            mapTaskJavaOptsKey = "mapred.child.java.opts";
            reduceTaskJavaOpts = "-Xmx200m";
            mapTaskJavaOpts = "-Xmx200m";
        }
        conf.set(mapTaskEnvKey, "MY_PATH=/tmp,HOME=/tmp,LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/tmp,PATH=$PATH:/tmp,NEW_PATH=$NEW_PATH:/tmp");
        conf.set(reduceTaskEnvKey, "MY_PATH=/tmp,HOME=/tmp,LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/tmp,PATH=$PATH:/tmp,NEW_PATH=$NEW_PATH:/tmp");
        conf.set("path", System.getenv("PATH"));
        conf.set(mapTaskJavaOptsKey, mapTaskJavaOpts);
        conf.set(reduceTaskJavaOptsKey, reduceTaskJavaOpts);
        RunningJob job = JobClient.runJob((JobConf)conf);
        TestMiniMRChildTask.assertTrue((String)"The environment checker job failed.", (boolean)job.isSuccessful());
    }

    static class EnvCheckReducer
    extends MapReduceBase
    implements Reducer<WritableComparable, Writable, WritableComparable, Writable> {
        EnvCheckReducer() {
        }

        public void configure(JobConf job) {
            boolean oldConfigs = job.getBoolean(TestMiniMRChildTask.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = job.get("mapred.child.java.opts");
                Assert.assertNotNull((String)"mapred.child.java.opts is null!", (Object)javaOpts);
                Assert.assertEquals((String)("mapred.child.java.opts has value of: " + javaOpts), (String)javaOpts, (String)"-Xmx200m");
            } else {
                String reduceJavaOpts = job.get("mapred.reduce.child.java.opts");
                Assert.assertNotNull((String)"mapred.reduce.child.java.opts is null!", (Object)reduceJavaOpts);
                Assert.assertEquals((String)("mapred.reduce.child.java.opts has value of: " + reduceJavaOpts), (String)reduceJavaOpts, (String)TestMiniMRChildTask.REDUCE_OPTS_VAL);
            }
            String path = job.get("path");
            String pwd = System.getenv("PWD");
            Assert.assertTrue((String)"LD doesnt contain pwd", (boolean)System.getenv("LD_LIBRARY_PATH").contains(pwd));
            TestMiniMRChildTask.checkEnv("LD_LIBRARY_PATH", "/tmp", "append");
            TestMiniMRChildTask.checkEnv("HOME", "/tmp", "noappend");
            TestMiniMRChildTask.checkEnv("MY_PATH", "/tmp", "noappend");
            TestMiniMRChildTask.checkEnv("NEW_PATH", ":/tmp", "noappend");
            TestMiniMRChildTask.checkEnv("PATH", path + ":/tmp", "noappend");
        }

        public void reduce(WritableComparable key, Iterator<Writable> values, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
        }
    }

    static class EnvCheckMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        EnvCheckMapper() {
        }

        public void configure(JobConf job) {
            boolean oldConfigs = job.getBoolean(TestMiniMRChildTask.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = job.get("mapred.child.java.opts");
                Assert.assertNotNull((String)"mapred.child.java.opts is null!", (Object)javaOpts);
                Assert.assertEquals((String)("mapred.child.java.opts has value of: " + javaOpts), (String)javaOpts, (String)"-Xmx200m");
            } else {
                String mapJavaOpts = job.get("mapred.map.child.java.opts");
                Assert.assertNotNull((String)"mapred.map.child.java.opts is null!", (Object)mapJavaOpts);
                Assert.assertEquals((String)("mapred.map.child.java.opts has value of: " + mapJavaOpts), (String)mapJavaOpts, (String)"-Xmx200m");
            }
            String path = job.get("path");
            String pwd = System.getenv("PWD");
            Assert.assertTrue((String)"LD doesnt contain pwd", (boolean)System.getenv("LD_LIBRARY_PATH").contains(pwd));
            TestMiniMRChildTask.checkEnv("LD_LIBRARY_PATH", "/tmp", "append");
            TestMiniMRChildTask.checkEnv("HOME", "/tmp", "noappend");
            TestMiniMRChildTask.checkEnv("MY_PATH", "/tmp", "noappend");
            TestMiniMRChildTask.checkEnv("NEW_PATH", ":/tmp", "noappend");
            TestMiniMRChildTask.checkEnv("PATH", path + ":/tmp", "noappend");
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
        }
    }

    public static class MapClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        Path tmpDir;
        FileSystem localFs;

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            String tmp = null;
            if (this.localFs.exists(this.tmpDir)) {
                tmp = this.tmpDir.makeQualified(this.localFs).toString();
                Assert.assertEquals((String)tmp, (String)new Path(System.getProperty("java.io.tmpdir")).makeQualified(this.localFs).toString());
            } else {
                Assert.fail((String)("Temp directory " + this.tmpDir + " doesnt exist."));
            }
            File tmpFile = File.createTempFile("test", ".tmp");
            Assert.assertEquals((String)tmp, (String)new Path(tmpFile.getParent()).makeQualified(this.localFs).toString());
        }

        public void configure(JobConf job) {
            this.tmpDir = new Path(job.get("mapred.child.tmp", "./tmp"));
            try {
                this.localFs = FileSystem.getLocal((Configuration)job);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Assert.fail((String)"IOException in getting localFS");
            }
        }
    }
}

