/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.WordCount;

public class TestKillCompletedJob
extends TestCase {
    static Boolean launchWordCount(String fileSys, String jobTracker, JobConf conf, String input, int numMaps, int numReduces) throws IOException {
        Path inDir = new Path("/testing/wc/input");
        Path outDir = new Path("/testing/wc/output");
        FileSystem fs = FileSystem.get((URI)URI.create(fileSys), (Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        FileSystem.setDefaultUri((Configuration)conf, (String)fileSys);
        conf.set("mapred.job.tracker", jobTracker);
        conf.setJobName("wordcount");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(WordCount.MapClass.class);
        conf.setCombinerClass(WordCount.Reduce.class);
        conf.setReducerClass(WordCount.Reduce.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        RunningJob rj = JobClient.runJob((JobConf)conf);
        JobID jobId = rj.getID();
        if (rj.isSuccessful()) {
            System.out.println("Job Id:" + jobId + " completed successfully. Killing it now");
            rj.killJob();
        }
        return rj.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKillCompJob() throws IOException {
        String namenode = null;
        MiniHDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            boolean taskTrackers = true;
            Configuration conf = new Configuration();
            dfs = new MiniHDFSCluster(conf, 1, true, null);
            fileSys = dfs.getFileSystem();
            namenode = fileSys.getUri().toString();
            mr = new MiniMRCluster(1, namenode, 3);
            JobConf jobConf = new JobConf();
            String jobTrackerName = "localhost:" + mr.getJobTrackerPort();
            Boolean result = TestKillCompletedJob.launchWordCount(namenode, jobTrackerName, jobConf, "Small text\n", 1, 0);
            TestKillCompletedJob.assertTrue((boolean)result);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

