/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Random;
import org.apache.hadoop.record.BinaryRecordInput;
import org.apache.hadoop.record.BinaryRecordOutput;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.CsvRecordInput;
import org.apache.hadoop.record.CsvRecordOutput;
import org.apache.hadoop.record.RecBuffer;
import org.apache.hadoop.record.RecInt;
import org.apache.hadoop.record.RecString;
import org.apache.hadoop.record.Record;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.RecordOutput;
import org.apache.hadoop.record.Utils;
import org.apache.hadoop.record.XmlRecordInput;
import org.apache.hadoop.record.XmlRecordOutput;

public class RecordBench {
    private static final long SEED = 3735928559L;
    private static final Random rand = new Random();

    private RecordBench() {
    }

    private static void initBuffers(Record[] buffers) {
        int BUFLEN = 32;
        for (int idx = 0; idx < buffers.length; ++idx) {
            buffers[idx] = new RecBuffer();
            int buflen = rand.nextInt(32);
            byte[] bytes = new byte[buflen];
            rand.nextBytes(bytes);
            ((RecBuffer)buffers[idx]).setData(new Buffer(bytes));
        }
    }

    private static void initStrings(Record[] strings) {
        int STRLEN = 32;
        for (int idx = 0; idx < strings.length; ++idx) {
            strings[idx] = new RecString();
            int strlen = rand.nextInt(32);
            StringBuilder sb = new StringBuilder(strlen);
            for (int ich = 0; ich < strlen; ++ich) {
                int cpt = 0;
                while (!Utils.isValidCodePoint((int)(cpt = rand.nextInt(0x110000)))) {
                }
                sb.appendCodePoint(cpt);
            }
            ((RecString)strings[idx]).setData(sb.toString());
        }
    }

    private static void initInts(Record[] ints) {
        for (int idx = 0; idx < ints.length; ++idx) {
            ints[idx] = new RecInt();
            ((RecInt)ints[idx]).setData(rand.nextInt());
        }
    }

    private static Record[] makeArray(String type, int numRecords, Times times) {
        Method init = null;
        try {
            init = RecordBench.class.getDeclaredMethod("init" + RecordBench.toCamelCase(type) + "s", Record[].class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        Record[] records = new Record[numRecords];
        times.init = System.nanoTime();
        try {
            init.invoke(null, new Object[]{records});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        times.init = System.nanoTime() - times.init;
        return records;
    }

    private static void runBinaryBench(String type, int numRecords, Times times) throws IOException {
        int idx;
        int idx2;
        Record[] records = RecordBench.makeArray(type, numRecords, times);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BinaryRecordOutput rout = new BinaryRecordOutput((OutputStream)bout);
        DataOutputStream dout = new DataOutputStream(bout);
        for (idx2 = 0; idx2 < numRecords; ++idx2) {
            records[idx2].serialize((RecordOutput)rout);
        }
        bout.reset();
        times.serialize = System.nanoTime();
        for (idx2 = 0; idx2 < numRecords; ++idx2) {
            records[idx2].serialize((RecordOutput)rout);
        }
        times.serialize = System.nanoTime() - times.serialize;
        byte[] serialized = bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        BinaryRecordInput rin = new BinaryRecordInput((InputStream)bin);
        times.deserialize = System.nanoTime();
        for (idx = 0; idx < numRecords; ++idx) {
            records[idx].deserialize((RecordInput)rin);
        }
        times.deserialize = System.nanoTime() - times.deserialize;
        bout.reset();
        times.write = System.nanoTime();
        for (idx = 0; idx < numRecords; ++idx) {
            records[idx].write((DataOutput)dout);
        }
        times.write = System.nanoTime() - times.write;
        bin.reset();
        DataInputStream din = new DataInputStream(bin);
        times.readFields = System.nanoTime();
        for (int idx3 = 0; idx3 < numRecords; ++idx3) {
            records[idx3].readFields((DataInput)din);
        }
        times.readFields = System.nanoTime() - times.readFields;
    }

    private static void runCsvBench(String type, int numRecords, Times times) throws IOException {
        int idx;
        Record[] records = RecordBench.makeArray(type, numRecords, times);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CsvRecordOutput rout = new CsvRecordOutput((OutputStream)bout);
        for (idx = 0; idx < numRecords; ++idx) {
            records[idx].serialize((RecordOutput)rout);
        }
        bout.reset();
        times.serialize = System.nanoTime();
        for (idx = 0; idx < numRecords; ++idx) {
            records[idx].serialize((RecordOutput)rout);
        }
        times.serialize = System.nanoTime() - times.serialize;
        byte[] serialized = bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        CsvRecordInput rin = new CsvRecordInput((InputStream)bin);
        times.deserialize = System.nanoTime();
        for (int idx2 = 0; idx2 < numRecords; ++idx2) {
            records[idx2].deserialize((RecordInput)rin);
        }
        times.deserialize = System.nanoTime() - times.deserialize;
    }

    private static void runXmlBench(String type, int numRecords, Times times) throws IOException {
        int idx;
        Record[] records = RecordBench.makeArray(type, numRecords, times);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XmlRecordOutput rout = new XmlRecordOutput((OutputStream)bout);
        for (idx = 0; idx < numRecords; ++idx) {
            records[idx].serialize((RecordOutput)rout);
        }
        bout.reset();
        bout.write("<records>\n".getBytes());
        times.serialize = System.nanoTime();
        for (idx = 0; idx < numRecords; ++idx) {
            records[idx].serialize((RecordOutput)rout);
        }
        times.serialize = System.nanoTime() - times.serialize;
        bout.write("</records>\n".getBytes());
        byte[] serialized = bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        times.deserialize = System.nanoTime();
        XmlRecordInput rin = new XmlRecordInput((InputStream)bin);
        for (int idx2 = 0; idx2 < numRecords; ++idx2) {
            records[idx2].deserialize((RecordInput)rin);
        }
        times.deserialize = System.nanoTime() - times.deserialize;
    }

    private static void printTimes(String type, String format, int numRecords, Times times) {
        System.out.println("Type: " + type + " Format: " + format + " #Records: " + numRecords);
        if (times.init != 0L) {
            System.out.println("Initialization Time (Per record) : " + times.init / (long)numRecords + " Nanoseconds");
        }
        if (times.serialize != 0L) {
            System.out.println("Serialization Time (Per Record) : " + times.serialize / (long)numRecords + " Nanoseconds");
        }
        if (times.deserialize != 0L) {
            System.out.println("Deserialization Time (Per Record) : " + times.deserialize / (long)numRecords + " Nanoseconds");
        }
        if (times.write != 0L) {
            System.out.println("Write Time (Per Record) : " + times.write / (long)numRecords + " Nanoseconds");
        }
        if (times.readFields != 0L) {
            System.out.println("ReadFields Time (Per Record) : " + times.readFields / (long)numRecords + " Nanoseconds");
        }
        System.out.println();
    }

    private static String toCamelCase(String inp) {
        char firstChar = inp.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return "" + Character.toUpperCase(firstChar) + inp.substring(1);
        }
        return inp;
    }

    private static void exitOnError() {
        String usage = "RecordBench {buffer|string|int} {binary|csv|xml} <numRecords>";
        System.out.println(usage);
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        String version = "RecordBench v0.1";
        System.out.println(version + "\n");
        if (args.length != 3) {
            RecordBench.exitOnError();
        }
        String typeName = args[0];
        String format = args[1];
        int numRecords = Integer.decode(args[2]);
        Method bench = null;
        try {
            bench = RecordBench.class.getDeclaredMethod("run" + RecordBench.toCamelCase(format) + "Bench", String.class, Integer.TYPE, Times.class);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            RecordBench.exitOnError();
        }
        if (numRecords < 0) {
            RecordBench.exitOnError();
        }
        rand.setSeed(3735928559L);
        Times times = new Times();
        try {
            bench.invoke(null, typeName, numRecords, times);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        rand.setSeed(3735928559L);
        try {
            bench.invoke(null, typeName, numRecords, times);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        RecordBench.printTimes(typeName, format, numRecords, times);
    }

    private static class Times {
        long init;
        long serialize;
        long deserialize;
        long write;
        long readFields;

        private Times() {
        }
    }
}

