/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestRackAwareTaskPlacement;
import org.apache.hadoop.mapred.UtilsForTests;

public class TestMultipleLevelCaching
extends TestCase {
    private static final int MAX_LEVEL = 5;
    final Path inDir = new Path("/cachetesting");
    final Path outputPath = new Path("/output");

    private static String getRack(int id, int level) {
        int length;
        StringBuilder rack = new StringBuilder();
        char alpha = 'a';
        for (length = level + 1; length > level; --length) {
            rack.append("/");
            rack.append(alpha);
            alpha = (char)(alpha + '\u0001');
        }
        while (length > 0) {
            rack.append("/");
            rack.append(alpha);
            rack.append(id);
            alpha = (char)(alpha + '\u0001');
            --length;
        }
        return rack.toString();
    }

    public void testMultiLevelCaching() throws IOException {
        for (int i = 1; i <= 5; ++i) {
            this.testCachingAtLevel(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCachingAtLevel(int level) throws IOException {
        String namenode = null;
        MiniHDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        String testName = "TestMultiLevelCaching";
        try {
            boolean taskTrackers = true;
            String rack1 = TestMultipleLevelCaching.getRack(0, level);
            String rack2 = TestMultipleLevelCaching.getRack(1, level);
            Configuration conf = new Configuration();
            dfs = new MiniHDFSCluster(conf, 1, true, new String[]{rack1}, new String[]{"host1.com"});
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file"), (short)1);
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            JobConf jc = new JobConf();
            jc.setInt("mapred.task.cache.levels", level + 2);
            mr = new MiniMRCluster(1, namenode, 1, new String[]{rack2}, new String[]{"host2.com"}, jc);
            TestRackAwareTaskPlacement.launchJobAndTestCounters(testName, mr, (FileSystem)fileSys, this.inDir, this.outputPath, 1, 1, 0, 0);
            mr.shutdown();
        }
        finally {
            fileSys.delete(this.inDir, true);
            fileSys.delete(this.outputPath, true);
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }
}

