/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.security.PrivilegedExceptionAction;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestMiniMRWithDFSWithDistinctUsers;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.security.UserGroupInformation;

public class TestMapredSystemDir
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestMapredSystemDir.class);
    private static final UserGroupInformation MR_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("mr", false);
    private static final FsPermission SYSTEM_DIR_PARENT_PERMISSION = FsPermission.createImmutable((short)493);
    private static final FsPermission SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)448);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGarbledMapredSystemDir() throws Exception {
        final Configuration conf = new Configuration();
        MiniHDFSCluster dfs = null;
        MiniMRCluster mr = null;
        try {
            conf.set("dfs.permissions.supergroup", "supergroup");
            conf.set("mapred.system.dir", "/mapred");
            dfs = new MiniHDFSCluster(conf, 1, true, null);
            DistributedFileSystem fs = dfs.getFileSystem();
            Path mapredSysDir = new Path(conf.get("mapred.system.dir"));
            Path parentDir = mapredSysDir.getParent();
            fs.mkdirs(parentDir);
            fs.setPermission(parentDir, new FsPermission(SYSTEM_DIR_PARENT_PERMISSION));
            fs.mkdirs(mapredSysDir);
            fs.setPermission(mapredSysDir, new FsPermission(SYSTEM_DIR_PERMISSION));
            fs.setOwner(mapredSysDir, "mr", "mrgroup");
            final MiniHDFSCluster finalDFS = dfs;
            mr = (MiniMRCluster)MR_UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<MiniMRCluster>(){

                @Override
                public MiniMRCluster run() throws Exception {
                    Configuration mrConf = new Configuration(conf);
                    DistributedFileSystem fs = finalDFS.getFileSystem();
                    MiniMRCluster mr2 = new MiniMRCluster(0, 0, 0, fs.getUri().toString(), 1, null, null, MR_UGI, new JobConf(mrConf));
                    JobTracker jobtracker = mr2.getJobTrackerRunner().getJobTracker();
                    Path garbage = new Path(jobtracker.getSystemDir(), "garbage");
                    fs.mkdirs(garbage);
                    fs.setPermission(garbage, new FsPermission(SYSTEM_DIR_PERMISSION));
                    return mr2;
                }
            });
            Path garbage = new Path(mr.getJobTrackerRunner().getJobTracker().getSystemDir(), "garbage");
            fs.setOwner(garbage, "test", "test-group");
            final MiniMRCluster mr2 = mr;
            MR_UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    mr2.stopJobTracker();
                    mr2.getJobTrackerConf().setBoolean("mapred.jobtracker.restart.recover", false);
                    mr2.startJobTracker(false);
                    for (int i = 0; i < 5; ++i) {
                        LOG.info((Object)("Check #" + i));
                        if (!mr2.getJobTrackerRunner().isActive()) {
                            return null;
                        }
                        UtilsForTests.waitFor(2000L);
                    }
                    return null;
                }
            });
            TestMapredSystemDir.assertFalse((String)"JobTracker did not bail out (waited for 10 secs)", (boolean)mr.getJobTrackerRunner().isActive());
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

