/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.mortbay.log.Log;

public class TestJobHistoryConfig
extends TestCase {
    private MiniHDFSCluster mdfs = null;
    private String namenode = null;
    FileSystem fileSys = null;
    final Path inDir = new Path("./input");
    final Path outDir = new Path("./output");

    private void setUpCluster(JobConf conf) throws IOException, InterruptedException {
        this.mdfs = new MiniHDFSCluster((Configuration)conf, 1, true, null);
        this.fileSys = this.mdfs.getFileSystem();
        this.namenode = this.fileSys.getUri().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobHistoryWithValidConfiguration() throws Exception {
        try {
            JobConf conf = new JobConf();
            this.setUpCluster(conf);
            conf.set("hadoop.job.history.location", "/hadoop/history");
            conf = MiniMRCluster.configureJobConf(conf, this.namenode, 0, 0, null);
            boolean started = this.canStartJobTracker(conf);
            TestJobHistoryConfig.assertTrue((boolean)started);
        }
        finally {
            if (this.mdfs != null) {
                try {
                    this.mdfs.shutdown();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void testJobHistoryLogging() throws Exception {
        JobConf conf = new JobConf();
        this.setUpCluster(conf);
        conf.setMapperClass(MapperClass.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setNumReduceTasks(0);
        JobClient jc = new JobClient(conf);
        conf.set("hadoop.job.history.location", "/hadoop/history");
        conf = MiniMRCluster.configureJobConf(conf, this.namenode, 0, 0, null);
        FileSystem inFs = this.inDir.getFileSystem((Configuration)conf);
        if (!inFs.mkdirs(this.inDir)) {
            throw new IOException("Mkdirs failed to create " + this.inDir.toString());
        }
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.outDir);
        conf.setSpeculativeExecution(false);
        conf.setJobName("test");
        conf.setUser("testuser");
        conf.setQueueName("testQueue");
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        JobTracker jt = JobTracker.startTracker((JobConf)conf);
        TestJobHistoryConfig.assertTrue((jt != null ? 1 : 0) != 0);
        JobInProgress jip = new JobInProgress(new JobID("jt", 1), new JobConf((Configuration)conf), jt);
        TestJobHistoryConfig.assertTrue((jip != null ? 1 : 0) != 0);
        jip.jobFile = "testfile";
        String historyFile = JobHistory.getHistoryFilePath((JobID)jip.getJobID());
        JobHistory.JobInfo.logSubmitted((JobID)jip.getJobID(), (JobConf)jip.getJobConf(), (String)jip.jobFile, (long)jip.startTime);
    }

    private boolean canStartJobTracker(JobConf conf) throws InterruptedException, IOException {
        JobTracker jt = null;
        try {
            jt = JobTracker.startTracker((JobConf)conf);
            Log.info((String)"Started JobTracker");
        }
        catch (IOException e) {
            Log.info((String)"Can not Start JobTracker", (Object)e.getLocalizedMessage());
            return false;
        }
        if (jt != null) {
            jt.fs.close();
            jt.stopTracker();
        }
        return true;
    }

    public static class MapperClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        public void configure(JobConf job) {
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            throw new IOException();
        }
    }
}

