/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.TestTrackerDistributedCacheManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LinuxTaskController;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputLogFilter;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TestTaskTrackerLocalization;
import org.apache.hadoop.security.UserGroupInformation;

public class ClusterWithLinuxTaskController
extends TestCase {
    private static final Log LOG = LogFactory.getLog(ClusterWithLinuxTaskController.class);
    static String TT_GROUP = "mapreduce.tasktracker.group";
    protected MiniMRCluster mrCluster = null;
    protected MiniHDFSCluster dfsCluster = null;
    private JobConf clusterConf = null;
    protected Path homeDirectory;
    private static final int NUMBER_OF_NODES = 1;
    static final String TASKCONTROLLER_PATH = "taskcontroller-path";
    static final String TASKCONTROLLER_UGI = "taskcontroller-ugi";
    private static File configurationFile = null;
    protected UserGroupInformation jobOwner;
    protected static String taskTrackerSpecialGroup = null;
    protected static String taskTrackerPrimaryGroup = null;

    protected void startCluster() throws IOException, InterruptedException {
        JobConf conf = new JobConf();
        this.dfsCluster = new MiniHDFSCluster((Configuration)conf, 1, true, null);
        conf.set("mapred.task.tracker.task-controller", MyLinuxTaskController.class.getName());
        this.mrCluster = new MiniMRCluster(1, this.dfsCluster.getFileSystem().getUri().toString(), 4, null, null, conf);
        String ugi = System.getProperty(TASKCONTROLLER_UGI);
        this.clusterConf = this.mrCluster.createJobConf();
        String[] splits = ugi.split(",");
        this.jobOwner = UserGroupInformation.createUserForTesting((String)splits[0], (String[])new String[]{splits[1]});
        this.createHomeAndStagingDirectory(this.clusterConf);
    }

    private void createHomeAndStagingDirectory(JobConf conf) throws IOException {
        DistributedFileSystem fs = this.dfsCluster.getFileSystem();
        String path = "/user/" + this.jobOwner.getUserName();
        this.homeDirectory = new Path(path);
        LOG.info((Object)("Creating Home directory : " + this.homeDirectory));
        fs.mkdirs(this.homeDirectory);
        this.changePermission((FileSystem)fs);
        Path stagingArea = new Path(conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        LOG.info((Object)("Creating Staging root directory : " + stagingArea));
        fs.mkdirs(stagingArea);
        fs.setPermission(stagingArea, new FsPermission(511));
    }

    private void changePermission(FileSystem fs) throws IOException {
        fs.setOwner(this.homeDirectory, this.jobOwner.getUserName(), this.jobOwner.getGroupNames()[0]);
    }

    static File getTaskControllerConfFile(String path) {
        File confDirectory = new File(path, "../../conf");
        return new File(confDirectory, "taskcontroller.cfg");
    }

    static File createTaskControllerConf(String path, Configuration conf) throws IOException {
        File confDirectory = new File(path, "../../conf");
        if (!confDirectory.exists()) {
            confDirectory.mkdirs();
        }
        File configurationFile = new File(confDirectory, "taskcontroller.cfg");
        PrintWriter writer = new PrintWriter(new FileOutputStream(configurationFile));
        writer.println(String.format("mapred.local.dir=%s", conf.get("mapred.local.dir")));
        writer.println(String.format("hadoop.log.dir=%s", TaskLog.getBaseLogDir()));
        writer.println(String.format(TT_GROUP + "=%s", conf.get(TT_GROUP)));
        writer.flush();
        writer.close();
        return configurationFile;
    }

    protected static boolean shouldRun() {
        if (!ClusterWithLinuxTaskController.isTaskExecPathPassed() || !ClusterWithLinuxTaskController.isUserPassed()) {
            LOG.info((Object)"Not running test.");
            return false;
        }
        return true;
    }

    static boolean isTaskExecPathPassed() {
        String path = System.getProperty(TASKCONTROLLER_PATH);
        if (path == null || path.isEmpty() || path.equals("${taskcontroller-path}")) {
            LOG.info((Object)("Invalid taskcontroller-path : " + path));
            return false;
        }
        return true;
    }

    private static boolean isUserPassed() {
        String ugi = System.getProperty(TASKCONTROLLER_UGI);
        if (ugi != null && !ugi.equals("${taskcontroller-ugi}") && !ugi.isEmpty()) {
            if (ugi.indexOf(",") > 1) {
                return true;
            }
            LOG.info((Object)("Invalid taskcontroller-ugi : " + ugi));
            return false;
        }
        LOG.info((Object)("Invalid taskcontroller-ugi : " + ugi));
        return false;
    }

    protected JobConf getClusterConf() {
        return new JobConf((Configuration)this.clusterConf);
    }

    protected void tearDown() throws Exception {
        if (this.mrCluster != null) {
            this.mrCluster.shutdown();
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
        if (configurationFile != null) {
            configurationFile.delete();
        }
        super.tearDown();
    }

    protected void assertOwnerShip(Path outDir) throws IOException {
        FileSystem fs = outDir.getFileSystem((Configuration)this.clusterConf);
        this.assertOwnerShip(outDir, fs);
    }

    protected void assertOwnerShip(Path outDir, FileSystem fs) throws IOException {
        for (FileStatus status : fs.listStatus(outDir, (PathFilter)new OutputLogFilter())) {
            String owner = status.getOwner();
            String group = status.getGroup();
            LOG.info((Object)("Ownership of the file is " + status.getPath() + " is " + owner + "," + group));
            ClusterWithLinuxTaskController.assertTrue((String)("Output part-file's owner is not correct. Expected : " + this.jobOwner.getUserName() + " Found : " + owner), (boolean)owner.equals(this.jobOwner.getUserName()));
            ClusterWithLinuxTaskController.assertTrue((String)("Output part-file's group is not correct. Expected : " + this.jobOwner.getGroupNames()[0] + " Found : " + group), (boolean)group.equals(this.jobOwner.getGroupNames()[0]));
        }
    }

    public static void checkPermissionsOnPrivateDistCache(String[] localDirs, String user, String taskTrackerUser, String groupOwner) throws IOException {
        String expectedDirPerms = taskTrackerUser.equals(user) ? "drwxrws---" : "dr-xrws---";
        String expectedFilePerms = taskTrackerUser.equals(user) ? "-rwxrwx---" : "-r-xrwx---";
        for (String localDir : localDirs) {
            File distCacheDir = new File(localDir, TaskTracker.getPrivateDistributedCacheDir((String)user));
            if (!distCacheDir.exists()) continue;
            ClusterWithLinuxTaskController.checkPermissionsOnDir(distCacheDir, user, groupOwner, expectedDirPerms, expectedFilePerms);
        }
    }

    public static void checkPresenceOfPrivateDistCacheFiles(String[] localDirs, String user, String[] expectedFileNames) throws IOException {
        FileGatherer gatherer = new FileGatherer();
        for (String localDir : localDirs) {
            File distCacheDir = new File(localDir, TaskTracker.getPrivateDistributedCacheDir((String)user));
            ClusterWithLinuxTaskController.findExpectedFiles(expectedFileNames, distCacheDir, gatherer);
        }
        ClusterWithLinuxTaskController.assertEquals((String)"Files expected in private distributed cache were not found", (int)expectedFileNames.length, (int)gatherer.getCount());
    }

    public static void checkPermissionsOnPublicDistCache(FileSystem localFS, String[] localDirs, String owner, String group) throws IOException {
        for (String localDir : localDirs) {
            File distCacheDir = new File(localDir, TaskTracker.getPublicDistributedCacheDir());
            if (!distCacheDir.exists()) continue;
            ClusterWithLinuxTaskController.checkPublicFilePermissions(localFS, distCacheDir, owner, group);
        }
    }

    public static void checkPresenceOfPublicDistCacheFiles(String[] localDirs, String[] expectedFileNames) throws IOException {
        FileGatherer gatherer = new FileGatherer();
        for (String localDir : localDirs) {
            File distCacheDir = new File(localDir, TaskTracker.getPublicDistributedCacheDir());
            ClusterWithLinuxTaskController.findExpectedFiles(expectedFileNames, distCacheDir, gatherer);
        }
        ClusterWithLinuxTaskController.assertEquals((String)"Files expected in public distributed cache were not found", (int)expectedFileNames.length, (int)gatherer.getCount());
    }

    private static void checkPublicFilePermissions(FileSystem localFS, File dir, String owner, String group) throws IOException {
        Path dirPath = new Path(dir.getAbsolutePath());
        TestTrackerDistributedCacheManager.checkPublicFilePermissions(localFS, new Path[]{dirPath});
        TestTrackerDistributedCacheManager.checkPublicFileOwnership(localFS, new Path[]{dirPath}, owner, group);
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                ClusterWithLinuxTaskController.checkPublicFilePermissions(localFS, file, owner, group);
            }
        }
    }

    private static void checkPermissionsOnDir(File dir, String user, String groupOwner, String expectedDirPermissions, String expectedFilePermissions) throws IOException {
        File[] files;
        TestTaskTrackerLocalization.checkFilePermissions(dir.toString(), expectedDirPermissions, user, groupOwner);
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                ClusterWithLinuxTaskController.checkPermissionsOnDir(file, user, groupOwner, expectedDirPermissions, expectedFilePermissions);
                continue;
            }
            TestTaskTrackerLocalization.checkFilePermissions(file.toString(), expectedFilePermissions, user, groupOwner);
        }
    }

    private static void findExpectedFiles(String[] expectedFileNames, File rootDir, FileGatherer gatherer) {
        File[] files = rootDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ClusterWithLinuxTaskController.findExpectedFiles(expectedFileNames, file, gatherer);
                continue;
            }
            if (!ClusterWithLinuxTaskController.isFilePresent(expectedFileNames, file)) continue;
            gatherer.addFileName(file.getName());
        }
    }

    private static boolean isFilePresent(String[] expectedFileNames, File file) {
        boolean foundFileName = false;
        for (String name : expectedFileNames) {
            if (!name.equals(file.getName())) continue;
            foundFileName = true;
            break;
        }
        return foundFileName;
    }

    static {
        if (ClusterWithLinuxTaskController.isTaskExecPathPassed()) {
            try {
                taskTrackerSpecialGroup = FileSystem.getLocal((Configuration)new Configuration()).getFileStatus(new Path(System.getProperty(TASKCONTROLLER_PATH), "task-controller")).getGroup();
            }
            catch (IOException e) {
                LOG.warn((Object)"Could not get group of the binary", (Throwable)e);
                ClusterWithLinuxTaskController.fail((String)"Could not get group of the binary");
            }
            try {
                taskTrackerPrimaryGroup = UserGroupInformation.getCurrentUser().getGroupNames()[0];
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Could not get primary group of the current user", (Throwable)ioe);
                ClusterWithLinuxTaskController.fail((String)"Could not get primary group of the current user");
            }
        }
    }

    private static class FileGatherer {
        List<String> foundFileNames = new ArrayList<String>();

        private FileGatherer() {
        }

        void addFileName(String fileName) {
            this.foundFileNames.add(fileName);
        }

        int getCount() {
            return this.foundFileNames.size();
        }
    }

    public static class MyLinuxTaskController
    extends LinuxTaskController {
        String taskControllerExePath = System.getProperty("taskcontroller-path") + "/task-controller";
        static volatile int attemptedSigQuits = 0;
        static volatile int failedSigQuits = 0;

        public void setup(LocalDirAllocator allocator) throws IOException {
            this.getConf().set(TT_GROUP, taskTrackerSpecialGroup);
            configurationFile = ClusterWithLinuxTaskController.createTaskControllerConf(System.getProperty(ClusterWithLinuxTaskController.TASKCONTROLLER_PATH), this.getConf());
            super.setup(allocator);
        }

        protected String getTaskControllerExecutablePath() {
            return this.taskControllerExePath;
        }

        void setTaskControllerExe(String execPath) {
            this.taskControllerExePath = execPath;
        }
    }
}

