/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class TestMRMultipleOutputs
extends HadoopTestCase {
    private static String localPathRoot = System.getProperty("test.build.data", "/tmp");
    private static final Path ROOT_DIR = new Path(localPathRoot, "testing/mo");
    private static final Path IN_DIR = new Path(ROOT_DIR, "input");
    private static final Path OUT_DIR = new Path(ROOT_DIR, "output");
    private static String TEXT = "text";
    private static String SEQUENCE = "sequence";

    public TestMRMultipleOutputs() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testWithoutCounters() throws Exception {
        this._testMultipleOutputs(false);
    }

    public void testWithCounters() throws Exception {
        this._testMultipleOutputs(true);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(ROOT_DIR, true);
    }

    @Override
    public void tearDown() throws Exception {
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(ROOT_DIR, true);
        super.tearDown();
    }

    protected void _testMultipleOutputs(boolean withCounters) throws Exception {
        FileStatus[] statuses;
        String input = "a\nb\nc\nd\ne\nc\nd\ne";
        JobConf conf = this.createJobConf();
        Job job = MapReduceTestUtil.createJob((Configuration)conf, IN_DIR, OUT_DIR, 2, 1, input);
        job.setJobName("mo");
        MultipleOutputs.addNamedOutput((Job)job, (String)TEXT, TextOutputFormat.class, LongWritable.class, Text.class);
        MultipleOutputs.addNamedOutput((Job)job, (String)SEQUENCE, SequenceFileOutputFormat.class, IntWritable.class, Text.class);
        MultipleOutputs.setCountersEnabled((Job)job, (boolean)withCounters);
        job.setMapperClass(MOMap.class);
        job.setReducerClass(MOReduce.class);
        job.waitForCompletion(true);
        int namedOutputCount = 0;
        int valueBasedOutputCount = 0;
        FileSystem fs = OUT_DIR.getFileSystem((Configuration)conf);
        for (FileStatus status : statuses = fs.listStatus(OUT_DIR)) {
            String fileName = status.getPath().getName();
            if (fileName.equals("text-m-00000") || fileName.equals("text-m-00001") || fileName.equals("text-r-00000") || fileName.equals("sequence_A-m-00000") || fileName.equals("sequence_A-m-00001") || fileName.equals("sequence_B-m-00000") || fileName.equals("sequence_B-m-00001") || fileName.equals("sequence_B-r-00000") || fileName.equals("sequence_C-r-00000")) {
                ++namedOutputCount;
                continue;
            }
            if (!fileName.equals("a-r-00000") && !fileName.equals("b-r-00000") && !fileName.equals("c-r-00000") && !fileName.equals("d-r-00000") && !fileName.equals("e-r-00000")) continue;
            ++valueBasedOutputCount;
        }
        TestMRMultipleOutputs.assertEquals((int)9, (int)namedOutputCount);
        TestMRMultipleOutputs.assertEquals((int)5, (int)valueBasedOutputCount);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(FileOutputFormat.getOutputPath((JobContext)job), "text-r-00000"))));
        int count = 0;
        String line = reader.readLine();
        while (line != null) {
            TestMRMultipleOutputs.assertTrue((boolean)line.endsWith(TEXT));
            line = reader.readLine();
            ++count;
        }
        reader.close();
        TestMRMultipleOutputs.assertFalse((count == 0 ? 1 : 0) != 0);
        SequenceFile.Reader seqReader = new SequenceFile.Reader(fs, new Path(FileOutputFormat.getOutputPath((JobContext)job), "sequence_B-r-00000"), (Configuration)conf);
        TestMRMultipleOutputs.assertEquals(IntWritable.class, (Object)seqReader.getKeyClass());
        TestMRMultipleOutputs.assertEquals(Text.class, (Object)seqReader.getValueClass());
        count = 0;
        IntWritable key = new IntWritable();
        Text value = new Text();
        while (seqReader.next((Writable)key, (Writable)value)) {
            TestMRMultipleOutputs.assertEquals((String)SEQUENCE, (String)value.toString());
            ++count;
        }
        seqReader.close();
        TestMRMultipleOutputs.assertFalse((count == 0 ? 1 : 0) != 0);
        if (withCounters) {
            CounterGroup counters = (CounterGroup)job.getCounters().getGroup(MultipleOutputs.class.getName());
            TestMRMultipleOutputs.assertEquals((int)9, (int)counters.size());
            TestMRMultipleOutputs.assertEquals((long)4L, (long)counters.findCounter(TEXT).getValue());
            TestMRMultipleOutputs.assertEquals((long)2L, (long)counters.findCounter(SEQUENCE + "_A").getValue());
            TestMRMultipleOutputs.assertEquals((long)4L, (long)counters.findCounter(SEQUENCE + "_B").getValue());
            TestMRMultipleOutputs.assertEquals((long)2L, (long)counters.findCounter(SEQUENCE + "_C").getValue());
            TestMRMultipleOutputs.assertEquals((long)2L, (long)counters.findCounter("a").getValue());
            TestMRMultipleOutputs.assertEquals((long)2L, (long)counters.findCounter("b").getValue());
            TestMRMultipleOutputs.assertEquals((long)4L, (long)counters.findCounter("c").getValue());
            TestMRMultipleOutputs.assertEquals((long)4L, (long)counters.findCounter("d").getValue());
            TestMRMultipleOutputs.assertEquals((long)4L, (long)counters.findCounter("e").getValue());
        }
    }

    public static class MOReduce
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        private MultipleOutputs mos;

        public void setup(Reducer.Context context) {
            this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        }

        public void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            for (Text value : values) {
                this.mos.write((Object)key, (Object)value, value.toString());
                if (!value.toString().equals("b")) {
                    context.write((Object)key, (Object)value);
                    continue;
                }
                this.mos.write(TEXT, (Object)key, (Object)new Text(TEXT));
                this.mos.write(SEQUENCE, (Object)new IntWritable(2), (Object)new Text(SEQUENCE), SEQUENCE + "_B");
                this.mos.write(SEQUENCE, (Object)new IntWritable(3), (Object)new Text(SEQUENCE), SEQUENCE + "_C");
            }
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.mos.close();
        }
    }

    public static class MOMap
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        private MultipleOutputs mos;

        public void setup(Mapper.Context context) {
            this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)value);
            if (value.toString().equals("a")) {
                this.mos.write(TEXT, (Object)key, (Object)new Text(TEXT));
                this.mos.write(SEQUENCE, (Object)new IntWritable(1), (Object)new Text(SEQUENCE), SEQUENCE + "_A");
                this.mos.write(SEQUENCE, (Object)new IntWritable(2), (Object)new Text(SEQUENCE), SEQUENCE + "_B");
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.mos.close();
        }
    }
}

