/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.ShuffleProviderPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestShufflePlugin {
    @Test
    public void testConsumerPluginAbility() {
        try {
            JobConf jobConf = new JobConf();
            jobConf.setClass("mapreduce.job.reduce.shuffle.consumer.plugin.class", TestShuffleConsumerPlugin.class, ShuffleConsumerPlugin.class);
            ShuffleConsumerPlugin shuffleConsumerPlugin = null;
            Class clazz = jobConf.getClass("mapreduce.job.reduce.shuffle.consumer.plugin.class", null, ShuffleConsumerPlugin.class);
            Assert.assertNotNull((String)"Unable to get mapreduce.job.reduce.shuffle.consumer.plugin.class", (Object)clazz);
            shuffleConsumerPlugin = (ShuffleConsumerPlugin)ReflectionUtils.newInstance((Class)clazz, (Configuration)jobConf);
            Assert.assertNotNull((String)"Unable to load mapreduce.job.reduce.shuffle.consumer.plugin.class", (Object)shuffleConsumerPlugin);
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Threw exception:" + e), (boolean)false);
        }
    }

    @Test
    public void testProviderPluginAbility() {
        try {
            JobConf jobConf = new JobConf();
            jobConf.setClass("mapreduce.shuffle.provider.plugin.classes", TestShuffleProviderPlugin.class, ShuffleProviderPlugin.class);
            ShuffleProviderPlugin shuffleProviderPlugin = null;
            Class clazz = jobConf.getClass("mapreduce.shuffle.provider.plugin.classes", null, ShuffleProviderPlugin.class);
            Assert.assertNotNull((String)"Unable to get mapreduce.shuffle.provider.plugin.classes", (Object)clazz);
            shuffleProviderPlugin = (ShuffleProviderPlugin)ReflectionUtils.newInstance((Class)clazz, (Configuration)jobConf);
            Assert.assertNotNull((String)"Unable to load mapreduce.shuffle.provider.plugin.classes", (Object)shuffleProviderPlugin);
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Threw exception:" + e), (boolean)false);
        }
    }

    @Test
    public void testProvider() {
        ShuffleProviderPlugin mockShuffleProvider = (ShuffleProviderPlugin)Mockito.mock(ShuffleProviderPlugin.class);
        TaskTracker mockTT = (TaskTracker)Mockito.mock(TaskTracker.class);
        TaskController mockTaskController = (TaskController)Mockito.mock(TaskController.class);
        try {
            mockShuffleProvider.initialize(mockTT);
            mockShuffleProvider.destroy();
            mockTT.getJobConf();
            mockTT.getJobConf((JobID)Mockito.mock(JobID.class));
            TaskTracker.getIntermediateOutputDir((String)"", (String)"", (String)"");
            mockTT.getTaskController();
            mockTaskController.getRunAsUser((JobConf)Mockito.mock(JobConf.class));
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Threw exception:" + e), (boolean)false);
        }
    }

    @Test
    public void testConsumer() {
        ShuffleConsumerPlugin mockShuffleConsumer = (ShuffleConsumerPlugin)Mockito.mock(ShuffleConsumerPlugin.class);
        ReduceTask mockReduceTask = (ReduceTask)Mockito.mock(ReduceTask.class);
        JobConf mockJobConf = (JobConf)Mockito.mock(JobConf.class);
        TaskUmbilicalProtocol mockUmbilical = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        Task.TaskReporter mockReporter = (Task.TaskReporter)Mockito.mock(Task.TaskReporter.class);
        LocalFileSystem mockLocalFileSystem = (LocalFileSystem)Mockito.mock(LocalFileSystem.class);
        mockReduceTask.getTaskID();
        mockReduceTask.getJobID();
        mockReduceTask.getNumMaps();
        mockReduceTask.getPartition();
        mockReduceTask.getJobFile();
        mockReduceTask.getJvmContext();
        mockReporter.progress();
        try {
            String[] dirs = mockJobConf.getLocalDirs();
            ShuffleConsumerPlugin.Context context = new ShuffleConsumerPlugin.Context(mockReduceTask, mockUmbilical, mockJobConf, mockReporter);
            mockShuffleConsumer.init(context);
            mockShuffleConsumer.fetchOutputs();
            mockShuffleConsumer.createKVIterator(mockJobConf, mockLocalFileSystem.getRaw(), (Reporter)mockReporter);
            mockShuffleConsumer.close();
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Threw exception:" + e), (boolean)false);
        }
    }

    static class TestShuffleProviderPlugin
    implements ShuffleProviderPlugin {
        TestShuffleProviderPlugin() {
        }

        public void initialize(TaskTracker tt) {
        }

        public void destroy() {
        }
    }

    static class TestShuffleConsumerPlugin
    implements ShuffleConsumerPlugin {
        TestShuffleConsumerPlugin() {
        }

        public void init(ShuffleConsumerPlugin.Context context) {
            context.getReduceTask();
            context.getConf();
            context.getUmbilical();
            context.getReporter();
        }

        public boolean fetchOutputs() throws IOException {
            return true;
        }

        public Throwable getMergeThrowable() {
            return null;
        }

        public RawKeyValueIterator createKVIterator(JobConf job, FileSystem fs, Reporter reporter) throws IOException {
            return null;
        }

        public void close() {
        }
    }
}

