/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.log4j.Level;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestUmbilicalProtocolWithJobToken {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestUmbilicalProtocolWithJobToken.class);
    private static Configuration conf = new Configuration();

    @Test
    public void testJobTokenRpc() throws Exception {
        TaskUmbilicalProtocol mockTT = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        Mockito.when((Object)mockTT.getProtocolVersion(Matchers.anyString(), Matchers.anyLong())).thenReturn((Object)18L);
        JobTokenSecretManager sm = new JobTokenSecretManager();
        RPC.Server server = new RPC.Builder(conf).setBindAddress(ADDRESS).setPort(0).setInstance((Object)mockTT).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        String jobId = current.getUserName();
        JobTokenIdentifier tokenId = new JobTokenIdentifier(new Text(jobId));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        sm.addTokenForJob(jobId, token);
        Text host = new Text(addr.getAddress().getHostAddress() + ":" + addr.getPort());
        token.setService(host);
        LOG.info((Object)("Service IP address for token is " + host));
        current.addToken(token);
        current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                TaskUmbilicalProtocol proxy = null;
                try {
                    proxy = (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, (long)18L, (InetSocketAddress)addr, (Configuration)conf);
                    proxy.ping(null, null);
                }
                finally {
                    this.val$server.stop();
                    if (proxy != null) {
                        RPC.stopProxy((Object)proxy);
                    }
                }
                return null;
            }
        });
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
    }
}

