/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskChildOptsParsing {
    private static final TaskAttemptID TASK_ID = new TaskAttemptID();
    private static final String[] EXPECTED_RESULTS = new String[]{"-Dfoo=bar", "-Dbaz=biz"};

    private void performTest(String input) {
        Object[] result = TaskRunner.parseChildJavaOpts((String)input, (TaskAttemptID)TASK_ID);
        Assert.assertArrayEquals((Object[])EXPECTED_RESULTS, (Object[])result);
    }

    @Test
    public void testParseChildJavaOptsLeadingSpace() {
        this.performTest(" -Dfoo=bar -Dbaz=biz");
    }

    @Test
    public void testParseChildJavaOptsTrailingSpace() {
        this.performTest("-Dfoo=bar -Dbaz=biz ");
    }

    @Test
    public void testParseChildJavaOptsOneSpace() {
        this.performTest("-Dfoo=bar -Dbaz=biz");
    }

    @Test
    public void testParseChildJavaOptsMulitpleSpaces() {
        this.performTest("-Dfoo=bar  -Dbaz=biz");
    }

    @Test
    public void testParseChildJavaOptsOneTab() {
        this.performTest("-Dfoo=bar\t-Dbaz=biz");
    }

    @Test
    public void testParseChildJavaOptsMultipleTabs() {
        this.performTest("-Dfoo=bar\t\t-Dbaz=biz");
    }
}

