/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.UtilsForTests;

public class TestJobKillAndFail
extends TestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobFailAndKill() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf jtConf = new JobConf();
            jtConf.set("mapred.jobtracker.instrumentation", JTInstrumentation.class.getName());
            mr = new MiniMRCluster(2, "file:///", 3, null, null, jtConf);
            JTInstrumentation instr = (JTInstrumentation)mr.getJobTrackerRunner().getJobTracker().getInstrumentation();
            JobConf conf = mr.createJobConf();
            Path inDir = new Path(TEST_ROOT_DIR + "/failkilljob/input");
            Path outDir = new Path(TEST_ROOT_DIR + "/failkilljob/output");
            RunningJob job = UtilsForTests.runJobFail(conf, inDir, outDir);
            TestJobKillAndFail.assertEquals((int)job.getJobState(), (int)3);
            TestJobKillAndFail.assertTrue((boolean)instr.verifyJob());
            TestJobKillAndFail.assertEquals((int)1, (int)instr.failed);
            instr.reset();
            job = UtilsForTests.runJobKill(conf, inDir, outDir);
            TestJobKillAndFail.assertTrue((boolean)job.isComplete());
            TestJobKillAndFail.assertEquals((int)job.getJobState(), (int)5);
            TestJobKillAndFail.assertTrue((boolean)instr.verifyJob());
            TestJobKillAndFail.assertEquals((int)1, (int)instr.killed);
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static class JTInstrumentation
    extends JobTrackerInstrumentation {
        volatile int failed;
        volatile int killed;
        volatile int addPrep;
        volatile int decPrep;
        volatile int addRunning;
        volatile int decRunning;

        void reset() {
            this.failed = 0;
            this.killed = 0;
            this.addPrep = 0;
            this.decPrep = 0;
            this.addRunning = 0;
            this.decRunning = 0;
        }

        boolean verifyJob() {
            return this.addPrep == 1 && this.decPrep == 1 && this.addRunning == 1 && this.decRunning == 1;
        }

        public JTInstrumentation(JobTracker jt, JobConf conf) {
            super(jt, conf);
        }

        public synchronized void addPrepJob(JobConf conf, JobID id) {
            ++this.addPrep;
        }

        public synchronized void decPrepJob(JobConf conf, JobID id) {
            ++this.decPrep;
        }

        public synchronized void addRunningJob(JobConf conf, JobID id) {
            ++this.addRunning;
        }

        public synchronized void decRunningJob(JobConf conf, JobID id) {
            ++this.decRunning;
        }

        public synchronized void failedJob(JobConf conf, JobID id) {
            ++this.failed;
        }

        public synchronized void killedJob(JobConf conf, JobID id) {
            ++this.killed;
        }
    }
}

