/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.mortbay.util.ajax.JSON;

public class MiniHadoopClusterManager {
    private static final Log LOG = LogFactory.getLog(MiniHadoopClusterManager.class);
    private MiniMRCluster mrc;
    private MiniDFSCluster dfs;
    private String writeDetails;
    private int numTaskTrackers;
    private int numDataNodes;
    private int nameNodePort;
    private int jobTrackerPort;
    private int taskTrackerPort;
    private HdfsServerConstants.StartupOption dfsOpts;
    private boolean noDFS;
    private boolean noMR;
    private boolean useLoopBackHosts;
    private String fs;
    private String writeConfig;
    private JobConf conf;

    private Options makeOptions() {
        Options options = new Options();
        Options options2 = options.addOption("nodfs", false, "Don't start a mini DFS cluster").addOption("nomr", false, "Don't start a mini MR cluster").addOption("useloopbackhosts", false, "Set TaskTracker hostnames to 127.0.1.N").addOption("tasktrackers", true, "How many tasktrackers to start (default 1)").addOption("datanodes", true, "How many datanodes to start (default 1)").addOption("format", false, "Format the DFS (default false)").addOption("cmdport", true, "Which port to listen on for commands (default 0--we choose)").addOption("nnport", true, "NameNode port (default 0--we choose)").addOption("namenode", true, "URL of the namenode (default is either the DFS cluster or a temporary dir)").addOption("tasktrackerport", true, "Port number to start the tasktracker on (default 0--we choose)").addOption("jobtrackerport", true, "JobTracker port (default 0--we choose)");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withDescription((String)"Options to pass into configuration object");
        Options options3 = options2.addOption(OptionBuilder.create((String)"D"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Save configuration to this XML file.");
        Options options4 = options3.addOption(OptionBuilder.create((String)"writeConfig"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Write basic information to this JSON file.");
        Options options5 = options4.addOption(OptionBuilder.create((String)"writeDetails"));
        OptionBuilder.withDescription((String)"Prints option help.");
        options5.addOption(OptionBuilder.create((String)"help"));
        return options;
    }

    public void run(String[] args) throws IOException {
        if (!this.parseArguments(args)) {
            return;
        }
        this.start();
        this.sleepForever();
    }

    private void sleepForever() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void start() throws IOException, FileNotFoundException {
        if (!this.noDFS) {
            this.dfs = new MiniDFSCluster(this.nameNodePort, (Configuration)this.conf, this.numDataNodes, true, true, this.dfsOpts, null, null);
            LOG.info((Object)("Started MiniDFSCluster -- namenode on port " + this.dfs.getNameNodePort()));
        }
        if (!this.noMR) {
            if (this.fs == null && this.dfs != null) {
                this.fs = this.dfs.getFileSystem().getUri().toString();
            } else if (this.fs == null) {
                this.fs = "file:///tmp/minimr-" + System.nanoTime();
            }
            String[] hosts = null;
            if (this.useLoopBackHosts) {
                hosts = new String[this.numTaskTrackers];
                for (int i = 0; i < this.numTaskTrackers; ++i) {
                    hosts[i] = "127.0.1." + (i + 1);
                }
            }
            this.mrc = new MiniMRCluster(this.jobTrackerPort, this.taskTrackerPort, this.numTaskTrackers, this.fs, 1, null, hosts, null, this.conf);
            LOG.info((Object)("Started MiniMRCluster  -- jobtracker on port " + this.mrc.getJobTrackerPort()));
        }
        if (this.writeConfig != null) {
            FileOutputStream fos = new FileOutputStream(new File(this.writeConfig));
            this.conf.writeXml((OutputStream)fos);
            fos.close();
        }
        if (this.writeDetails != null) {
            TreeMap<String, Integer> map = new TreeMap<String, Integer>();
            if (this.dfs != null) {
                map.put("namenode_port", this.dfs.getNameNodePort());
            }
            if (this.mrc != null) {
                map.put("jobtracker_port", this.mrc.getJobTrackerPort());
            }
            FileWriter fw = new FileWriter(new File(this.writeDetails));
            fw.write(new JSON().toJSON(map));
            fw.close();
        }
    }

    public void stop() {
        if (this.mrc != null) {
            this.mrc.shutdown();
        }
        if (this.dfs != null) {
            this.dfs.shutdown();
        }
    }

    private boolean parseArguments(String[] args) {
        String[] arr$;
        int len$;
        int i$;
        CommandLine cli;
        Options options = this.makeOptions();
        try {
            GnuParser parser = new GnuParser();
            cli = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.warn((Object)("options parsing failed:  " + e.getMessage()));
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        if (cli.hasOption("help")) {
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        if (cli.getArgs().length > 0 && (i$ = 0) < (len$ = (arr$ = cli.getArgs()).length)) {
            String arg = arr$[i$];
            System.err.println("Unrecognized option: " + arg);
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        this.noMR = cli.hasOption("nomr");
        this.numTaskTrackers = this.intArgument(cli, "tasktrackers", 1);
        this.jobTrackerPort = this.intArgument(cli, "jobtrackerport", 0);
        this.taskTrackerPort = this.intArgument(cli, "tasktrackerport", 0);
        this.fs = cli.getOptionValue("namenode");
        this.useLoopBackHosts = cli.hasOption("useloopbackhosts");
        this.noDFS = cli.hasOption("nodfs");
        this.numDataNodes = this.intArgument(cli, "datanodes", 1);
        this.nameNodePort = this.intArgument(cli, "nnport", 0);
        this.dfsOpts = cli.hasOption("format") ? HdfsServerConstants.StartupOption.FORMAT : HdfsServerConstants.StartupOption.REGULAR;
        this.writeDetails = cli.getOptionValue("writeDetails");
        this.writeConfig = cli.getOptionValue("writeConfig");
        this.conf = new JobConf();
        this.updateConfiguration(this.conf, cli.getOptionValues("D"));
        return true;
    }

    private void updateConfiguration(JobConf conf, String[] keyvalues) {
        int num_confs_updated = 0;
        if (keyvalues != null) {
            for (String prop : keyvalues) {
                String[] keyval = prop.split("=", 2);
                if (keyval.length == 2) {
                    conf.set(keyval[0], keyval[1]);
                    ++num_confs_updated;
                    continue;
                }
                LOG.warn((Object)("Ignoring -D option " + prop));
            }
        }
        LOG.info((Object)("Updated " + num_confs_updated + " configuration settings from command line."));
    }

    private int intArgument(CommandLine cli, String argName, int default_) {
        String o = cli.getOptionValue(argName);
        if (o == null) {
            return default_;
        }
        return Integer.parseInt(o);
    }

    public static void main(String[] args) throws IOException {
        new MiniHadoopClusterManager().run(args);
    }
}

