/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.mapred.ClusterWithLinuxTaskController;
import org.apache.hadoop.mapred.LinuxTaskController;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.util.Shell;

public class TestLinuxTaskController
extends TestCase {
    private static int INVALID_TASKCONTROLLER_PERMISSIONS = 22;
    private static int INVALID_CONFIG_FILE = 24;
    private static String TASKCONTROLLER_INVALID_GROUP = "taskcontroller-invalid-group";
    private static File testDir = new File(System.getProperty("test.build.data", "/tmp"), TestLinuxTaskController.class.getName());
    private static String taskControllerPath = System.getProperty("taskcontroller-path");

    protected void setUp() throws Exception {
        testDir.mkdirs();
    }

    protected void tearDown() throws Exception {
        FileUtil.fullyDelete((File)testDir);
    }

    private void validateTaskControllerSetup(Configuration conf, TaskController controller, boolean shouldFail, int exitCode) throws IOException {
        File confFile = ClusterWithLinuxTaskController.createTaskControllerConf(taskControllerPath, conf);
        TestLinuxTaskController.execCommand(confFile, "sudo", "chown", "root");
        if (shouldFail) {
            IOException th = null;
            try {
                controller.setup(new LocalDirAllocator("mapred.local.dir"));
            }
            catch (IOException ie) {
                th = ie;
            }
            TestLinuxTaskController.assertNotNull((String)"No exception during setup", (Object)th);
            TestLinuxTaskController.assertTrue((String)("Exception message does not contain exit code " + exitCode), (boolean)th.getMessage().contains("with exit code " + exitCode));
        } else {
            controller.setup(new LocalDirAllocator("mapred.local.dir"));
        }
        TestLinuxTaskController.execCommand(confFile, "sudo", "rm");
    }

    public void testTaskControllerGroup() throws Exception {
        if (!ClusterWithLinuxTaskController.isTaskExecPathPassed()) {
            return;
        }
        ClusterWithLinuxTaskController.getTaskControllerConfFile(taskControllerPath).delete();
        Configuration conf = new Configuration();
        File mapredLocal = new File(testDir, "mapred/local");
        mapredLocal.mkdirs();
        conf.set("mapred.local.dir", mapredLocal.toString());
        MyLinuxTaskController controller = new MyLinuxTaskController();
        controller.setConf(conf);
        this.validateTaskControllerSetup(conf, (TaskController)controller, true, INVALID_CONFIG_FILE);
        conf.set(ClusterWithLinuxTaskController.TT_GROUP, System.getProperty(TASKCONTROLLER_INVALID_GROUP));
        this.validateTaskControllerSetup(conf, (TaskController)controller, true, INVALID_TASKCONTROLLER_PERMISSIONS);
        conf.set(ClusterWithLinuxTaskController.TT_GROUP, ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
        this.validateTaskControllerSetup(conf, (TaskController)controller, false, 0);
    }

    private static String execCommand(File f, String ... cmd) throws IOException {
        String[] args = new String[cmd.length + 1];
        System.arraycopy(cmd, 0, args, 0, cmd.length);
        args[cmd.length] = f.getCanonicalPath();
        String output = Shell.execCommand((String[])args);
        return output;
    }

    public static class MyLinuxTaskController
    extends LinuxTaskController {
        public void setConf(Configuration conf) {
            super.setConf(conf);
            this.taskControllerExe = taskControllerPath + "/task-controller";
        }
    }
}

