/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.hadoop.util.PluginDispatcher;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.SingleArgumentRunnable;

public class TestPluginDispatcher
extends TestCase {
    public void testDispatch() {
        AtomicInteger runCount = new AtomicInteger(0);
        List<TestPlugin> plugins = Arrays.asList(new TestPlugin(runCount));
        PluginDispatcher dispatcher = new PluginDispatcher(plugins, (Executor)new SameThreadExecutor());
        dispatcher.dispatchCall((SingleArgumentRunnable)new RunMethodRunner());
        TestPluginDispatcher.assertEquals((int)runCount.get(), (int)1);
    }

    public void testRemovalOnStartError() {
        AtomicInteger runCount = new AtomicInteger(0);
        List<TestPlugin> plugins = Arrays.asList(new TestPlugin(runCount), new FaultyPlugin(runCount), new TestPlugin(runCount));
        PluginDispatcher dispatcher = new PluginDispatcher(plugins, (Executor)new SameThreadExecutor());
        dispatcher.dispatchCall((SingleArgumentRunnable)new RunMethodRunner());
        TestPluginDispatcher.assertEquals((int)runCount.get(), (int)3);
        runCount.set(0);
        dispatcher.dispatchStart((Object)this);
        dispatcher.dispatchCall((SingleArgumentRunnable)new RunMethodRunner());
        TestPluginDispatcher.assertEquals((int)runCount.get(), (int)2);
    }

    public static class SameThreadExecutor
    implements Executor {
        @Override
        public void execute(Runnable r) {
            r.run();
        }
    }

    public static class FaultyPlugin
    extends TestPlugin {
        public FaultyPlugin(AtomicInteger ai) {
            super(ai);
        }

        @Override
        public void start(Object service) {
            throw new RuntimeException("Kaboom!");
        }
    }

    public static class TestPlugin
    implements ServicePlugin {
        final AtomicInteger ai;

        public TestPlugin(AtomicInteger ai) {
            this.ai = ai;
        }

        public void start(Object service) {
        }

        public void stop() {
        }

        public void close() {
        }

        public void run() {
            this.ai.getAndIncrement();
        }
    }

    static class RunMethodRunner
    implements SingleArgumentRunnable<TestPlugin> {
        RunMethodRunner() {
        }

        public void run(TestPlugin p) {
            p.run();
        }
    }
}

