/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestConcurrentRead {
    static final List<LoggedJob> cachedTrace = new ArrayList<LoggedJob>();
    static final String traceFile = "rumen/small-trace-test/job-tracker-logs-trace-output.gz";
    static Configuration conf;
    static FileSystem lfs;
    static Path path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void globalSetUp() throws IOException {
        conf = new Configuration();
        lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified(lfs);
        path = new Path(rootInputDir, traceFile);
        JobTraceReader reader = new JobTraceReader(path, conf);
        try {
            LoggedJob job;
            while ((job = (LoggedJob)reader.getNext()) != null) {
                cachedTrace.add(job);
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readAndCompare() throws IOException {
        JobTraceReader reader = new JobTraceReader(path, conf);
        try {
            for (LoggedJob jobExpected : cachedTrace) {
                LoggedJob jobRead = (LoggedJob)reader.getNext();
                Assert.assertNotNull((Object)jobRead);
                try {
                    jobRead.deepCompare((DeepCompare)jobExpected, null);
                }
                catch (DeepInequalityException e) {
                    Assert.fail((String)e.toString());
                }
            }
            Assert.assertNull((Object)reader.getNext());
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testConcurrentRead() throws InterruptedException {
        int nThr = conf.getInt("test.rumen.concurrent-read.threads", 4);
        int repeat = conf.getInt("test.rumen.concurrent-read.repeat", 10);
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(nThr);
        Map<String, Throwable> errors = Collections.synchronizedMap(new TreeMap());
        for (int i = 0; i < nThr; ++i) {
            new TestThread(i, repeat, startSignal, doneSignal, errors).start();
        }
        startSignal.countDown();
        doneSignal.await();
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Throwable> e : errors.entrySet()) {
                sb.append(String.format("%s:\n%s\n", e.getKey(), e.getValue().toString()));
            }
            Assert.fail((String)sb.toString());
        }
    }

    class TestThread
    extends Thread {
        final int repeat;
        final CountDownLatch startSignal;
        final CountDownLatch doneSignal;
        final Map<String, Throwable> errors;

        TestThread(int id, int repeat, CountDownLatch startSignal, CountDownLatch doneSignal, Map<String, Throwable> errors) {
            super(String.format("TestThread-%d", id));
            this.repeat = repeat;
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
            this.errors = errors;
        }

        @Override
        public void run() {
            try {
                this.startSignal.await();
                for (int i = 0; i < this.repeat; ++i) {
                    try {
                        TestConcurrentRead.this.readAndCompare();
                        continue;
                    }
                    catch (Throwable e) {
                        this.errors.put(this.getName(), e);
                        break;
                    }
                }
                this.doneSignal.countDown();
            }
            catch (Throwable e) {
                this.errors.put(this.getName(), e);
            }
        }
    }
}

