/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.TestTrackerDistributedCacheManager;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterWithLinuxTaskController;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TestTaskTrackerLocalization;
import org.apache.hadoop.security.UserGroupInformation;

public class TestTrackerDistributedCacheManagerWithLinuxTaskController
extends TestTrackerDistributedCacheManager {
    private File configFile;
    private static final Log LOG = LogFactory.getLog(TestTrackerDistributedCacheManagerWithLinuxTaskController.class);

    @Override
    protected void setUp() throws IOException, InterruptedException {
        if (!ClusterWithLinuxTaskController.shouldRun()) {
            return;
        }
        this.TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp"), TestTrackerDistributedCacheManagerWithLinuxTaskController.class.getSimpleName()).getAbsolutePath();
        super.setUp();
        this.taskController = new ClusterWithLinuxTaskController.MyLinuxTaskController();
        String path = System.getProperty("taskcontroller-path");
        String execPath = path + "/task-controller";
        ((ClusterWithLinuxTaskController.MyLinuxTaskController)this.taskController).setTaskControllerExe(execPath);
        this.taskController.setConf(this.conf);
        this.taskController.setup(new LocalDirAllocator("mapred.local.dir"));
    }

    @Override
    protected void refreshConf(Configuration conf) throws IOException {
        super.refreshConf(conf);
        String path = System.getProperty("taskcontroller-path");
        this.configFile = ClusterWithLinuxTaskController.createTaskControllerConf(path, conf);
    }

    @Override
    protected void tearDown() throws IOException {
        if (!ClusterWithLinuxTaskController.shouldRun()) {
            return;
        }
        if (this.configFile != null) {
            this.configFile.delete();
        }
        super.tearDown();
    }

    @Override
    protected boolean canRun() {
        return ClusterWithLinuxTaskController.shouldRun();
    }

    @Override
    protected String getJobOwnerName() {
        String ugi = System.getProperty("taskcontroller-ugi");
        String userName = ugi.split(",")[0];
        return userName;
    }

    @Override
    protected void checkFilePermissions(Path[] localCacheFiles) throws IOException {
        String userName = this.getJobOwnerName();
        String filePermissions = UserGroupInformation.getLoginUser().getShortUserName().equals(userName) ? "-rwxrwx---" : "-r-xrwx---";
        for (Path p : localCacheFiles) {
            TestTaskTrackerLocalization.checkFilePermissions(p.toUri().getPath(), filePermissions, userName, ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
            this.checkPermissionOnPathComponents(p.toUri().getPath(), userName);
        }
    }

    private void checkPermissionOnPathComponents(String cachedFilePath, String userName) throws IOException {
        String trailingStringForFirstFile = cachedFilePath.replaceFirst(this.ROOT_MAPRED_LOCAL_DIR.getAbsolutePath() + "/" + "0_[0-" + (this.numLocalDirs - 1) + "]" + "/" + TaskTracker.getPrivateDistributedCacheDir((String)userName), "");
        LOG.info((Object)("Trailing path for cacheFirstFile is : " + trailingStringForFirstFile));
        String leadingStringForFirstFile = cachedFilePath.substring(0, cachedFilePath.lastIndexOf(trailingStringForFirstFile));
        LOG.info((Object)("Leading path for cacheFirstFile is : " + leadingStringForFirstFile));
        String dirPermissions = UserGroupInformation.getLoginUser().getShortUserName().equals(userName) ? "drwxrws---" : "dr-xrws---";
        File path = new File(cachedFilePath).getParentFile();
        while (!path.getAbsolutePath().equals(leadingStringForFirstFile)) {
            TestTaskTrackerLocalization.checkFilePermissions(path.getAbsolutePath(), dirPermissions, userName, ClusterWithLinuxTaskController.taskTrackerSpecialGroup);
            path = path.getParentFile();
        }
    }
}

