/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;

public class TestDFSStartupVersions
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSStartupVersions");
    private static Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp").toString().replace(' ', '+'));
    private MiniDFSCluster cluster = null;

    void log(String label, HdfsConstants.NodeType nodeType, Integer testCase, StorageInfo version) {
        String testCaseLine = "";
        if (testCase != null) {
            testCaseLine = " testCase=" + testCase;
        }
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST*** " + label + ":" + testCaseLine + " nodeType=" + nodeType + " layoutVersion=" + version.getLayoutVersion() + " namespaceID=" + version.getNamespaceID() + " fsscTime=" + version.getCTime()));
    }

    private StorageInfo[] initializeVersions() throws Exception {
        int layoutVersionOld = -7;
        int layoutVersionCur = UpgradeUtilities.getCurrentLayoutVersion();
        int layoutVersionNew = Integer.MIN_VALUE;
        int namespaceIdCur = UpgradeUtilities.getCurrentNamespaceID(null);
        int namespaceIdOld = Integer.MIN_VALUE;
        long fsscTimeOld = Long.MIN_VALUE;
        long fsscTimeCur = UpgradeUtilities.getCurrentFsscTime(null);
        long fsscTimeNew = Long.MAX_VALUE;
        return new StorageInfo[]{new StorageInfo(layoutVersionOld, namespaceIdCur, fsscTimeOld), new StorageInfo(layoutVersionOld, namespaceIdCur, fsscTimeCur), new StorageInfo(layoutVersionOld, namespaceIdCur, fsscTimeNew), new StorageInfo(layoutVersionOld, namespaceIdOld, fsscTimeOld), new StorageInfo(layoutVersionOld, namespaceIdOld, fsscTimeCur), new StorageInfo(layoutVersionOld, namespaceIdOld, fsscTimeNew), new StorageInfo(layoutVersionCur, namespaceIdCur, fsscTimeOld), new StorageInfo(layoutVersionCur, namespaceIdCur, fsscTimeCur), new StorageInfo(layoutVersionCur, namespaceIdCur, fsscTimeNew), new StorageInfo(layoutVersionCur, namespaceIdOld, fsscTimeOld), new StorageInfo(layoutVersionCur, namespaceIdOld, fsscTimeCur), new StorageInfo(layoutVersionCur, namespaceIdOld, fsscTimeNew), new StorageInfo(layoutVersionNew, namespaceIdCur, fsscTimeOld), new StorageInfo(layoutVersionNew, namespaceIdCur, fsscTimeCur), new StorageInfo(layoutVersionNew, namespaceIdCur, fsscTimeNew), new StorageInfo(layoutVersionNew, namespaceIdOld, fsscTimeOld), new StorageInfo(layoutVersionNew, namespaceIdOld, fsscTimeCur), new StorageInfo(layoutVersionNew, namespaceIdOld, fsscTimeNew)};
    }

    boolean isVersionCompatible(StorageInfo namenodeVer, StorageInfo datanodeVer) {
        long absStoredLV;
        if (namenodeVer.getNamespaceID() != datanodeVer.getNamespaceID()) {
            LOG.info((Object)"namespaceIDs are not equal: isVersionCompatible=false");
            return false;
        }
        int softwareLV = -19;
        int storedLV = datanodeVer.getLayoutVersion();
        if (softwareLV == storedLV && datanodeVer.getCTime() == namenodeVer.getCTime()) {
            LOG.info((Object)"layoutVersions and cTimes are equal: isVersionCompatible=true");
            return true;
        }
        long absSoftwareLV = Math.abs((long)softwareLV);
        if (absSoftwareLV > (absStoredLV = Math.abs((long)storedLV)) || softwareLV == storedLV && datanodeVer.getCTime() < namenodeVer.getCTime()) {
            LOG.info((Object)"softwareLayoutVersion is newer OR namenode cTime is newer: isVersionCompatible=true");
            return true;
        }
        LOG.info((Object)"default case: isVersionCompatible=false");
        return false;
    }

    public void testVersions() throws Exception {
        UpgradeUtilities.initialize();
        Configuration conf = UpgradeUtilities.initializeStorageStateConf(1, new Configuration());
        StorageInfo[] versions = this.initializeVersions();
        UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, conf.getStrings("dfs.name.dir"), "current");
        this.cluster = new MiniDFSCluster(conf, 0, HdfsConstants.StartupOption.REGULAR);
        StorageInfo nameNodeVersion = new StorageInfo(UpgradeUtilities.getCurrentLayoutVersion(), UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentFsscTime(this.cluster));
        this.log("NameNode version info", HdfsConstants.NodeType.NAME_NODE, null, nameNodeVersion);
        for (int i = 0; i < versions.length; ++i) {
            File[] storage = UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, conf.getStrings("dfs.data.dir"), "current");
            this.log("DataNode version info", HdfsConstants.NodeType.DATA_NODE, i, versions[i]);
            UpgradeUtilities.createVersionFile(HdfsConstants.NodeType.DATA_NODE, storage, versions[i]);
            try {
                this.cluster.startDataNodes(conf, 1, false, HdfsConstants.StartupOption.REGULAR, null);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            TestDFSStartupVersions.assertTrue((this.cluster.getNameNode() != null ? 1 : 0) != 0);
            TestDFSStartupVersions.assertEquals((boolean)this.isVersionCompatible(nameNodeVersion, versions[i]), (boolean)this.cluster.isDataNodeUp());
            this.cluster.shutdownDataNodes();
        }
    }

    protected void tearDown() throws Exception {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDFSStartupVersions().testVersions();
    }
}

