/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;

public class TestFileAppend
extends TestCase {
    static final int blockSize = 1024;
    static final int numBlocks = 10;
    static final int fileSize = 10241;
    boolean simulatedStorage = false;
    private long seed;
    private byte[] fileContents = null;

    private void initBuffer(int size) {
        this.seed = AppendTestUtil.nextLong();
        this.fileContents = AppendTestUtil.randomBytes(this.seed, size);
    }

    private FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 1024L);
        return stm;
    }

    private void writeFile(FSDataOutputStream stm) throws IOException {
        byte[] buffer = AppendTestUtil.randomBytes(this.seed, 10241);
        stm.write(buffer);
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        int i;
        boolean done = false;
        block2: while (!done) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            done = true;
            BlockLocation[] locations = fileSys.getFileBlockLocations(fileSys.getFileStatus(name), 0L, 10241L);
            if (locations.length < 10) {
                System.out.println("Number of blocks found " + locations.length);
                done = false;
                continue;
            }
            for (int idx = 0; idx < 10; ++idx) {
                if (locations[idx].getHosts().length >= repl) continue;
                System.out.println("Block index " + idx + " not yet replciated.");
                done = false;
                continue block2;
            }
        }
        FSDataInputStream stm = fileSys.open(name);
        byte[] expected = new byte[10240];
        if (this.simulatedStorage) {
            for (i = 0; i < expected.length; ++i) {
                expected[i] = 9;
            }
        } else {
            for (i = 0; i < expected.length; ++i) {
                expected[i] = this.fileContents[i];
            }
        }
        byte[] actual = new byte[10240];
        stm.readFully(0L, actual);
        this.checkData(actual, 0, expected, "Read 1");
    }

    private void checkFullFile(FileSystem fs, Path name) throws IOException {
        FSDataInputStream stm = fs.open(name);
        byte[] actual = new byte[10241];
        stm.readFully(0L, actual);
        this.checkData(actual, 0, this.fileContents, "Read 2");
        stm.close();
    }

    private void checkData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            TestFileAppend.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (byte)expected[from + idx], (byte)actual[idx]);
            actual[idx] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyOnWrite() throws IOException {
        Configuration conf = new Configuration();
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, conf);
        try {
            Block b;
            int i;
            Path file1 = new Path("/filestatus.dat");
            FSDataOutputStream stm = this.createFile(fs, file1, 1);
            this.writeFile(stm);
            stm.close();
            DataNode[] dn = cluster.listDataNodes();
            TestFileAppend.assertTrue((String)("There should be only one datanode but found " + dn.length), (dn.length == 1 ? 1 : 0) != 0);
            LocatedBlocks locations = client.namenode.getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            List blocks = locations.getLocatedBlocks();
            FSDataset dataset = (FSDataset)dn[0].data;
            for (i = 0; i < blocks.size(); i += 2) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                FSDataset fsd = dataset;
                File f = fsd.getFile(b);
                File link = new File(f.toString() + ".link");
                System.out.println("Creating hardlink for File " + f + " to " + link);
                FileUtil.HardLink.createHardLink((File)f, (File)link);
            }
            for (i = 0; i < blocks.size(); ++i) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                System.out.println("testCopyOnWrite detaching block " + b);
                TestFileAppend.assertTrue((String)("Detaching block " + b + " should have returned true"), (dataset.detachBlock(b, 1) ? 1 : 0) != 0);
            }
            for (i = 0; i < blocks.size(); ++i) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                System.out.println("testCopyOnWrite detaching block " + b);
                TestFileAppend.assertTrue((String)("Detaching block " + b + " should have returned false"), (!dataset.detachBlock(b, 1) ? 1 : 0) != 0);
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    public void testSimpleFlush() throws IOException {
        Configuration conf = new Configuration();
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        this.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/simpleFlush.dat");
            FSDataOutputStream stm = this.createFile(fs, file1, 1);
            System.out.println("Created file simpleFlush.dat");
            int mid = 5120;
            stm.write(this.fileContents, 0, mid);
            stm.sync();
            System.out.println("Wrote and Flushed first part of file.");
            stm.write(this.fileContents, mid, 10241 - mid);
            System.out.println("Written second part of file");
            stm.sync();
            stm.sync();
            System.out.println("Wrote and Flushed second part of file.");
            this.checkFile(fs, file1, 1);
            stm.close();
            System.out.println("Closed file.");
            this.checkFullFile(fs, file1);
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    public void testComplexFlush() throws IOException {
        Configuration conf = new Configuration();
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        this.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/complexFlush.dat");
            FSDataOutputStream stm = this.createFile(fs, file1, 1);
            System.out.println("Created file complexFlush.dat");
            int start = 0;
            start = 0;
            while (start + 29 < 10241) {
                stm.write(this.fileContents, start, 29);
                stm.sync();
                start += 29;
            }
            stm.write(this.fileContents, start, 10241 - start);
            this.checkFile(fs, file1, 1);
            stm.close();
            this.checkFullFile(fs, file1);
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

