/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableUtils;

public class TestWritableUtils
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestWritableUtils.class);

    public static void testValue(int val, int vintlen) throws IOException {
        DataOutputBuffer buf = new DataOutputBuffer();
        DataInputBuffer inbuf = new DataInputBuffer();
        WritableUtils.writeVInt((DataOutput)buf, (int)val);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value = " + val));
            BytesWritable printer = new BytesWritable();
            printer.set(buf.getData(), 0, buf.getLength());
            LOG.debug((Object)("Buffer = " + printer));
        }
        inbuf.reset(buf.getData(), 0, buf.getLength());
        TestWritableUtils.assertEquals((int)val, (int)WritableUtils.readVInt((DataInput)inbuf));
        TestWritableUtils.assertEquals((int)vintlen, (int)buf.getLength());
        TestWritableUtils.assertEquals((int)vintlen, (int)WritableUtils.getVIntSize((long)val));
        TestWritableUtils.assertEquals((int)vintlen, (int)WritableUtils.decodeVIntSize((byte)buf.getData()[0]));
    }

    public static void testVInt() throws Exception {
        TestWritableUtils.testValue(12, 1);
        TestWritableUtils.testValue(127, 1);
        TestWritableUtils.testValue(-112, 1);
        TestWritableUtils.testValue(-113, 2);
        TestWritableUtils.testValue(-128, 2);
        TestWritableUtils.testValue(128, 2);
        TestWritableUtils.testValue(-129, 2);
        TestWritableUtils.testValue(255, 2);
        TestWritableUtils.testValue(-256, 2);
        TestWritableUtils.testValue(256, 3);
        TestWritableUtils.testValue(-257, 3);
        TestWritableUtils.testValue(65535, 3);
        TestWritableUtils.testValue(-65536, 3);
        TestWritableUtils.testValue(65536, 4);
        TestWritableUtils.testValue(-65537, 4);
    }
}

